/*
 * Decompiled with CFR 0.152.
 */
package mobi.oneway.sdk.port;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import android.widget.Toast;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mobi.oneway.sdk.b.a;
import mobi.oneway.sdk.c.g;
import mobi.oneway.sdk.c.t;
import mobi.oneway.sdk.d.n;
import mobi.oneway.sdk.d.y;
import mobi.oneway.sdk.data.e;
import mobi.oneway.sdk.e.i;
import mobi.oneway.sdk.e.l;
import mobi.oneway.sdk.port.Unit;
import mobi.oneway.sdk.views.c;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Intent {
    private static String appStorePackageName = "";
    private static boolean isReceiverRegistered = false;
    private static final HashMap<Long, HashMap<String, String>> downloadInfoMap = new HashMap();
    private static boolean isShowGooglePlayButton = false;
    private static final BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, android.content.Intent intent) {
            try {
                Intent.onDownloadComplete(context, intent);
            }
            catch (Throwable throwable) {
                n.a("exception on download receiver.", new Exception(throwable));
            }
        }
    };

    private static Activity getStartingActivity() {
        if (Unit.getActAdShow() != null) {
            return Unit.getActAdShow();
        }
        if (a.a() != null) {
            return a.a();
        }
        return null;
    }

    private static boolean setExtra(android.content.Intent intent, String string2, Object object) {
        if (object instanceof String) {
            intent.putExtra(string2, (String)object);
        } else if (object instanceof Integer) {
            intent.putExtra(string2, ((Integer)object).intValue());
        } else if (object instanceof Double) {
            intent.putExtra(string2, ((Double)object).doubleValue());
        } else if (object instanceof Boolean) {
            intent.putExtra(string2, ((Boolean)object).booleanValue());
        } else {
            n.c("Unable to parse launch intent extra " + string2);
            return false;
        }
        return true;
    }

    private static boolean setCategories(android.content.Intent intent, JSONArray jSONArray) {
        if (jSONArray == null || jSONArray.length() == 0) {
            return true;
        }
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            try {
                intent.addCategory(jSONArray.getString(i2));
                continue;
            }
            catch (Exception exception) {
                n.a("Couldn't parse categories for intent", exception);
                return false;
            }
        }
        return true;
    }

    @l
    public static boolean launch(JSONObject jSONObject) {
        try {
            String string2 = jSONObject.getString("uri");
            appStorePackageName = jSONObject.getString("appStoreId");
            return Intent.launchView(string2);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return false;
        }
    }

    @l
    public static boolean launchSchemes(JSONArray jSONArray) {
        try {
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                String string2 = (String)jSONArray.opt(i2);
                if (!Intent.tryOpenScheme(string2)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    private static boolean tryOpenScheme(String string2) {
        try {
            Uri uri = Uri.parse((String)string2);
            android.content.Intent intent = new android.content.Intent("android.intent.action.VIEW", uri);
            Activity activity = Intent.getStartingActivity();
            if (activity == null) {
                return false;
            }
            activity.startActivity(intent);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @l
    public static void launchAppByData(JSONObject jSONObject) {
    }

    @l
    public static boolean launchApp(String string2, String string3, String string4) {
        String string5 = string2;
        if (string5 == null || string5.length() < 1) {
            return false;
        }
        PackageManager packageManager = a.b().getPackageManager();
        try {
            Activity activity;
            android.content.Intent intent = packageManager.getLaunchIntentForPackage(appStorePackageName);
            PackageInfo packageInfo = packageManager.getPackageInfo(appStorePackageName, 0);
            android.content.Intent intent2 = new android.content.Intent("android.intent.action.MAIN", null);
            intent2.setPackage(packageInfo.packageName);
            List list = packageManager.queryIntentActivities(intent2, 0);
            ResolveInfo resolveInfo = (ResolveInfo)list.iterator().next();
            if (resolveInfo == null) {
                return false;
            }
            string5 = resolveInfo.activityInfo.packageName;
            String string6 = resolveInfo.activityInfo.name;
            android.content.Intent intent3 = new android.content.Intent("android.intent.action.MAIN");
            ComponentName componentName = new ComponentName(string5, string6);
            intent3.setComponent(componentName);
            if (string3 != null && string3.length() > 1) {
                intent3.setAction(string3);
            }
            if (string4 != null && string4.length() > 1) {
                intent3.addCategory(string4);
            }
            if ((activity = Intent.getStartingActivity()) == null) {
                return false;
            }
            activity.startActivity(intent3);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    @l
    public static boolean launchView(String string2) {
        android.content.Intent intent = new android.content.Intent();
        try {
            isShowGooglePlayButton = true;
            Intent.showPopupWebview(string2, intent);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @l
    public static boolean launchWebView(String string2) {
        android.content.Intent intent = new android.content.Intent();
        try {
            isShowGooglePlayButton = false;
            Intent.showPopupWebview(string2, intent);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean setExtras(android.content.Intent intent, JSONArray jSONArray) {
        if (jSONArray == null) {
            return true;
        }
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            try {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                String string2 = jSONObject.getString("key");
                Object object = jSONObject.get("value");
                if (Intent.setExtra(intent, string2, object)) continue;
                return false;
            }
            catch (Exception exception) {
                n.a("Couldn't parse extras", exception);
                return false;
            }
        }
        return true;
    }

    private static void showPopupWebview(final String string2, final android.content.Intent intent) {
        n.b(new Object[]{"showPopupWebView: " + string2});
        y.a(new Runnable(){

            @Override
            public void run() {
                c c2 = new c((Context)Intent.getStartingActivity(), string2, isShowGooglePlayButton, appStorePackageName, intent);
                c2.show();
            }
        });
    }

    @l
    public static boolean launchDownloader(JSONObject jSONObject) {
        final String string2 = jSONObject.optString("sessionId", "");
        final String string3 = jSONObject.optString("campaignId", "");
        String string4 = jSONObject.optString("caseName", "\u6b64\u5e94\u7528");
        final String string5 = jSONObject.optString("apkUrl", "");
        final String string6 = jSONObject.optString("downloadTitle", "Game_" + System.currentTimeMillis());
        final String string7 = jSONObject.optString("downloadDesc", "");
        final String string8 = jSONObject.optString("apkFileName", "Game_" + System.currentTimeMillis() + ".apk");
        boolean bl = jSONObject.optBoolean("isNeedConfirm", true);
        Activity activity = Intent.getStartingActivity();
        if (!bl || activity == null) {
            return Intent.startDownload(string5, string6, string7, string8, string2, string3);
        }
        try {
            new AlertDialog.Builder((Context)activity).setTitle((CharSequence)"\u786e\u8ba4").setMessage((CharSequence)("\u786e\u5b9a\u4e0b\u8f7d " + string4 + "?")).setPositiveButton((CharSequence)"\u662f", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int n2) {
                    Intent.startDownload(string5, string6, string7, string8, string2, string3);
                }
            }).setNegativeButton((CharSequence)"\u5426", null).show();
            return true;
        }
        catch (Throwable throwable) {
            n.a("error on launchDownloader", new Exception(throwable));
            return false;
        }
    }

    public static boolean startDownload(String string2, String string3, String string4, String string5, String string6, String string7) {
        n.b(new Object[]{"startDownload: url=" + string2});
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        try {
            if (Intent.isDownloading(string2)) {
                Toast.makeText((Context)a.b(), (CharSequence)e.a().c, (int)0).show();
                return true;
            }
            DownloadManager.Request request = mobi.oneway.sdk.d.i.a(string2, string3, string4, string5);
            return Intent.downloadWithDM(request, string2, string6, string7) || Intent.downloadWithBrowser(string2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    private static boolean isDownloading(String string2) {
        for (Map.Entry<Long, HashMap<String, String>> entry : downloadInfoMap.entrySet()) {
            HashMap<String, String> hashMap = entry.getValue();
            if (!string2.equals(hashMap.get("url"))) continue;
            return true;
        }
        return false;
    }

    private static boolean downloadWithDM(DownloadManager.Request request, String string2, String string3, String string4) {
        boolean bl = false;
        try {
            Activity activity;
            DownloadManager downloadManager = (DownloadManager)mobi.oneway.sdk.d.c.a("download");
            Long l2 = downloadManager.enqueue(request);
            bl = true;
            Toast.makeText((Context)a.b(), (CharSequence)e.a().b, (int)0).show();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("sessionId", string3);
            hashMap.put("campaignId", string4);
            hashMap.put("url", string2);
            downloadInfoMap.put(l2, hashMap);
            i.d().a(t.e, g.g, string3, string4);
            if (!isReceiverRegistered) {
                a.b().registerReceiver(receiver, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
                isReceiverRegistered = true;
            }
            if ((activity = Intent.getStartingActivity()) == null) {
                n.b("downloadWithDownloadManager: activity is null.");
                return true;
            }
            activity.startActivity(new android.content.Intent("android.intent.action.VIEW_DOWNLOADS"));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return bl;
    }

    private static boolean downloadWithBrowser(String string2) {
        n.b(new Object[]{"try download apk with browser."});
        Activity activity = Intent.getStartingActivity();
        if (activity == null) {
            n.c("error on startDownload: activity is null.");
            return false;
        }
        mobi.oneway.sdk.d.l.a((Context)activity, string2);
        return true;
    }

    private static void onDownloadComplete(Context context, android.content.Intent intent) {
        n.b(new Object[]{"on action_download_complete."});
        long l2 = intent.getLongExtra("extra_download_id", 0L);
        HashMap<String, String> hashMap = downloadInfoMap.remove(l2);
        if (hashMap == null) {
            return;
        }
        String string2 = hashMap.get("sessionId");
        String string3 = hashMap.get("campaignId");
        DownloadManager downloadManager = (DownloadManager)mobi.oneway.sdk.d.c.a("download");
        DownloadManager.Query query = new DownloadManager.Query();
        query.setFilterById(new long[]{l2});
        Cursor cursor = downloadManager.query(query);
        if (!cursor.moveToFirst()) {
            return;
        }
        int n2 = cursor.getColumnIndex("status");
        int n3 = cursor.getInt(n2);
        if (8 == n3) {
            i.d().a(t.e, g.f, string2, string3);
            n.b(new Object[]{"DOWNLOAD_APK_FINISH"});
            String string4 = cursor.getString(cursor.getColumnIndex("local_uri"));
            Intent.promptInstall(Uri.parse((String)("file://" + string4)));
        } else if (16 == n3) {
            n.c("DOWNLOAD_APK_FAIL");
            int n4 = cursor.getColumnIndex("reason");
            int n5 = cursor.getInt(n4);
            i.d().a(t.e, g.h, string2, string3, n5);
        }
    }

    private static void promptInstall(Uri uri) {
        android.content.Intent intent = new android.content.Intent("android.intent.action.VIEW").setDataAndType(uri, "application/vnd.android.package-archive");
        intent.setFlags(0x10000000);
        Activity activity = Intent.getStartingActivity();
        n.b(new Object[]{"prompt Install StartingActivity: " + activity});
        if (activity == null) {
            return;
        }
        activity.startActivity(intent);
    }

    public static void setAppStorePackageName(String string2) {
        appStorePackageName = string2;
    }

    public static String getAppStorePackageName() {
        return appStorePackageName;
    }

    public static void unregisterReceiver() {
        if (!isReceiverRegistered) {
            return;
        }
        a.b().unregisterReceiver(receiver);
    }
}

