/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.video;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.uniplay.adsdk.video.Player;
import com.uniplay.adsdk.video.VideoPlayerListener;
import java.util.List;

public class VideoProgressThread
extends Thread {
    private static final int UPDATE = 1;
    private static final int QUIT = 2;
    private List<VideoPlayerListener> callbacks;
    private Player mPlayer;
    private boolean onPlaySent;
    private Handler uiHandler;
    private Handler threadHandler;

    public VideoProgressThread(Player player, List<VideoPlayerListener> list) {
        this.mPlayer = player;
        this.callbacks = list;
        this.setName("TVASTVideoProgressThread");
        this.uiHandler = new Handler(new Handler.Callback(){

            public boolean handleMessage(Message message) {
                return VideoProgressThread.this.handleUiMessage(message);
            }
        });
    }

    public void quit() {
        if (this.threadHandler != null) {
            this.threadHandler.sendMessageAtFrontOfQueue(Message.obtain((Handler)this.threadHandler, (int)2));
        }
    }

    @Override
    public void run() {
        Looper.prepare();
        this.threadHandler = new Handler(new Handler.Callback(){

            public boolean handleMessage(Message message) {
                return VideoProgressThread.this.handleThreadMessage(message);
            }
        });
        this.threadHandler.sendEmptyMessage(1);
        Looper.loop();
    }

    protected boolean handleThreadMessage(Message message) {
        switch (message.what) {
            case 1: {
                this.update();
                this.threadHandler.sendEmptyMessageDelayed(1, 1000L);
                return true;
            }
            case 2: {
                this.threadHandler.removeCallbacksAndMessages(null);
                Looper.myLooper().quit();
                return true;
            }
        }
        return false;
    }

    private void update() {
        try {
            if (!this.mPlayer.getVideoView().isPlaying()) {
                return;
            }
            this.uiHandler.sendMessage(Message.obtain((Handler)this.uiHandler, (int)1, (int)(this.mPlayer.getVideoView().getCurrentPosition() / 1000), (int)(this.mPlayer.getVideoView().getDuration() / 1000)));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected boolean handleUiMessage(Message message) {
        switch (message.what) {
            case 1: {
                int n2 = message.arg1;
                int n3 = message.arg2;
                for (VideoPlayerListener videoPlayerListener : this.callbacks) {
                    videoPlayerListener.onVideoProgress(this.mPlayer, n2, n3);
                }
                if (!this.onPlaySent && n2 > 0) {
                    this.onPlaySent = true;
                    for (VideoPlayerListener videoPlayerListener : this.callbacks) {
                        videoPlayerListener.onVideoPlay(this.mPlayer);
                    }
                }
                return true;
            }
        }
        return false;
    }
}

