/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;

public class ScreenUtil {
    private ScreenUtil() {
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    public static int getScreenWidth(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    public static int getScreenHeight(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.heightPixels;
    }

    public static int getStatusHeight(Context context) {
        int n2 = -1;
        try {
            Class<?> clazz = Class.forName("com.android.internal.R$dimen");
            Object obj = clazz.newInstance();
            int n3 = Integer.parseInt(clazz.getField("status_bar_height").get(obj).toString());
            n2 = context.getResources().getDimensionPixelSize(n3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n2;
    }

    public static Bitmap snapShotWithStatusBar(Activity activity) {
        View view = activity.getWindow().getDecorView();
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bitmap = view.getDrawingCache();
        int n2 = ScreenUtil.getScreenWidth((Context)activity);
        int n3 = ScreenUtil.getScreenHeight((Context)activity);
        Bitmap bitmap2 = null;
        bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n2, (int)n3);
        view.destroyDrawingCache();
        return bitmap2;
    }

    public static Bitmap snapShotWithoutStatusBar(Activity activity) {
        View view = activity.getWindow().getDecorView();
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bitmap = view.getDrawingCache();
        Rect rect = new Rect();
        activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
        int n2 = rect.top;
        int n3 = ScreenUtil.getScreenWidth((Context)activity);
        int n4 = ScreenUtil.getScreenHeight((Context)activity);
        Bitmap bitmap2 = null;
        bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)n2, (int)n3, (int)(n4 - n2));
        view.destroyDrawingCache();
        return bitmap2;
    }
}

