/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.net;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.uniplay.adsdk.net.ErrorMsg;
import com.uniplay.adsdk.net.HttpManager;
import com.uniplay.adsdk.net.TaskEntity;
import com.uniplay.adsdk.net.TextUtil;
import java.io.InputStream;
import org.apache.http.client.ClientProtocolException;

public class TaskRunnable
implements Runnable {
    private final String TAG = "Http Connect";
    private HttpManager mHttpMgr = null;
    private TaskEntity taskEntity;
    private ErrorMsg errorMsg;
    private final int RESULT = 0;
    private final int ERROR = 1;
    private Handler mHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message message) {
            int n2 = message.what;
            switch (n2) {
                case 0: {
                    if (null == ((TaskRunnable)TaskRunnable.this).taskEntity.resultCallBack) break;
                    ((TaskRunnable)TaskRunnable.this).taskEntity.resultCallBack.onResult(TaskRunnable.this.taskEntity);
                    break;
                }
                case 1: {
                    if (((TaskRunnable)TaskRunnable.this).taskEntity.resultCallBack == null) break;
                    ((TaskRunnable)TaskRunnable.this).taskEntity.resultCallBack.onError(TaskRunnable.this.taskEntity);
                    break;
                }
            }
        }
    };

    public TaskRunnable(TaskEntity taskEntity) {
        this.taskEntity = taskEntity;
        this.mHttpMgr = HttpManager.getHttpClient();
    }

    @Override
    public void run() {
        if (this.taskEntity == null) {
            this.errorMsg = new ErrorMsg();
            this.errorMsg.errorMessage = "Connect error, taskEntity is null";
            this.taskEntity.errorMsg = this.errorMsg;
            this.mHandler.sendEmptyMessage(1);
            return;
        }
        if (this.taskEntity.baseUrl == null || this.taskEntity.baseUrl.equals("")) {
            this.errorMsg = new ErrorMsg();
            this.errorMsg.errorMessage = "Connect error, URL is null";
            this.taskEntity.errorMsg = this.errorMsg;
            this.mHandler.sendEmptyMessage(1);
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = this.taskEntity.requestType == 2 ? this.mHttpMgr.doGet(this.taskEntity.baseUrl) : this.mHttpMgr.doPost(this.taskEntity.baseUrl, this.taskEntity.params);
            this.dealResult(inputStream);
        }
        catch (ClientProtocolException clientProtocolException) {
            this.errorMsg = new ErrorMsg();
            this.errorMsg.errorMessage = clientProtocolException.getMessage();
            this.taskEntity.errorMsg = this.errorMsg;
            this.mHandler.sendEmptyMessage(1);
        }
        catch (Throwable throwable) {
            this.errorMsg = new ErrorMsg();
            this.errorMsg.errorMessage = throwable.getMessage();
            this.taskEntity.errorMsg = this.errorMsg;
            this.mHandler.sendEmptyMessage(1);
        }
    }

    private void dealResult(InputStream inputStream) {
        if (null == inputStream) {
            this.errorMsg = new ErrorMsg();
            this.errorMsg.errorMessage = "no data";
            this.taskEntity.errorMsg = this.errorMsg;
            this.mHandler.sendEmptyMessage(1);
            return;
        }
        String string2 = TextUtil.inputStream2String(inputStream, "utf-8");
        string2 = TextUtil.replaceSpecialChar(string2);
        this.taskEntity.outObject = null != this.taskEntity.parseInfo ? this.taskEntity.parseInfo.parseInBackgroud(string2) : string2;
        this.mHandler.sendEmptyMessage(0);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof TaskRunnable)) {
            return false;
        }
        TaskRunnable taskRunnable = (TaskRunnable)object;
        return this.hashCode() == taskRunnable.hashCode();
    }
}

