/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.download;

import android.os.Process;
import com.uniplay.adsdk.download.DownloadDelivery;
import com.uniplay.adsdk.download.DownloadException;
import com.uniplay.adsdk.download.DownloadRequest;
import com.uniplay.adsdk.download.DownloadState;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.BlockingQueue;

final class DownloadDispatcher
extends Thread {
    private static final int SLEEP_BEFORE_DOWNLOAD = 500;
    private static final int BUFFER_SIZE = 4096;
    private static final String END_OF_STREAM = "unexpected end of stream";
    private static final String DEFAULT_THREAD_NAME = "DownloadDispatcher";
    private static final String IDLE_THREAD_NAME = "DownloadDispatcher-Idle";
    private final BlockingQueue<DownloadRequest> queue;
    private final DownloadDelivery delivery;
    private long lastProgressTimestamp;
    private volatile boolean quit = false;

    public DownloadDispatcher(BlockingQueue<DownloadRequest> blockingQueue, DownloadDelivery downloadDelivery) {
        this.queue = blockingQueue;
        this.delivery = downloadDelivery;
        this.setName(IDLE_THREAD_NAME);
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        DownloadRequest downloadRequest = null;
        while (true) {
            try {
                while (true) {
                    this.setName(IDLE_THREAD_NAME);
                    downloadRequest = this.queue.take();
                    DownloadDispatcher.sleep(500L);
                    this.setName(DEFAULT_THREAD_NAME);
                    this.executeDownload(downloadRequest);
                }
            }
            catch (InterruptedException interruptedException) {
                if (!this.quit) continue;
                if (downloadRequest != null) {
                    downloadRequest.finish();
                }
                return;
            }
            break;
        }
    }

    private void updateState(DownloadRequest downloadRequest, DownloadState downloadState) {
        downloadRequest.updateDownloadState(downloadState);
    }

    private void updateStart(DownloadRequest downloadRequest, long l2) {
        if (downloadRequest.downloadState() == DownloadState.FAILURE) {
            this.updateState(downloadRequest, DownloadState.RUNNING);
            return;
        }
        this.updateState(downloadRequest, DownloadState.RUNNING);
        this.delivery.postStart(downloadRequest, l2);
    }

    private void updateRetry(DownloadRequest downloadRequest) {
        this.delivery.postRetry(downloadRequest);
    }

    private void updateProgress(DownloadRequest downloadRequest, long l2, long l3) {
        long l4 = System.currentTimeMillis();
        if (l2 != l3 && l4 - this.lastProgressTimestamp < downloadRequest.progressInterval()) {
            return;
        }
        this.lastProgressTimestamp = l4;
        if (!downloadRequest.isCanceled()) {
            this.delivery.postProgress(downloadRequest, l2, l3);
        }
    }

    private void updateSuccess(DownloadRequest downloadRequest) {
        this.updateState(downloadRequest, DownloadState.SUCCESSFUL);
        downloadRequest.finish();
        File file = new File(downloadRequest.tempFilePath());
        if (file.exists()) {
            file.renameTo(new File(downloadRequest.destinationFilePath()));
        }
        this.delivery.postSuccess(downloadRequest);
    }

    private void updateFailure(DownloadRequest downloadRequest, int n2, String string2) {
        this.updateState(downloadRequest, DownloadState.FAILURE);
        if (downloadRequest.retryTime() >= 0) {
            block4: {
                try {
                    DownloadDispatcher.sleep(downloadRequest.retryInterval());
                }
                catch (InterruptedException interruptedException) {
                    if (!this.quit) break block4;
                    downloadRequest.finish();
                    return;
                }
            }
            if (!downloadRequest.isCanceled()) {
                this.updateRetry(downloadRequest);
                this.executeDownload(downloadRequest);
            }
            return;
        }
        downloadRequest.finish();
        this.delivery.postFailure(downloadRequest, n2, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeDownload(DownloadRequest var1_1) {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        var2_2 = var1_1.downloader();
        var3_3 = null;
        var4_4 = null;
        try {
            if (var1_1.destinationFilePath() == null) {
                var1_1.updateDestinationFilePath(var2_2.detectFilename(var1_1.uri()));
            }
            var5_5 = new File(var1_1.tempFilePath());
            var3_3 = new RandomAccessFile(var5_5, "rw");
            var6_7 = var5_5.length();
            var8_9 = 0L;
            if (var5_5.exists()) {
                var3_3.seek(var6_7);
                var8_9 = var6_7;
            }
            if ((var10_10 = var2_2.start(var1_1.uri(), var6_7)) != 200 && var10_10 != 206) {
                throw new DownloadException(var10_10, "download fail");
            }
            var4_4 = var2_2.byteStream();
            var11_11 = var2_2.contentLength();
            if (var11_11 <= 0L && var4_4 == null) {
                throw new DownloadException(var10_10, "content length error");
            }
            var13_12 = var11_11 <= 0L;
            this.updateStart(var1_1, var11_11 += var8_9);
            if (var4_4 == null) throw new DownloadException(var10_10, "input stream error");
            var14_13 = new byte[4096];
lbl26:
            // 2 sources

            while (true) {
                if (Thread.currentThread().isInterrupted() || var1_1.isCanceled()) {
                    var1_1.finish();
                    var2_2.close();
                }
                ** GOTO lbl-1000
                break;
            }
        }
        catch (IOException var5_6) {
            if (var5_6 instanceof DownloadException) {
                var6_8 = (DownloadException)var5_6;
                this.updateFailure(var1_1, var6_8.getCode(), var6_8.getMessage());
            } else {
                this.updateFailure(var1_1, 0, var5_6.getMessage());
            }
            var2_2.close();
            DownloadDispatcher.silentCloseFile(var3_3);
            DownloadDispatcher.silentCloseInputStream(var4_4);
            return;
        }
        catch (Throwable var20_17) {
            var2_2.close();
            DownloadDispatcher.silentCloseFile(var3_3);
            DownloadDispatcher.silentCloseInputStream(var4_4);
            throw var20_17;
        }
        DownloadDispatcher.silentCloseFile(var3_3);
        DownloadDispatcher.silentCloseInputStream(var4_4);
        return;
lbl-1000:
        // 1 sources

        {
            var15_14 = this.readFromInputStream(var14_13, var4_4);
            var16_15 = var3_3.length();
            v0 = var18_16 = var13_12 != false ? var16_15 : var11_11;
            if (var15_14 != -1) ** GOTO lbl-1000
            this.updateSuccess(var1_1);
            var2_2.close();
        }
        DownloadDispatcher.silentCloseFile(var3_3);
        DownloadDispatcher.silentCloseInputStream(var4_4);
        return;
lbl-1000:
        // 1 sources

        {
            if (var15_14 == -2147483648) {
                throw new DownloadException(var10_10, "transfer data error");
            }
            var3_3.write(var14_13, 0, var15_14);
            this.updateProgress(var1_1, var8_9 += (long)var15_14, var18_16);
            ** continue;
        }
    }

    int readFromInputStream(byte[] byArray, InputStream inputStream) {
        try {
            return inputStream.read(byArray);
        }
        catch (IOException iOException) {
            if (END_OF_STREAM.equals(iOException.getMessage())) {
                return -1;
            }
            return Integer.MIN_VALUE;
        }
    }

    static void silentCloseFile(RandomAccessFile randomAccessFile) {
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void silentCloseInputStream(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void quit() {
        this.quit = true;
        this.interrupt();
    }
}

