/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.ad.sdk.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.res.AssetManager;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class KsyunFileUtils {
    private static final String TAG = "KsyunFileUtils";
    private static final String FOLDER = "kscplugin";
    private static final String SUFFIX = ".apk";
    private static final String PREFIX = "ksc_plugin";
    private static final int BUF_SIZE = 8192;
    private static final String STATIS_FOLDER = "statis_folder";
    private static final String DEVICE_INFO = "device_info.txt";
    private static final String STATIS_INFO = "statis_info.txt";
    private static final String AUTO_CACHE_INFO = "auto_cache_info.txt";

    private static String getBaseCacheDir(Context context, String string2) {
        String string3;
        block6: {
            if (null == context) {
                Log.e((String)TAG, (String)"getBaseCacheDir: context is null");
                return "";
            }
            if ("mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable()) {
                try {
                    if (null == context.getExternalFilesDir(string2)) {
                        string3 = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + string2;
                        break block6;
                    }
                    string3 = context.getExternalFilesDir(string2).getPath();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    string3 = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + string2;
                }
            } else {
                string3 = context.getFilesDir().getPath() + File.separator + string2;
            }
        }
        Log.d((String)TAG, (String)("getBaseCacheDir: " + string3));
        return string3;
    }

    private static String getPluginCacheDir(Context context) {
        return KsyunFileUtils.getBaseCacheDir(context, FOLDER);
    }

    private static String getPluginCachePath(Context context, String string2) {
        File file = new File(KsyunFileUtils.getPluginCacheDir(context));
        if (!file.exists()) {
            file.mkdir();
        }
        return file.getAbsolutePath() + File.separator + string2;
    }

    public static void fetchPlugin(Context context, FileOperationListener fileOperationListener) {
        if ("release".equals("debug")) {
            KsyunFileUtils.copyAssetsFileToDest(context, fileOperationListener);
        } else {
            File[] fileArray;
            File file = new File(KsyunFileUtils.getPluginCacheDir(context));
            if (!file.exists()) {
                Log.d((String)TAG, (String)("fetchPlugin: \u521b\u5efa\u63d2\u4ef6\u6587\u4ef6\u5939" + file.mkdir()));
            }
            if (null != (fileArray = file.listFiles()) && fileArray.length > 0) {
                File file2 = null;
                for (int i2 = fileArray.length - 1; i2 >= 0; --i2) {
                    Log.d((String)TAG, (String)("fetchPlugin: " + fileArray[i2].getName()));
                    if (!fileArray[i2].getName().contains(PREFIX) || !fileArray[i2].getName().contains(SUFFIX)) continue;
                    file2 = fileArray[i2];
                    break;
                }
                if (null != file2) {
                    String string2 = KsyunFileUtils.getAssetPluginName(context);
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        int n2 = KsyunFileUtils.getPluginVersion(string2);
                        int n3 = KsyunFileUtils.getPluginVersion(file2.getName());
                        Log.d((String)TAG, (String)("assets plugin version=" + n2));
                        Log.d((String)TAG, (String)("plugin version=" + n3));
                        if (n2 > n3) {
                            Log.d((String)TAG, (String)"\u4f7f\u7528assets\u4e2d\u7684\u63d2\u4ef6");
                            KsyunFileUtils.copyAssetsFileToDest(context, fileOperationListener);
                        } else {
                            Log.d((String)TAG, (String)"\u4f7f\u7528\u79c1\u6709\u76ee\u5f55\u4e2d\u7684\u63d2\u4ef6");
                            fileOperationListener.onFileOperateSuccess(file2.getAbsolutePath());
                        }
                    } else {
                        Log.e((String)TAG, (String)"can not find plugin from assets");
                        fileOperationListener.onFileOperateFailure(1003, "can not find plugin from assets");
                    }
                } else {
                    Log.e((String)TAG, (String)"can not find plugin from private folder");
                    fileOperationListener.onFileOperateFailure(1005, "can not find plugin from private folder");
                }
            } else {
                KsyunFileUtils.copyAssetsFileToDest(context, fileOperationListener);
            }
        }
    }

    private static int getPluginVersion(String string2) {
        int n2 = 0;
        try {
            int n3 = string2.lastIndexOf("_v") + 2;
            n2 = Integer.valueOf(string2.substring(n3, n3 + 3));
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return n2;
    }

    private static PackageInfo getPluginPackageInfo(Context context, String string2) {
        return context.getPackageManager().getPackageArchiveInfo(Uri.parse((String)string2).toString(), 5);
    }

    private static String getAssetPluginName(Context context) {
        String string2 = "";
        try {
            String[] stringArray;
            AssetManager assetManager = context.getAssets();
            for (String string3 : stringArray = assetManager.list(FOLDER)) {
                Log.d((String)TAG, (String)("getAssetPluginName: " + string3));
                if (!string3.contains(PREFIX) || !string3.contains(SUFFIX)) continue;
                string2 = string3;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
        return string2;
    }

    private static void copyAssetsFileToDest(Context context, FileOperationListener fileOperationListener) {
        OutputStream outputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            Log.d((String)TAG, (String)"copy assets \u4e2d\u7684\u63d2\u4ef6\u5230\u6307\u5b9a\u76ee\u5f55");
            String string2 = KsyunFileUtils.getAssetPluginName(context);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                Log.e((String)TAG, (String)"can not find plugin from assets");
                fileOperationListener.onFileOperateFailure(1003, "can not find plugin from assets");
                return;
            }
            String string3 = KsyunFileUtils.getPluginCachePath(context, string2);
            Log.d((String)TAG, (String)("destPath: " + string3));
            String string4 = FOLDER + File.separator + string2;
            Log.d((String)TAG, (String)("copyAssetsFileToDest: " + string4));
            bufferedInputStream = new BufferedInputStream(context.getAssets().open(string4));
            outputStream = new BufferedOutputStream(new FileOutputStream(string3));
            byte[] byArray = new byte[8192];
            int n2 = 0;
            while ((n2 = bufferedInputStream.read(byArray, 0, 8192)) > 0) {
                outputStream.write(byArray, 0, n2);
            }
            outputStream.close();
            bufferedInputStream.close();
            fileOperationListener.onFileOperateSuccess(string3);
        }
        catch (IOException iOException) {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException2) {
                    Log.e((String)TAG, (String)"error in close stream", (Throwable)iOException2);
                    iOException2.printStackTrace();
                }
            }
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException3) {
                    Log.e((String)TAG, (String)"error in close stream", (Throwable)iOException3);
                    iOException3.printStackTrace();
                }
            }
            fileOperationListener.onFileOperateFailure(1004, "sdk file io exception");
            iOException.printStackTrace();
        }
    }

    public static List<String> getDeviceInfoData(Context context) {
        String string2 = KsyunFileUtils.getBaseCacheDir(context, STATIS_FOLDER) + File.separator + DEVICE_INFO;
        return KsyunFileUtils.readDataFromFile(string2);
    }

    public static List<String> getStatisInfoData(Context context) {
        String string2 = KsyunFileUtils.getBaseCacheDir(context, STATIS_FOLDER) + File.separator + STATIS_INFO;
        return KsyunFileUtils.readDataFromFile(string2);
    }

    public static List<String> getAutoCacheInfo(Context context) {
        String string2 = KsyunFileUtils.getBaseCacheDir(context, AUTO_CACHE_INFO) + File.separator + AUTO_CACHE_INFO;
        return KsyunFileUtils.readDataFromFile(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readDataFromFile(String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string2));
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                arrayList.add(string3);
            }
            bufferedReader.close();
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return arrayList;
    }

    public static interface FileOperationListener {
        public void onFileOperateSuccess(String var1);

        public void onFileOperateFailure(int var1, String var2);
    }
}

