/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.net.Uri;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import android.widget.Toast;
import com.uniplay.adsdk.AppInfo;
import com.uniplay.adsdk.DownloadService;
import com.uniplay.adsdk.utils.Base64;
import com.uniplay.adsdk.utils.PreferencesHelper;
import com.uniplay.adsdk.utils.Record;
import com.uniplay.adsdk.utils.SDKLog;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.crypto.Cipher;
import org.json.JSONException;
import org.json.JSONObject;

public class Utils {
    private static ThreadPoolExecutor mThreadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(2);
    private static final String KEY_ALGORITHM = "RSA";
    private static final int MAX_ENCRYPT_BLOCK = 240;

    public static boolean isDeepLink(String string2) {
        return !Utils.isHttpUrl(string2);
    }

    public static boolean isHttpUrl(String string2) {
        if (string2 == null) {
            return false;
        }
        return string2.startsWith("http:") || string2.startsWith("https:");
    }

    public static boolean deviceCanHandleIntent(Context context, Intent intent) {
        try {
            PackageManager packageManager = context.getPackageManager();
            List list = packageManager.queryIntentActivities(intent, 0);
            return !list.isEmpty();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static ArrayList<String> string2List(String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "@@");
            SDKLog.e("info", "\u4e0b\u8f7d\u4e0a\u62a5:" + stringTokenizer.toString());
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static String list2String(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (String string2 : list) {
                stringBuffer.append(string2).append("@@");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static void showToast(Context context, String string2) {
        Toast.makeText((Context)context, (CharSequence)string2, (int)0).show();
    }

    public static byte[] getImage(String string2) {
        try {
            URL uRL = new URL(string2);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setReadTimeout(6000);
            InputStream inputStream = null;
            if (httpURLConnection.getResponseCode() == 200) {
                inputStream = httpURLConnection.getInputStream();
                byte[] byArray = Utils.readStream(inputStream);
                inputStream.close();
                return byArray;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static byte[] readStream(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n2 = -1;
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        byteArrayOutputStream.close();
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private static String encryptByPublic(byte[] byArray, String string2) {
        byte[] byArray2 = Base64.decode(string2);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray2);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, publicKey);
        int n2 = byArray.length;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 - n3 > 0) {
            if (n2 - n3 > 240) {
                stringBuffer.append("str" + n4).append("=" + URLEncoder.encode(Base64.encode(cipher.doFinal(byArray, n3, 240))));
            } else {
                stringBuffer.append("str" + n4).append("=" + URLEncoder.encode(Base64.encode(cipher.doFinal(byArray, n3, n2 - n3))));
            }
            stringBuffer.append("&");
            n3 = ++n4 * 240;
        }
        stringBuffer.append("num=" + n4);
        stringBuffer.append("&");
        stringBuffer.append("encode=1");
        return stringBuffer.toString();
    }

    public static boolean apkExists(String string2) {
        File file = new File(string2);
        SDKLog.e("info", "exists:" + file.exists() + "");
        if (!file.exists()) {
            return false;
        }
        return string2.contains(".apk") || string2.contains(".ap") || !string2.contains(".tmp");
    }

    public static void DeleteDownLoadContentFileByTimeInterval(Context context) {
        try {
            long l2 = PreferencesHelper.getInstance(context).getDelDirTime();
            if (l2 == 0L) {
                PreferencesHelper.getInstance(context).saveDelDirTime();
            }
            long l3 = PreferencesHelper.getInstance(context).getDelDirTime();
            long l4 = System.currentTimeMillis();
            SDKLog.e("info", "s-->" + (l4 - l3) + "   t-->" + 86400000);
            long l5 = (l4 - l3) / 86400000L;
            SDKLog.e("info", "s--->" + l5);
            if (l5 >= 1L) {
                File file = new File(DownloadService.DL_PATH);
                Utils.deleteDirWihtFile(file, false);
                PreferencesHelper.getInstance(context).saveDelDirTime();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void deleteDirWihtFile(File file, boolean bl) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            return;
        }
        SDKLog.e("info:", "deleteDirWihtFile--->");
        for (File file2 : file.listFiles()) {
            if (file2.isFile()) {
                file2.delete();
                continue;
            }
            if (!file2.isDirectory()) continue;
            Utils.deleteDirWihtFile(file2, false);
        }
        if (bl) {
            file.delete();
        }
    }

    public static String getUrlFromDepLink(String string2) {
        Uri uri = Uri.parse((String)string2);
        Set set = Uri.parse((String)string2).getQueryParameterNames();
        for (String string3 : set) {
            if (!string3.equals("params")) continue;
            List list = uri.getQueryParameters("params");
            SDKLog.e("info", list.toString());
            for (String string4 : list) {
                if (!string4.contains("url")) continue;
                JSONObject jSONObject = null;
                try {
                    jSONObject = new JSONObject(string4);
                    string2 = jSONObject.getString("url");
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        }
        SDKLog.e("info", "getUrlFromDepLink:" + string2);
        return string2;
    }

    public static ArrayList<String> replaceClickId(ArrayList<String> arrayList, String string2) {
        if (arrayList != null && !TextUtils.isEmpty((CharSequence)string2)) {
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                String string3 = arrayList.get(i2);
                String string4 = string3.replaceAll("__CLICK_ID__", string2);
                arrayList.set(i2, string4);
            }
            SDKLog.e("info", "replaceClickId-\u4e0a\u62a5\u4e8b\u4ef6\u66ff\u6362 ----:" + arrayList.toString());
        }
        return arrayList;
    }

    public static Bitmap rotateBitmap(Bitmap bitmap, float f2) {
        if (bitmap == null) {
            return null;
        }
        int n2 = bitmap.getWidth();
        int n3 = bitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.setRotate(f2);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n2, (int)n3, (Matrix)matrix, (boolean)false);
        if (bitmap2.equals(bitmap)) {
            return bitmap2;
        }
        bitmap.recycle();
        return bitmap2;
    }

    public static String saveBitmap(String string2, Bitmap bitmap) {
        if (!new File(DownloadService.DL_PATH).exists()) {
            new File(DownloadService.DL_PATH).mkdirs();
        }
        File file = new File(DownloadService.DL_PATH + string2 + ".png");
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            System.out.println("\u5728\u4fdd\u5b58\u56fe\u7247\u65f6\u51fa\u9519\uff1a" + iOException.toString());
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        try {
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream);
        }
        catch (Exception exception) {
            return "create_bitmap_error";
        }
        try {
            fileOutputStream.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return file.getAbsolutePath();
    }

    public static ArrayList<String> mergeList(ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        ArrayList<String> arrayList3 = new ArrayList<String>();
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        if (arrayList2 != null) {
            arrayList3.addAll(arrayList2);
        }
        return new ArrayList<String>(new HashSet(arrayList3));
    }

    public static ArrayList<String> filterClickData(ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        ArrayList<Object> arrayList3 = new ArrayList<String>();
        if (arrayList2 != null && !arrayList2.isEmpty()) {
            arrayList3 = arrayList2;
        }
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        for (int i2 = 0; i2 < arrayList3.size(); ++i2) {
            if (!arrayList2.toString().contains((CharSequence)arrayList3.get(i2))) continue;
            arrayList3.remove(i2);
        }
        return new ArrayList<Object>(new HashSet<Object>(arrayList3));
    }

    public static ArrayList<String> filterImpData(ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        ArrayList<String> arrayList3 = new ArrayList<String>();
        if (arrayList2 != null && !arrayList2.isEmpty()) {
            arrayList3 = arrayList2;
        }
        if (arrayList != null) {
            arrayList3.addAll(arrayList);
        }
        ArrayList<String> arrayList4 = new ArrayList<String>(new HashSet(arrayList3));
        for (int i2 = 0; i2 < arrayList4.size(); ++i2) {
            if (!arrayList2.toString().contains(arrayList4.get(i2))) continue;
            arrayList4.remove(i2);
            --i2;
        }
        return arrayList4;
    }

    public static String changeFilePath(String string2) {
        int n2;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        if (string2.contains(".apk") && (n2 = string2.indexOf(".apk")) > 0) {
            string2 = string2.substring(0, n2 + 3);
        }
        SDKLog.e("info", "apkfile_path-changeFilePath:" + string2);
        return string2;
    }

    public static Intent getIntent(Context context, String string2, Intent intent) {
        String string3 = string2.toString();
        if (context.getApplicationInfo().targetSdkVersion >= 24) {
            int n2;
            if (!TextUtils.isEmpty((CharSequence)string3) && (n2 = string3.toString().indexOf(".apk")) > 0) {
                string3 = string3.substring(0, n2 + 4);
            }
            SDKLog.e("info", "apkfile_path-getIntent:" + string3);
            try {
                Uri uri = FileProvider.getUriForFile((Context)context, (String)(AppInfo.packageName + ".uniplay.fileprovider"), (File)new File(string3));
                intent.addFlags(0x10000000);
                intent.addFlags(1);
                intent.setDataAndType(uri, "application/vnd.android.package-archive");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                intent.addFlags(0x10000000);
                intent.setDataAndType(Uri.parse((String)("file://" + string2.toString())), "application/vnd.android.package-archive");
            }
        } else {
            intent.addFlags(0x10000000);
            intent.setDataAndType(Uri.parse((String)("file://" + string2.toString())), "application/vnd.android.package-archive");
        }
        return intent;
    }

    public static int getBtnsz(int n2, int n3, float f2) {
        if (n3 > 25 && n3 <= 36) {
            n2 = (int)((float)n3 * f2);
        }
        return n2;
    }

    public static String isValidApk(String string2, Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageArchiveInfo(string2, 0);
            if (packageInfo != null) {
                return packageInfo.packageName;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    public static boolean isDownloaded(String string2, Record record) {
        SDKLog.e("info", "isDownloaded-filepath:" + record.getFilePath());
        if (TextUtils.isEmpty((CharSequence)record.getFilePath())) {
            return false;
        }
        SDKLog.e("info", "isDownloaded-filepath:" + record.getFilePath());
        if (!Utils.apkExists(record.getFilePath())) {
            return false;
        }
        SDKLog.e("info", "isDownloaded-filepath:" + !Utils.apkExists(record.getFilePath()));
        return true;
    }

    public static void silentInstall(Context context, String string2, File file) {
        try {
            Intent intent = new Intent();
            intent.setClassName("com.ktouch.tycushotapps", "com.yingyonghui.market.service.SilentInstallService");
            if (string2 != null) {
                intent.putExtra("installing_apk_title", string2);
            }
            intent.putExtra("com.yingyonghui.market", "com.ktouch.tycushotapps");
            intent.putExtra("installing_apk_path", file.getAbsolutePath());
            context.startService(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isTYSilentInstallServiceExists(Context context) {
        boolean bl = true;
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = context.getPackageManager().getApplicationInfo("cn.ktouch.silentinstall", 4);
        }
        catch (Exception exception) {
            applicationInfo = null;
            return false;
        }
        bl = applicationInfo != null;
        return bl;
    }

    public static String getDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(new Date());
    }

    public static String getDate(String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        return simpleDateFormat.format(new Date());
    }

    public static boolean isAPK(String string2) {
        try {
            String string3 = Uri.parse((String)string2).getPath().toLowerCase();
            if (string3.endsWith(".apk") || string2.endsWith(".apk")) {
                return true;
            }
            if (string2.contains("&s={\"down_x\":") && string2.contains("down_y") && string2.contains("up_x") && string2.contains("up_y")) {
                String string4 = Uri.parse((String)string2).getPath().toLowerCase();
                if (string4.endsWith(".apk")) {
                    return true;
                }
                String string5 = string2.substring(0, string2.indexOf("&s={\"down_x\":"));
                SDKLog.e("info", string5);
                if (string5.endsWith(".apk")) {
                    return true;
                }
                String string6 = Uri.parse((String)string5).getPath().toLowerCase();
                if (string6.endsWith(".apk")) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean isOneHours(String string2, String string3, int n2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-M-d HH:mm:ss");
        SDKLog.e("info", "\u683c\u5f0f\u5316\u6210\u5c0f\u65f6-o_date:" + string2);
        SDKLog.e("info", "\u683c\u5f0f\u5316\u6210\u5c0f\u65f6-now_date:" + string3);
        Date date = simpleDateFormat.parse(string2);
        Date date2 = simpleDateFormat.parse(string3);
        long l2 = date2.getTime() - date.getTime();
        double d2 = (double)l2 * 1.0 / 3600000.0;
        SDKLog.e("info", "\u683c\u5f0f\u5316\u6210\u5c0f\u65f6:" + d2);
        return d2 <= (double)n2;
    }
}

