/*
 * Decompiled with CFR 0.152.
 */
package mobi.oneway.sdk.http;

import android.content.Context;
import android.text.TextUtils;
import android.webkit.URLUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import mobi.oneway.sdk.b.e;
import mobi.oneway.sdk.d.j;
import mobi.oneway.sdk.d.k;
import mobi.oneway.sdk.d.n;
import mobi.oneway.sdk.d.w;
import mobi.oneway.sdk.e.i;
import mobi.oneway.sdk.http.HttpConfig;
import mobi.oneway.sdk.http.HttpInterceptor;
import mobi.oneway.sdk.http.a;
import mobi.oneway.sdk.http.b;
import mobi.oneway.sdk.http.c;
import mobi.oneway.sdk.http.f;
import org.json.JSONObject;

public class WebRequest {
    public static final String METHOD_POST = "POST";
    public static final String METHOD_HEAD = "HEAD";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String LOG_TAG = "OnewaySdk-Http";
    private static final int defTimeout = 10000;
    private static String defUserAgent;
    private static final List<WebRequest> runningRequests;
    private String url;
    private String method;
    private String body;
    private final Map<String, String> urlParams = new HashMap<String, String>();
    private final Map<String, String> headers = new HashMap<String, String>();
    private int connectTimeout = 10000;
    private int readTimeout = 10000;
    private String filepath;
    private boolean append = false;
    private a downloadListener;
    private boolean canceled = false;

    private static synchronized void addReq(WebRequest webRequest) {
        runningRequests.add(webRequest);
    }

    private static synchronized void removeReq(WebRequest webRequest) {
        runningRequests.remove(webRequest);
    }

    public static synchronized void stopAll() {
        for (WebRequest webRequest : runningRequests) {
            webRequest.cancel();
        }
        runningRequests.clear();
    }

    public WebRequest(String string2) {
        this.setUrl(string2);
    }

    public WebRequest setBody(String string2) {
        this.body = string2;
        return this;
    }

    public WebRequest setHeader(String string2, String string3) {
        this.headers.put(string2, string3);
        return this;
    }

    public WebRequest setHeaders(Map<String, String> map) {
        if (map != null && map.size() > 0) {
            this.headers.putAll(map);
        }
        return this;
    }

    public WebRequest toFile(String string2) {
        this.toFile(string2, false);
        return this;
    }

    public WebRequest toFile(String string2, boolean bl) {
        this.filepath = string2;
        this.append = bl;
        return this;
    }

    public WebRequest addParam(String string2, Object object) {
        this.urlParams.put(string2, String.valueOf(object));
        return this;
    }

    public WebRequest addParams(Map<String, String> map) {
        if (map != null && map.size() > 0) {
            this.urlParams.putAll(map);
        }
        return this;
    }

    public WebRequest setDownloadListener(a a2) {
        this.downloadListener = a2;
        return this;
    }

    public WebRequest setTimeout(int n2, int n3) {
        this.setConnectTimeout(n2);
        this.setReadTimeout(n3);
        return this;
    }

    public void cancel() {
        this.canceled = true;
        n.b("Cancel Request: ", this.url);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public void setUrl(String string2) {
        this.url = string2;
    }

    public WebRequest setMethod(String string2) {
        this.method = string2;
        return this;
    }

    public String getQuery() {
        try {
            return new URL(this.url).getQuery();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int n2) {
        this.connectTimeout = n2;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int n2) {
        this.readTimeout = n2;
    }

    public String getString() {
        HttpInterceptor httpInterceptor = HttpConfig.getDefaultInterceptor();
        String string2 = httpInterceptor == null ? null : httpInterceptor.execute(this);
        return string2 != null ? string2 : this.execute().b();
    }

    public JSONObject getJSON() {
        return new JSONObject(this.getString());
    }

    public WebRequest execute(final c c2) {
        WebRequest.addReq(this);
        new mobi.oneway.sdk.base.a<WebRequest, b>(){

            protected b a(WebRequest ... webRequestArray) {
                return WebRequest.this.execute();
            }

            @Override
            protected void a(b b2) {
                WebRequest.removeReq(WebRequest.this);
                if (b2.g()) {
                    c2.onError(new IllegalStateException("Request has been closed."), b2);
                    return;
                }
                c2.onSuccess(b2);
            }

            @Override
            protected void a(Throwable throwable) {
                n.a("Exception on WebRequest executing. Canceled: " + WebRequest.this.isCanceled() + ", url:" + WebRequest.this.url, throwable);
                WebRequest.removeReq(WebRequest.this);
                if (WebRequest.this.isCanceled()) {
                    return;
                }
                if (WebRequest.this.filepath != null) {
                    j.c(WebRequest.this.filepath);
                }
                c2.onError(throwable, new b(WebRequest.this).a(throwable));
            }

            @Override
            public void interrupt() {
                WebRequest.this.cancel();
                super.interrupt();
            }

            @Override
            protected /* synthetic */ Object b(Object[] objectArray) {
                return this.a((WebRequest[])objectArray);
            }
        }.a((b)new WebRequest[0]);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public b execute() {
        Object object;
        HttpURLConnection httpURLConnection = null;
        b b2 = new b(this);
        try {
            int n2;
            this.prepareParams();
            httpURLConnection = this.prepareConnection();
            this.sendBody(httpURLConnection);
            int n3 = httpURLConnection.getResponseCode();
            b2.a(n3);
            b2.a(httpURLConnection.getHeaderFields());
            int n4 = httpURLConnection.getContentLength();
            b2.a((long)n4);
            this.onProgress(n4, 0, b2);
            if (this.isDownloadToFile()) {
                b2.a(this.filepath);
                n2 = this.copyStream(httpURLConnection, new FileOutputStream(this.filepath, this.append), b2);
            } else {
                object = new ByteArrayOutputStream();
                n2 = this.copyStream(httpURLConnection, (OutputStream)object, b2);
                b2.a(((ByteArrayOutputStream)object).toByteArray());
            }
            this.onComplete(n4, n2, b2);
            this.onSuccess(b2);
            object = b2;
        }
        catch (Throwable throwable) {
            k.a(httpURLConnection);
            throw throwable;
        }
        k.a(httpURLConnection);
        return object;
    }

    private void sendBody(HttpURLConnection httpURLConnection) {
        if (!METHOD_POST.equals(this.getMethod())) {
            return;
        }
        PrintWriter printWriter = null;
        try {
            httpURLConnection.setDoOutput(true);
            printWriter = new PrintWriter(new OutputStreamWriter(httpURLConnection.getOutputStream(), "UTF-8"));
            if (!TextUtils.isEmpty((CharSequence)this.body)) {
                printWriter.write(this.body);
            } else if (!TextUtils.isEmpty((CharSequence)this.getQuery())) {
                printWriter.write(this.getQuery());
            }
            printWriter.flush();
        }
        catch (Throwable throwable) {
            k.a(new Closeable[]{printWriter});
            throw throwable;
        }
        k.a(new Closeable[]{printWriter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copyStream(HttpURLConnection httpURLConnection, OutputStream outputStream, b b2) {
        int n2;
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n3;
            int n4 = httpURLConnection.getContentLength();
            bufferedOutputStream = new BufferedOutputStream(outputStream);
            bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
            int n5 = 0;
            byte[] byArray = new byte[1024];
            while (!this.isCanceled() && (n3 = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n3);
                this.onProgress(n4, n5 += n3, b2);
            }
            bufferedOutputStream.flush();
            n2 = n5;
        }
        catch (Throwable throwable) {
            k.a(bufferedInputStream, bufferedOutputStream);
            throw throwable;
        }
        k.a(bufferedInputStream, bufferedOutputStream);
        return n2;
    }

    private boolean isDownloadToFile() {
        return this.filepath != null;
    }

    private HttpURLConnection prepareConnection() {
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(this.getUrl()).openConnection();
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setConnectTimeout(this.getConnectTimeout());
        httpURLConnection.setReadTimeout(this.getReadTimeout());
        httpURLConnection.setRequestMethod(this.getMethod());
        httpURLConnection.setRequestProperty("Accept-Encoding", "");
        if (!this.headers.isEmpty()) {
            for (String string2 : this.headers.keySet()) {
                httpURLConnection.setRequestProperty(string2, this.headers.get(string2));
            }
        }
        if (URLUtil.isHttpsUrl((String)this.url)) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
            httpsURLConnection.setHostnameVerifier(f.b());
            httpsURLConnection.setSSLSocketFactory(f.a());
        }
        return httpURLConnection;
    }

    private void prepareParams() {
        String string2;
        if (this.method == null) {
            this.method = "GET";
        }
        this.method = this.method.toUpperCase();
        if (this.getReadTimeout() <= 0) {
            throw new IllegalArgumentException("read timeout=" + this.getReadTimeout() + " is <= 0.");
        }
        if (this.connectTimeout <= 0) {
            throw new IllegalArgumentException("connect timeout=" + this.getConnectTimeout() + " is <= 0.");
        }
        if (!this.urlParams.isEmpty()) {
            this.url = this.url + (this.url.indexOf("?") > 0 ? "&" : "?");
            this.url = this.url + WebRequest.mapToQueryString(this.urlParams, true);
        }
        this.setHeader("User-Agent", (string2 = i.a) != null && string2.length() > 0 ? string2 : WebRequest.getDefUserAgent());
    }

    private static String getDefUserAgent() {
        if (defUserAgent != null) {
            return defUserAgent;
        }
        Context context = mobi.oneway.sdk.b.a.b();
        String string2 = mobi.oneway.sdk.d.c.b(context);
        if (string2 == null) {
            string2 = mobi.oneway.sdk.d.c.a(context);
        }
        if ((string2 = WebRequest.encode(string2)) == null) {
            string2 = "OnewaySdk";
        }
        defUserAgent = string2 + "/" + System.getProperty("http.agent");
        return defUserAgent;
    }

    public static String mapToQueryString(Map<String, String> map, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : map.keySet()) {
            String string3 = map.get(string2);
            if (bl) {
                string2 = WebRequest.encode(string2);
                string3 = WebRequest.encode(string3);
            }
            stringBuilder.append(string2).append('=').append(string3).append('&');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private static String encode(String string2) {
        if (string2 == null) {
            return null;
        }
        try {
            return URLEncoder.encode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return string2;
        }
    }

    private void onSuccess(b b2) {
        this.log("Request Success ===== ", this.getMethod(), " ", this.url);
        if (!this.urlParams.isEmpty()) {
            this.log("urlParams: ", this.urlParams);
        }
        if (!this.headers.isEmpty()) {
            this.log("headers: ", this.headers);
        }
        if (this.body != null) {
            this.log("body: ", this.body);
        }
        this.log("Response code = ", b2.h());
        if (this.isDownloadToFile()) {
            this.log("downloaded to file: " + this.filepath);
        } else {
            this.log("response Body: " + b2.b());
        }
    }

    private void onProgress(int n2, int n3, b b2) {
        if (this.downloadListener == null) {
            return;
        }
        this.downloadListener.a(n2, n3, b2);
    }

    private void onComplete(int n2, int n3, b b2) {
        if (this.downloadListener == null) {
            return;
        }
        this.downloadListener.b(n2, n3, b2);
    }

    private void log(Object ... objectArray) {
        if (!n.b()) {
            return;
        }
        n.a(new Object[]{LOG_TAG, w.a(" ", objectArray)});
    }

    private static void clearOldVerCache() {
        try {
            File[] fileArray;
            j.h(e.a("http_V1"));
            File file = j.a(mobi.oneway.sdk.b.a.b(), null);
            if (file == null) {
                return;
            }
            for (File file2 : fileArray = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string2) {
                    return string2 != null && (string2.startsWith("V1") || string2.startsWith("OnewaySdkCache-") || string2.startsWith("OnewaySdkStorage-"));
                }
            })) {
                if (file2 == null) continue;
                j.h(file2);
            }
        }
        catch (Throwable throwable) {
            n.b("clearOldVerCache error:" + throwable);
        }
    }

    static {
        runningRequests = new ArrayList<WebRequest>();
        WebRequest.clearOldVerCache();
    }
}

