/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.uniplay.adsdk.AdEntity;
import com.uniplay.adsdk.AdManager;
import com.uniplay.adsdk.AdParser;
import com.uniplay.adsdk.AppInfo;
import com.uniplay.adsdk.ConfigureModule;
import com.uniplay.adsdk.Constants;
import com.uniplay.adsdk.DeviceInfo;
import com.uniplay.adsdk.GeoInfo;
import com.uniplay.adsdk.InterstitialAd;
import com.uniplay.adsdk.InterstitialAdActivity;
import com.uniplay.adsdk.InterstitialAdListener;
import com.uniplay.adsdk.ParserTags;
import com.uniplay.adsdk.PicUtils;
import com.uniplay.adsdk.VideoAdListener;
import com.uniplay.adsdk.api.ErrorCode;
import com.uniplay.adsdk.api.UniplayAdAPI;
import com.uniplay.adsdk.basic.RuleManage;
import com.uniplay.adsdk.imp.OnVideoLPGListener;
import com.uniplay.adsdk.net.HttpUtil;
import com.uniplay.adsdk.net.TaskEntity;
import com.uniplay.adsdk.utils.DownLoadUtil;
import com.uniplay.adsdk.utils.MD5;
import com.uniplay.adsdk.utils.PreferencesHelper;
import com.uniplay.adsdk.utils.SDKLog;
import com.uniplay.adsdk.utils.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.http.entity.StringEntity;
import org.json.JSONObject;

public class VideoAd
implements InterstitialAdListener,
TaskEntity.OnResultListener {
    private Context context;
    private VideoAdListener videoAdListener;
    private String uniplayAppid;
    private String uniplaySlotid = "video";
    private AdEntity ad;
    protected int adViewState;
    private static volatile boolean isVideoReady = false;
    private int video_topleft_logo = 0;
    private int closeTiem = -1;
    private String adLogo;
    private OnVideoLPGListener onVideoLPGListener;
    static final int Default_State = 0;
    static final int Request_State = 1;
    private PreferencesHelper ph;
    private static volatile VideoAd instance;
    Handler mHandler = new Handler(){

        public void handleMessage(Message message) {
            super.handleMessage(message);
            switch (message.what) {
                case 261: {
                    VideoAd.this.adViewState = 0;
                    SDKLog.e(((Object)((Object)this)).getClass().getName(), "loadVideo:" + isVideoReady);
                    if (VideoAd.this.videoAdListener == null) break;
                    VideoAd.this.videoAdListener.onVideoAdReady();
                    break;
                }
                case 262: {
                    VideoAd.this.adViewState = 0;
                    if (VideoAd.this.videoAdListener == null) break;
                    VideoAd.this.videoAdListener.onVideoAdFailed("\u7f13\u5b58\u5931\u8d25");
                }
            }
        }
    };
    private ThreadPoolExecutor mThreadPool;
    private Runnable loadVideo = new Runnable(){

        @Override
        public void run() {
            try {
                isVideoReady = DownLoadUtil.downloadAd(MD5.getMD5(((VideoAd)VideoAd.this).ad.vurl), ((VideoAd)VideoAd.this).ad.vmd5, ((VideoAd)VideoAd.this).ad.vurl);
                if (isVideoReady) {
                    VideoAd.this.mHandler.sendEmptyMessage(261);
                } else {
                    VideoAd.this.mHandler.sendEmptyMessage(262);
                }
            }
            catch (Exception exception) {
                VideoAd.this.mHandler.sendEmptyMessage(262);
            }
        }
    };

    public void setTopLeftLogo(int n2) {
        this.video_topleft_logo = n2;
    }

    public void setCloseTiem(int n2) {
        this.closeTiem = n2;
    }

    public void setAdLogo(String string2) {
        this.adLogo = string2;
    }

    public VideoAdListener getVideoAdListener() {
        return this.videoAdListener;
    }

    public void setVideoAdListener(VideoAdListener videoAdListener) {
        this.videoAdListener = videoAdListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized VideoAd getInstance() {
        if (instance != null) return instance;
        Class<VideoAd> clazz = VideoAd.class;
        synchronized (VideoAd.class) {
            if (instance != null) return instance;
            instance = new VideoAd();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private VideoAd() {
    }

    public VideoAd init(Context context, String string2, VideoAdListener videoAdListener) {
        this.init(context, string2);
        this.setVideoAdListener(videoAdListener);
        return instance;
    }

    private VideoAd init(Context context, String string2) {
        this.context = context;
        this.uniplayAppid = string2.replace(" ", "").toLowerCase();
        Utils.DeleteDownLoadContentFileByTimeInterval(this.context);
        AdManager.getInstance().initAdManager(this.context, string2);
        UniplayAdAPI.getInstance().signIn(this.context, string2, this.uniplaySlotid);
        if (this.mThreadPool == null) {
            this.mThreadPool = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
        }
        this.ph = PreferencesHelper.getInstance(context);
        return this;
    }

    public VideoAd setOnLPGClickListener(OnVideoLPGListener onVideoLPGListener) {
        this.onVideoLPGListener = onVideoLPGListener;
        return this;
    }

    public OnVideoLPGListener getOnVideoLPGListener() {
        return this.onVideoLPGListener;
    }

    public void loadVideoAd() {
        if (this.adViewState == 1) {
            return;
        }
        if (!RuleManage.getInstance().isSend(this.context, this.uniplaySlotid)) {
            if (this.videoAdListener != null) {
                this.videoAdListener.onVideoAdFailed(ErrorCode.NOT_SEND_REQUEST_ONEHOUS_LIMIT.getCode());
            }
            SDKLog.e(this.getClass().getName(), "----7isSend:");
            return;
        }
        try {
            this.adViewState = 1;
            SDKLog.e("mHandler", "\u8bf7\u6c42\u5e7f\u544a");
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("appid", (Object)this.uniplayAppid);
            jSONObject.put("slotid", (Object)this.uniplaySlotid);
            jSONObject.put("vsdk", 50704);
            jSONObject.put("adt", 3);
            jSONObject.put("adw", 0);
            jSONObject.put("adh", 0);
            jSONObject.put("chn", (Object)ConfigureModule.getConfigureData("", "c").toString());
            if (this.context.getResources().getConfiguration().orientation == 2) {
                jSONObject.put("dso", 1);
            } else {
                jSONObject.put("dso", 2);
            }
            jSONObject.put("device", (Object)DeviceInfo.device);
            jSONObject.put("app", (Object)AppInfo.app);
            jSONObject.put("geo", (Object)GeoInfo.loc);
            SDKLog.e("Request", jSONObject.toString());
            StringEntity stringEntity = new StringEntity(jSONObject.toString(), "utf-8");
            HttpUtil.AddTaskToQueueHead("http://api.uniplayad.com/phone/video.php", stringEntity, 259, new AdParser(), this);
            AdManager.trackRequestAd();
        }
        catch (Exception exception) {
            if (this.videoAdListener != null) {
                this.videoAdListener.onVideoAdFailed(ErrorCode.PARAMETER_ERR_LIMIT.getCode());
            }
            exception.printStackTrace();
            this.adViewState = 0;
        }
    }

    public boolean isVideoReady() {
        return isVideoReady;
    }

    public void setCLoseBtnBig() {
        Constants.CLOSE_BUTTON = 38;
    }

    public void playVideoAd() {
        try {
            if (this.adViewState == 1) {
                return;
            }
            if (!isVideoReady) {
                if (this.videoAdListener != null) {
                    this.videoAdListener.onVideoAdFailed("\u8bf7\u91cd\u65b0\u62c9\u53d6\u7d20\u6750.");
                }
                return;
            }
            if (this.context != null && this.ad != null) {
                if (!TextUtils.isEmpty((CharSequence)this.ad.vurl)) {
                    Intent intent = new Intent(this.context, InterstitialAdActivity.class);
                    intent.putExtra("vhtml", this.ad.vhtml);
                    intent.putExtra("vurl", this.ad.vurl);
                    intent.putExtra("lurl", this.ad.lurl);
                    intent.putExtra("lpg", this.ad.lpg);
                    intent.putExtra("lpgclose", this.ad.lpgclose);
                    if (this.ad.lpgclick != null && this.ad.click != null) {
                        this.ad.lpgclick.addAll(this.ad.click);
                        SDKLog.e("info", "click\u53bb\u91cd\u524d\u957f\u5ea6" + this.ad.lpgclick.size());
                        this.ad.lpgclick = new ArrayList<String>(new HashSet<String>(this.ad.lpgclick));
                        SDKLog.e("info", "click\u53bb\u91cd\u540e\u957f\u5ea6" + this.ad.lpgclick.size());
                    }
                    intent.putExtra("lpgclick", this.ad.lpgclick);
                    intent.putExtra("vs", this.ad.vs);
                    intent.putExtra("vc", this.ad.vc);
                    intent.putExtra("vi", this.ad.vi);
                    intent.putExtra("keep", this.ad.keep);
                    intent.putExtra("imp", this.ad.imp);
                    intent.putExtra("pkg", this.ad.pkg);
                    intent.putExtra("cname", this.ad.cname);
                    intent.putExtra("downsucc ", this.ad.downsucc);
                    intent.putExtra("installsucc", this.ad.installsucc);
                    intent.putExtra("appactive", this.ad.appactive);
                    intent.putExtra("md5", this.ad.md5);
                    intent.putExtra("sin", this.ad.sin);
                    intent.putExtra("rpt", this.ad.rpt);
                    intent.putExtra("appname", this.ad.appname);
                    intent.putExtra("appicon", this.ad.appicon);
                    intent.putExtra(ParserTags.clktype, this.ad.clktype);
                    if (!this.ad.pt.isEmpty()) {
                        intent.putExtra("pt", this.ad.pt);
                    }
                    intent.putExtra("lpic", this.ad.lpic);
                    intent.putExtra("hidelogo", this.ad.hidelogo);
                    intent.putExtra("istouch", this.ad.istouch);
                    intent.setFlags(0x10000000);
                    if (this.video_topleft_logo != 0) {
                        intent.putExtra("video_topleft_logo", PicUtils.bitmap2Bytes(PicUtils.drawableToBitamp(this.context.getResources().getDrawable(this.video_topleft_logo))));
                    }
                    intent.putExtra("adLogo", this.adLogo);
                    intent.putExtra("closeTiem", this.closeTiem);
                    intent.putExtra("playgame", this.ad.isplaygame);
                    intent.putExtra(ParserTags.words, this.ad.words);
                    intent.putExtra(ParserTags.ad_deeplink, this.ad.dplink);
                    intent.putExtra(ParserTags.issuona, this.ad.issuona);
                    intent.putExtra(ParserTags.ismute, this.ad.ismute);
                    intent.putExtra("isbtn", this.ad.isbtn);
                    intent.putExtra("btnid", this.ad.btnid);
                    intent.putExtra("logoid", this.ad.logoid);
                    intent.putExtra("btnsz", this.ad.btnsz);
                    intent.putExtra("dtimes", this.ad.dtimes);
                    intent.putExtra("hidedtip", this.ad.hidedtip);
                    intent.putExtra("noxy", this.ad.noxy);
                    this.context.startActivity(intent);
                    this.ad = null;
                } else if (!TextUtils.isEmpty((CharSequence)this.ad.html)) {
                    if (this.ad.waitsec == 0) {
                        this.ad.waitsec = 15;
                    }
                    new InterstitialAd(this.context, this).showInterstitialAd((Activity)this.context, this.ad);
                    this.ad = null;
                } else if (this.videoAdListener != null) {
                    this.videoAdListener.onVideoAdFailed("\u6682\u65e0\u76f8\u5173\u7d20\u6750");
                }
            }
            isVideoReady = false;
        }
        catch (Exception exception) {
            if (this.videoAdListener != null) {
                this.videoAdListener.onVideoAdFailed(ErrorCode.PARAMETER_ERR_LIMIT.getCode());
            }
            isVideoReady = false;
        }
    }

    @Override
    public void onResult(Object object) {
        TaskEntity taskEntity = (TaskEntity)object;
        if (taskEntity.taskId == 259) {
            AdEntity adEntity = (AdEntity)taskEntity.outObject;
            if (adEntity.res == 0) {
                if (RuleManage.getInstance().isValid(this.context, adEntity.denypkg, adEntity.havepkg, adEntity.ruleurl)) {
                    this.ad = adEntity;
                    if (TextUtils.isEmpty((CharSequence)this.ad.vurl)) {
                        if (!TextUtils.isEmpty((CharSequence)this.ad.html) && this.videoAdListener != null) {
                            this.videoAdListener.onVideoAdReady();
                            if (this.ph != null) {
                                this.ph.saveVcont(0);
                                this.ph.saveVtime("");
                                this.ph.savaNoadnum(this.uniplaySlotid, adEntity.noadnum);
                                this.ph.savaNoadwait(this.uniplaySlotid, adEntity.noadwait);
                            }
                        } else {
                            if (this.videoAdListener != null) {
                                this.videoAdListener.onVideoAdFailed(adEntity.msg);
                            }
                            if (this.ph != null) {
                                this.ph.saveVcont(this.ph.getVcont() + 1);
                                this.ph.saveVtime(Utils.getDate("yyyy-M-d HH:mm:ss"));
                            }
                        }
                        this.adViewState = 0;
                    } else {
                        if (this.ph != null) {
                            this.ph.saveVcont(0);
                            this.ph.saveVtime("");
                            this.ph.savaNoadnum(this.uniplaySlotid, adEntity.noadnum);
                            this.ph.savaNoadwait(this.uniplaySlotid, adEntity.noadwait);
                        }
                        this.loadVideo();
                        AdManager.trackFetchedAd();
                    }
                } else {
                    if (this.videoAdListener != null) {
                        this.videoAdListener.onVideoAdFailed(ErrorCode.PKG_RULE_LIMIT.getCode());
                    }
                    this.adViewState = 0;
                    if (this.ph != null) {
                        this.ph.saveVcont(this.ph.getVcont() + 1);
                        this.ph.saveVtime(Utils.getDate("yyyy-M-d HH:mm:ss"));
                    }
                }
            } else {
                if (this.videoAdListener != null) {
                    if (null == adEntity.msg || adEntity.msg.isEmpty()) {
                        this.videoAdListener.onVideoAdFailed(ErrorCode.FOUND_AD_ERR.getCode());
                    } else {
                        this.videoAdListener.onVideoAdFailed(ErrorCode.AD_NOT_FOUND.getCode());
                    }
                }
                this.adViewState = 0;
                if (this.ph != null) {
                    this.ph.saveVcont(this.ph.getVcont() + 1);
                    this.ph.saveVtime(Utils.getDate("yyyy-M-d HH:mm:ss"));
                }
            }
        }
    }

    private void loadVideo() {
        if (!this.mThreadPool.getQueue().contains(this.loadVideo)) {
            this.mThreadPool.execute(this.loadVideo);
        }
    }

    @Override
    public void onError(Object object) {
        try {
            TaskEntity taskEntity = (TaskEntity)object;
            if (taskEntity.taskId == 259) {
                if (this.videoAdListener != null) {
                    this.videoAdListener.onVideoAdFailed(taskEntity.errorMsg.errorMessage);
                }
                this.adViewState = 0;
                if (this.ph != null) {
                    this.ph.saveVcont(this.ph.getVcont() + 1);
                    this.ph.saveVtime(Utils.getDate("yyyy-M-d HH:mm:ss"));
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void onInterstitialAdReady() {
        this.videoAdListener.onVideoAdReady();
    }

    @Override
    public void onInterstitialAdShow() {
        this.videoAdListener.onVideoAdComplete();
    }

    @Override
    public void onInterstitialAdClick() {
    }

    @Override
    public void onInterstitialAdFailed(String string2) {
        this.videoAdListener.onVideoAdFailed(string2);
    }

    @Override
    public void onInterstitialAdClose() {
        this.videoAdListener.onVideoAdClose();
    }
}

