/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.publisher;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import com.vungle.publisher.AdConfig;
import com.vungle.publisher.InitializationEventListener;
import com.vungle.publisher.VungleAdEventListener;
import com.vungle.publisher.VungleInitListener;
import com.vungle.publisher.bl;
import com.vungle.publisher.bm;
import com.vungle.publisher.bn;
import com.vungle.publisher.bo;
import com.vungle.publisher.c;
import com.vungle.publisher.ci;
import com.vungle.publisher.env.i;
import com.vungle.publisher.env.o;
import com.vungle.publisher.env.r;
import com.vungle.publisher.env.w;
import com.vungle.publisher.inject.Injector;
import com.vungle.publisher.log.Logger;
import com.vungle.publisher.log.g;
import com.vungle.publisher.mj;
import com.vungle.publisher.py;
import com.vungle.publisher.qg;
import com.vungle.publisher.qj;
import com.vungle.publisher.qk;
import com.vungle.publisher.qo;
import com.vungle.publisher.u;
import com.vungle.publisher.zj;
import com.vungle.publisher.zk;
import java.util.Arrays;
import java.util.logging.Level;
import javax.inject.Inject;

public abstract class VunglePubBase {
    public static final String VERSION = w.c + "5.3.2";
    private boolean n;
    @Inject
    c a;
    @Inject
    InitializationEventListener b;
    @Inject
    py.a c;
    @Inject
    qo d;
    @Inject
    ci e;
    @Inject
    protected i f;
    @Inject
    qg g;
    @Inject
    AdConfig h;
    @Inject
    u i;
    @Inject
    o j;
    @Inject
    r k;
    @Inject
    mj.a l;
    @Inject
    g m;

    protected VunglePubBase() {
    }

    protected void init(@NonNull Context context, @NonNull String string2, @NonNull @Size(min=1L) String[] stringArray, @Nullable VungleInitListener vungleInitListener) {
        try {
            Logger.d("Vungle", "init SDK requested with placements: " + zk.a(stringArray));
            if (this.n && this.k.a.get()) {
                Logger.d("Vungle", "already initialized");
                this.m.a.log(Level.FINE, "already initialized");
                this.setInitListener(vungleInitListener);
                this.g.a(new qk());
            } else if (this.n && this.k.b.get()) {
                Logger.d("Vungle", "initialization already in progress, ignoring this request");
                this.m.a.log(Level.FINE, "initialization already in progress, ignoring this request");
            } else {
                this.a(context, string2);
                this.m.a();
                this.setInitListener(vungleInitListener);
                if (!this.a()) {
                    this.a("device does not meet minimum Android API level for Vungle SDK", null);
                    this.m.a.log(Level.SEVERE, "device does not meet minimum Android API level for Vungle SDK");
                } else if (stringArray == null || stringArray.length < 1) {
                    this.a("need one or more placement reference IDs for initialization, got none", null);
                    this.m.a.log(Level.SEVERE, "need one or more placement reference IDs for initialization, got none");
                } else if (!zj.b(context)) {
                    this.a("initialization failed due to required permissions missing", null);
                    this.m.a.log(Level.SEVERE, "initialization failed due to required permissions missing");
                } else {
                    this.m.a.log(Level.INFO, VERSION + " init(" + string2 + ")");
                    this.d.b();
                    this.j.b(Arrays.asList(stringArray));
                    this.b.register();
                    this.j.b(Arrays.asList(stringArray));
                    this.a(context);
                }
            }
        }
        catch (Exception exception) {
            this.a("initialization failed with an exception", exception);
        }
    }

    public void setInitListener(VungleInitListener vungleInitListener) {
        String string2 = "VungleEvent";
        if (vungleInitListener == null) {
            Logger.d("VungleEvent", "ignoring set null init listener");
        } else {
            Logger.d("VungleEvent", "adding init listener " + vungleInitListener);
            py py2 = this.c.a(vungleInitListener);
            py2.register();
        }
    }

    private void a(String string2, Exception exception) {
        Logger.e("Vungle", string2, exception);
        if (this.n) {
            this.g.a(new qj(new Throwable(string2, exception)));
        }
    }

    private void a(Context context) {
        this.e.a();
        this.f.n();
        this.l.a(context);
    }

    protected boolean a() {
        String string2 = "VungleDevice";
        if (Build.VERSION.SDK_INT >= 14) {
            return true;
        }
        Logger.w("VungleDevice", "Device Android API level " + Build.VERSION.SDK_INT + " does not meet required minimum " + 14);
        return false;
    }

    protected void a(Context context, String string2) {
        if (Injector.getInstance().d()) {
            Logger.d("Vungle", "already injected");
        } else {
            Injector.getInstance().a(context, string2);
            Injector.c().a(this);
            Logger.d("Vungle", "injection successful");
            this.n = true;
        }
    }

    protected void addEventListeners(VungleAdEventListener ... vungleAdEventListenerArray) {
        try {
            if (this.n) {
                this.j.a(vungleAdEventListenerArray);
            } else {
                Logger.d("Vungle", "Error in addEventListeners(): VunglePub not injected/initialized");
            }
        }
        catch (Exception exception) {
            Logger.e("Vungle", "error adding eventListeners", exception);
        }
    }

    protected void clearAndSetEventListeners(VungleAdEventListener ... vungleAdEventListenerArray) {
        try {
            if (this.n) {
                this.j.c(vungleAdEventListenerArray);
            } else {
                Logger.d("Vungle", "Error in clearAndSetEventListeners(): VunglePub not injected/initialized");
            }
        }
        catch (Exception exception) {
            Logger.e("Vungle", "error setting event listeners", exception);
        }
    }

    protected void clearEventListeners() {
        try {
            if (this.n) {
                this.j.a();
            } else {
                Logger.d("Vungle", "Error in clearEventListener(): VunglePub not injected/initialized");
            }
        }
        catch (Exception exception) {
            Logger.e("Vungle", "error clearing event listeners", exception);
        }
    }

    protected void removeEventListeners(VungleAdEventListener ... vungleAdEventListenerArray) {
        try {
            if (this.n) {
                this.j.b(vungleAdEventListenerArray);
            } else {
                Logger.d("Vungle", "Error in removeEventListeners(): VunglePub not injected/initialized");
            }
        }
        catch (Exception exception) {
            Logger.e("Vungle", "error removing eventListeners", exception);
        }
    }

    protected AdConfig getGlobalAdConfig() {
        AdConfig adConfig = null;
        try {
            if (this.n) {
                adConfig = this.h;
            } else {
                Logger.e("Vungle", "error in getGlobalAdConfig() - VunglePub not injected");
            }
        }
        catch (Exception exception) {
            Logger.e("Vungle", "error getting globalAdConfig", exception);
        }
        return adConfig;
    }

    public void onResume() {
        try {
            if (this.n && this.k.a.get()) {
                this.k.c();
            }
        }
        catch (Exception exception) {
            Logger.e("Vungle", "error onResume()", exception);
        }
    }

    public void onPause() {
        try {
            if (this.n && this.k.a.get()) {
                this.k.h();
            }
        }
        catch (Exception exception) {
            Logger.e("Vungle", "error onPause()", exception);
        }
    }

    public boolean isInitialized() {
        return this.n && this.k.a.get();
    }

    public boolean isAdPlayable(@NonNull String string2) {
        boolean bl2 = false;
        try {
            Logger.d("Vungle", "isAdPlayable called for placement: " + string2);
            if (this.n && this.k.a.get()) {
                bl2 = this.a.b(string2);
            } else {
                Logger.w("Vungle", "Wait until successful initialization before calling isAdPlayable()");
            }
        }
        catch (Exception exception) {
            Logger.e("Vungle", "error returning ad playable", exception);
        }
        return bl2;
    }

    protected void loadAd(@NonNull String string2) {
        block6: {
            try {
                Logger.d("VungleAd", "VunglePub.loadAd() called for placement: " + string2);
                if (this.n) {
                    if (this.k.a.get()) {
                        this.a.e(string2);
                    } else {
                        Logger.w("Vungle", "Wait until successful initialization before calling loadAd()");
                        this.g.a(new bn(string2));
                    }
                } else {
                    Logger.e("Vungle", "Call init() before loadAd()");
                }
            }
            catch (Exception exception) {
                Logger.e("Vungle", "error in loadAd", exception);
                if (!this.n) break block6;
                this.g.a(new bl(string2));
            }
        }
    }

    protected void playAd(@NonNull String string2, @Nullable AdConfig adConfig) {
        block6: {
            String string3 = "VungleAd";
            try {
                Logger.d("VungleAd", "playAd() called for placement: " + string2);
                if (this.n) {
                    if (this.k.a.get()) {
                        this.a.a(string2, this.i.a(this.h, adConfig));
                    } else {
                        this.g.a(new bo<Object>(null, string2));
                    }
                } else {
                    Logger.e("VungleAd", "Call init() before playAd()");
                }
            }
            catch (Exception exception) {
                Logger.e("VungleAd", "error playing ad", exception);
                if (!this.n) break block6;
                this.g.a(new bm<Object>(null, string2));
            }
        }
    }

    protected boolean closeFlexViewAd(String string2) {
        return this.a.f(string2);
    }
}

