/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.net;

import java.util.concurrent.LinkedBlockingQueue;

public class TaskThreadPool {
    protected static int MAX_THREAD_POOL_COUNT = 3;
    protected int mThreadCount = MAX_THREAD_POOL_COUNT;
    private static final String TAG = TaskThreadPool.class.getSimpleName();
    private static TaskThreadPool threadPool = null;
    protected PoolWorker[] threads;
    private final LinkedBlockingQueue<Runnable> queue;

    public static synchronized TaskThreadPool getInstance() {
        return TaskThreadPool.getInstance(0);
    }

    public static synchronized TaskThreadPool getInstance(int n2) {
        if (null == threadPool) {
            threadPool = new TaskThreadPool(n2);
        }
        return threadPool;
    }

    private TaskThreadPool(int n2) {
        if (n2 != 0) {
            this.mThreadCount = n2;
        }
        this.queue = new LinkedBlockingQueue();
        if (this.threads == null) {
            this.initThreads();
        }
    }

    protected void initThreads() {
        this.threads = new PoolWorker[this.mThreadCount];
        for (int i2 = 0; i2 < this.mThreadCount; ++i2) {
            this.threads[i2] = new PoolWorker();
            this.threads[i2].start();
        }
    }

    public boolean isInRunning(Runnable runnable) {
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.mThreadCount; ++i2) {
            if (!(bl2 |= this.threads[i2].isInRunning(runnable))) continue;
            return bl2;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Runnable runnable) {
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = this.queue;
        synchronized (linkedBlockingQueue) {
            try {
                boolean bl2 = this.queue.contains(runnable);
                boolean bl3 = this.isInRunning(runnable);
                if (!bl2 && !bl3) {
                    this.queue.put(runnable);
                    this.queue.notifyAll();
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeUrgent(Runnable runnable) {
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = this.queue;
        synchronized (linkedBlockingQueue) {
            try {
                boolean bl2 = this.queue.contains(runnable);
                boolean bl3 = this.isInRunning(runnable);
                if (!bl3) {
                    if (bl2) {
                        this.queue.remove(runnable);
                    }
                    LinkedBlockingQueue linkedBlockingQueue2 = new LinkedBlockingQueue();
                    this.queue.drainTo(linkedBlockingQueue2);
                    this.queue.put(runnable);
                    this.queue.addAll(linkedBlockingQueue2);
                    this.queue.notifyAll();
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    class PoolWorker
    extends Thread {
        private boolean isCancle = false;
        Runnable r = null;

        PoolWorker() {
        }

        public boolean isCancle() {
            return this.isCancle;
        }

        public void setCancle(boolean bl2) {
            this.isCancle = bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isInRunning(Runnable runnable) {
            if (runnable == null) {
                return false;
            }
            LinkedBlockingQueue linkedBlockingQueue = TaskThreadPool.this.queue;
            synchronized (linkedBlockingQueue) {
                return runnable.equals(this.r);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isCancle) {
                LinkedBlockingQueue linkedBlockingQueue = TaskThreadPool.this.queue;
                synchronized (linkedBlockingQueue) {
                    while (TaskThreadPool.this.queue.isEmpty()) {
                        try {
                            TaskThreadPool.this.queue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    try {
                        this.r = (Runnable)TaskThreadPool.this.queue.take();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                try {
                    if (null != this.r) {
                        this.r.run();
                    }
                    this.r = null;
                }
                catch (RuntimeException runtimeException) {}
            }
        }
    }
}

