/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.download;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import android.util.Log;
import com.uniplay.adsdk.download.Downloader;
import com.uniplay.adsdk.download.URLDownloader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class Utils {
    static final int DEFAULT_READ_TIMEOUT = 25000;
    static final int DEFAULT_WRITE_TIMEOUT = 25000;
    static final int DEFAULT_CONNECT_TIMEOUT = 20000;
    static final String HTTP = "http";
    static final String HTTPS = "https";
    static final String LOCATION = "Location";
    static final String CONTENT_DISPOSITION = "Content-Disposition";
    static final int MAX_REDIRECTION = 5;
    static final int HTTP_OK = 200;
    static final int HTTP_PARTIAL = 206;
    static final int HTTP_TEMP_REDIRECT = 307;

    private Utils() {
    }

    static String getUuid() {
        return UUID.randomUUID().toString().trim().replaceAll("-", "");
    }

    static String md5(String string2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string2.getBytes("UTF-8"));
            BigInteger bigInteger = new BigInteger(1, messageDigest.digest());
            String string3 = bigInteger.toString(16);
            while (string3.length() < 32) {
                string3 = "0" + string3;
            }
            return string3;
        }
        catch (Exception exception) {
            return Utils.getUuid();
        }
    }

    static String getFilenameFromUrl(String string2) {
        String string3 = Utils.md5(string2) + ".down";
        int n2 = string2.lastIndexOf("/");
        if (n2 > 0) {
            String string4 = string2.substring(n2 + 1);
            int n3 = string4.indexOf("?");
            if (n3 > 0) {
                string4 = string4.substring(0, n3 - 1);
            }
            if (string4.contains(".")) {
                string3 = string4;
            }
        }
        return string3;
    }

    public static String getFilenameFromHeader(String string2, String string3) {
        String string4;
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            int n2 = string3.indexOf("filename");
            if (n2 > 0) {
                String string5 = string3.substring(n2 + 10, string3.length() - 1);
                return string5;
            }
            string4 = Utils.getFilenameFromUrl(string2);
        } else {
            string4 = Utils.getFilenameFromUrl(string2);
        }
        try {
            string4 = URLDecoder.decode(string4, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Log.e((String)"info", (String)("filename:" + string4));
        return string4;
    }

    static SSLContext createSSLContext() {
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                @Override
                @SuppressLint(value={"TrustAllX509TrustManager"})
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string2) {
                }

                @Override
                @SuppressLint(value={"TrustAllX509TrustManager"})
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string2) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            return sSLContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            generalSecurityException.printStackTrace();
            return null;
        }
    }

    static Downloader createDefaultDownloader() {
        return URLDownloader.create();
    }
}

