/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.download;

import android.content.Context;
import android.net.Uri;
import com.uniplay.adsdk.download.DownloadRequest;
import com.uniplay.adsdk.download.DownloadRequestQueue;
import com.uniplay.adsdk.download.DownloadState;
import com.uniplay.adsdk.download.Downloader;
import com.uniplay.adsdk.download.Preconditions;
import com.uniplay.adsdk.download.Utils;

public final class DownloadManager {
    private final Context context;
    private final Downloader downloader;
    private final int threadPoolSize;
    private DownloadRequestQueue downloadRequestQueue;

    DownloadManager(Builder builder) {
        this.context = Preconditions.checkNotNull(builder.context, "context == null").getApplicationContext();
        this.downloader = Preconditions.checkNotNull(builder.downloader, "downloader == null");
        this.threadPoolSize = builder.threadPoolSize;
        this.downloadRequestQueue = new DownloadRequestQueue(this.threadPoolSize);
        this.downloadRequestQueue.start();
    }

    public int add(DownloadRequest downloadRequest) {
        if (this.isDownloading((downloadRequest = Preconditions.checkNotNull(downloadRequest, "request == null")).uri().toString())) {
            return -1;
        }
        downloadRequest.setContext(this.context);
        downloadRequest.setDownloader(this.downloader.copy());
        return this.downloadRequestQueue.add(downloadRequest) ? downloadRequest.downloadId() : -1;
    }

    DownloadState query(int n2) {
        return this.downloadRequestQueue.query(n2);
    }

    DownloadState query(String string2) {
        return this.downloadRequestQueue.query(Uri.parse((String)string2));
    }

    public boolean isDownloading(int n2) {
        return this.query(n2) != DownloadState.INVALID;
    }

    public boolean isDownloading(String string2) {
        return this.query(string2) != DownloadState.INVALID;
    }

    public int getTaskSize() {
        return this.downloadRequestQueue == null ? 0 : this.downloadRequestQueue.getDownloadingSize();
    }

    public void cancel(int n2) {
        this.downloadRequestQueue.cancel(n2);
    }

    public void cancelAll() {
        this.downloadRequestQueue.cancelAll();
    }

    public void release() {
        if (this.downloadRequestQueue != null) {
            this.downloadRequestQueue.release();
            this.downloadRequestQueue = null;
        }
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static final class Builder {
        private Context context;
        private Downloader downloader;
        private int threadPoolSize;

        public Builder() {
            this.downloader = Utils.createDefaultDownloader();
            this.threadPoolSize = 3;
        }

        Builder(DownloadManager downloadManager) {
            this.context = downloadManager.context;
            this.downloader = downloadManager.downloader;
            this.threadPoolSize = downloadManager.threadPoolSize;
        }

        public Builder context(Context context) {
            this.context = context;
            return this;
        }

        public Builder downloader(Downloader downloader) {
            this.downloader = downloader;
            return this;
        }

        public Builder threadPoolSize(int n2) {
            this.threadPoolSize = n2;
            return this;
        }

        public DownloadManager build() {
            return new DownloadManager(this);
        }
    }
}

