/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import android.webkit.WebSettings;
import com.uniplay.adsdk.Imei;
import com.uniplay.adsdk.utils.MD5;
import com.uniplay.adsdk.utils.PreferencesHelper;
import com.uniplay.adsdk.utils.SDKLog;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import org.json.JSONObject;

public final class DeviceInfo {
    public static int screenWidth;
    public static int screenHeight;
    public static int densityDpi;
    public static boolean isSim;
    public static PreferencesHelper helper;
    private static String operator;
    private static String ssid;
    private static String bssid;
    private static String did;
    public static JSONObject device;
    public static String USER_AGENT;
    public static String mac;

    @TargetApi(value=17)
    public static void initDeviceInfo(Context context) {
        USER_AGENT = Build.VERSION.SDK_INT >= 17 ? WebSettings.getDefaultUserAgent((Context)context) : DeviceInfo.getCurrentUserAgent();
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        ArrayList<String> arrayList = new Imei().getImei(context);
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        mac = DeviceInfo.getMacAddress();
        bssid = wifiInfo.getBSSID();
        ssid = wifiInfo.getSSID().replaceAll("\"", "");
        String string2 = telephonyManager.getSubscriberId();
        String string3 = telephonyManager.getSimSerialNumber();
        if (telephonyManager != null && telephonyManager.getSimState() == 5) {
            isSim = true;
        }
        String string4 = Build.VERSION.RELEASE;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        screenWidth = displayMetrics.widthPixels;
        screenHeight = displayMetrics.heightPixels;
        densityDpi = displayMetrics.densityDpi;
        float f2 = displayMetrics.density;
        String string5 = Build.MODEL.replaceAll("_", "!");
        String string6 = Build.BRAND;
        int n2 = DeviceInfo.getNetWorkState(context);
        String string7 = DeviceInfo.getOperator(context);
        String string8 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        helper = PreferencesHelper.getInstance(context);
        did = helper.getDid();
        if (TextUtils.isEmpty((CharSequence)did)) {
            try {
                File file = new File(DeviceInfo.getSdcardPath() + "/Android/.sys");
                String string9 = DeviceInfo.readStringFromFile(file);
                try {
                    did = string9.trim();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (TextUtils.isEmpty((CharSequence)did)) {
                    did = MD5.getMD5(arrayList.get(0) + mac + string8);
                    SDKLog.e("info", "deviceinfo-----getMD5----->" + did);
                }
                if (did != null) {
                    did = did.replace("-", "").trim();
                }
                if (did != null && did.length() > 32) {
                    did = did.substring(0, 32);
                    SDKLog.e("info", "deviceinfo----substring------>" + did);
                }
                helper.saveDid(did);
                DeviceInfo.writeStringToFile(file, did);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            device = new JSONObject();
            device.put("dvt", 1);
            device.put("did", (Object)did);
            if (arrayList.size() == 1) {
                device.put("ime", (Object)arrayList.get(0));
            } else if (arrayList.size() >= 2) {
                device.put("ime", (Object)arrayList.get(0));
                device.put("ime2", (Object)arrayList.get(1));
            }
            if (TextUtils.isEmpty((CharSequence)string2)) {
                device.put("icc", (Object)"");
            } else {
                device.put("icc", (Object)string2);
            }
            if (TextUtils.isEmpty((CharSequence)string3)) {
                device.put("iccid", (Object)"");
            } else {
                device.put("iccid", (Object)string3);
            }
            if (TextUtils.isEmpty((CharSequence)string2)) {
                device.put("imsi", (Object)"");
            } else {
                device.put("imsi", (Object)string2);
            }
            device.put("plt", (Object)"1");
            device.put("ov", (Object)string4);
            device.put("dpi", (double)f2);
            device.put("swidth", screenWidth);
            device.put("sheight", screenHeight);
            device.put("mdl", (Object)string5);
            device.put("brd", (Object)string6);
            device.put("aid", (Object)string8);
            device.put("lg", (Object)Locale.getDefault().getLanguage());
            device.put("net", n2);
            device.put("opt", (Object)string7);
            if (TextUtils.isEmpty((CharSequence)mac)) {
                device.put("mac", (Object)"");
            } else {
                device.put("mac", (Object)mac);
            }
            device.put("si", isSim ? 1 : 0);
            device.put("bssid", (Object)bssid);
            device.put("ssid", (Object)ssid);
            if (Build.VERSION.SDK_INT >= 17) {
                device.put("ua", (Object)USER_AGENT);
            } else {
                device.put("ua", (Object)USER_AGENT);
            }
            device.put("storesize", (Object)DeviceInfo.getStorageSize(context));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static String getMacAddress() {
        try {
            byte[] byArray;
            String string2 = null;
            StringBuffer stringBuffer = new StringBuffer();
            NetworkInterface networkInterface = null;
            networkInterface = NetworkInterface.getByName("eth1");
            if (networkInterface == null) {
                networkInterface = NetworkInterface.getByName("wlan0");
            }
            if (networkInterface == null) {
                return "02:00:00:00:00:02";
            }
            for (byte by2 : byArray = networkInterface.getHardwareAddress()) {
                stringBuffer.append(String.format("%02X:", by2));
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            string2 = stringBuffer.toString();
            return string2;
        }
        catch (Exception exception) {
            return "02:00:00:00:00:02";
        }
    }

    public static String getSsid(Context context) {
        if (TextUtils.isEmpty((CharSequence)ssid)) {
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            ssid = wifiInfo.getSSID().replaceAll("\"", "").replaceAll("<", "").replaceAll(">", "");
        }
        return ssid;
    }

    public static String getDid(Context context) {
        block6: {
            try {
                if (!TextUtils.isEmpty((CharSequence)did)) break block6;
                if (helper == null) {
                    helper = PreferencesHelper.getInstance(context);
                }
                if (!TextUtils.isEmpty((CharSequence)(did = helper.getDid()))) break block6;
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                ArrayList<String> arrayList = new Imei().getImei(context);
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                String string2 = wifiInfo.getMacAddress();
                String string3 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                File file = new File(DeviceInfo.getSdcardPath() + "/Android/.sys");
                String string4 = DeviceInfo.readStringFromFile(file);
                try {
                    did = string4.trim();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (TextUtils.isEmpty((CharSequence)did)) {
                    did = MD5.getMD5(arrayList.get(0) + string2 + string3);
                }
                helper.saveDid(did);
                DeviceInfo.writeStringToFile(file, did);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return did;
    }

    public static int getToday() {
        Calendar calendar = Calendar.getInstance();
        String string2 = calendar.get(1) + "" + calendar.get(6);
        return Integer.parseInt(string2);
    }

    private static synchronized String getStorageSize(Context context) {
        File file = Environment.getExternalStorageDirectory();
        StatFs statFs = new StatFs(file.getPath());
        long l2 = statFs.getBlockSize();
        long l3 = statFs.getBlockCount();
        long l4 = statFs.getAvailableBlocks();
        long l5 = l3 * l2;
        long l6 = l4 * l2;
        return l5 + "_" + l6;
    }

    private static synchronized String getCurrentUserAgent() {
        String string2;
        Locale locale = Locale.getDefault();
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = Build.VERSION.RELEASE;
        if (string3.length() > 0) {
            stringBuffer.append("Mozilla/" + string3).append("(Linux; Android " + string3);
        } else {
            stringBuffer.append("Mozilla/1.0").append("(Linux; Android " + string3);
        }
        stringBuffer.append("; ");
        String string4 = locale.getLanguage();
        if (string4 != null) {
            stringBuffer.append(string4.toLowerCase());
            string2 = locale.getCountry();
            if (string2 != null) {
                stringBuffer.append("-");
                stringBuffer.append(string2.toLowerCase());
            }
        } else {
            stringBuffer.append("en");
        }
        if ("REL".equals(Build.VERSION.CODENAME) && (string2 = Build.MODEL).length() > 0) {
            stringBuffer.append("; ");
            stringBuffer.append(string2);
        }
        if ((string2 = Build.ID).length() > 0) {
            stringBuffer.append(" Build/)AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/45.0.2454.95 Mobile Safari/537.36");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String readStringFromFile(File file) {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[1024];
            int n2 = 0;
            while ((n2 = fileReader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n2);
            }
            fileReader.close();
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void writeStringToFile(File file, String string2) {
        FileWriter fileWriter = null;
        try {
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            fileWriter = new FileWriter(file);
            fileWriter.write(string2);
            fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getSdcardPath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    public static String getOperator(Context context) {
        if (!TextUtils.isEmpty((CharSequence)operator)) {
            return operator;
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager != null) {
            if (telephonyManager.getPhoneType() == 2 && telephonyManager.getSimState() == 5) {
                operator = telephonyManager.getNetworkOperator();
            } else if (telephonyManager.getSimState() == 5) {
                operator = telephonyManager.getSimOperator();
            }
        }
        return operator;
    }

    public static int getNetWorkState(Context context) {
        if (context == null) {
            return 0;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            String string2 = networkInfo.getTypeName();
            if (string2.equalsIgnoreCase("WIFI")) {
                return 1;
            }
            if (string2.equalsIgnoreCase("MOBILE")) {
                return DeviceInfo.isFastMobileNetwork(context);
            }
        } else {
            return 0;
        }
        return 0;
    }

    private static int isFastMobileNetwork(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        switch (telephonyManager.getNetworkType()) {
            case 7: {
                return 2;
            }
            case 4: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 3;
            }
            case 1: {
                return 2;
            }
            case 8: {
                return 4;
            }
            case 10: {
                return 3;
            }
            case 9: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 14: {
                return 4;
            }
            case 12: {
                return 4;
            }
            case 15: {
                return 4;
            }
            case 11: {
                return 2;
            }
            case 13: {
                return 4;
            }
            case 0: {
                return 2;
            }
        }
        return 2;
    }

    static {
        operator = "";
        ssid = "";
        bssid = "";
        did = "";
        USER_AGENT = "";
        mac = "";
    }

    public class NetworkState {
        public static final int NS_UNKNOWN = 0;
        public static final int NS_WIFI = 1;
        public static final int NS_2G = 2;
        public static final int NS_3G = 3;
        public static final int NS_4G = 4;
    }
}

