/*
 * Decompiled with CFR 0.152.
 */
package com.ksc.ad.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import android.view.ViewGroup;
import com.ksc.ad.sdk.IKsyunAdApi;
import com.ksc.ad.sdk.IKsyunAdInitResultListener;
import com.ksc.ad.sdk.IKsyunAdListener;
import com.ksc.ad.sdk.IKsyunAdLoadListener;
import com.ksc.ad.sdk.IKsyunRewardVideoAdListener;
import com.ksc.ad.sdk.InterstitialAd;
import com.ksc.ad.sdk.InterstitialAdListener;
import com.ksc.ad.sdk.KsyunAdSdkConfig;
import com.ksc.ad.sdk.SplashAd;
import com.ksc.ad.sdk.SplashAdListener;
import com.ksc.ad.sdk.plugin.KsyunPluginManager;
import com.ksc.ad.sdk.service.AdProxyService;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public class KsyunAdSdk
implements IKsyunAdApi {
    private static KsyunAdSdk mInstance = new KsyunAdSdk();
    private IKsyunAdApi mPluginSdkProxy;
    private AtomicBoolean mHasInitialized = new AtomicBoolean(false);
    private AtomicBoolean mIsInitializing = new AtomicBoolean(false);
    private AtomicBoolean mhasStartService = new AtomicBoolean(false);
    private KsyunAdSdkConfig mSdkConfig = new KsyunAdSdkConfig();

    public static KsyunAdSdk getInstance() {
        return mInstance;
    }

    private KsyunAdSdk() {
    }

    @Override
    public synchronized void init(Activity activity, String string2, IKsyunAdInitResultListener iKsyunAdInitResultListener) {
        this.init(activity, string2, this.getDefaultSdkConfig(), iKsyunAdInitResultListener);
    }

    @Override
    public void init(Activity activity, String string2, String string3, IKsyunAdInitResultListener iKsyunAdInitResultListener) {
        this.init(activity, string2, string3, this.getDefaultSdkConfig(), iKsyunAdInitResultListener);
    }

    @Override
    public void init(Activity activity, String string2, KsyunAdSdkConfig ksyunAdSdkConfig, IKsyunAdInitResultListener iKsyunAdInitResultListener) {
        this.init(activity, string2, "", ksyunAdSdkConfig, iKsyunAdInitResultListener);
    }

    @Override
    public void init(final Activity activity, final String string2, final String string3, final KsyunAdSdkConfig ksyunAdSdkConfig, final IKsyunAdInitResultListener iKsyunAdInitResultListener) {
        if (activity == null) {
            iKsyunAdInitResultListener.onFailure(1000, "activity can not be null");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            iKsyunAdInitResultListener.onFailure(1000, "appId can not be null");
            return;
        }
        if (this.mHasInitialized.get()) {
            Log.w((String)"ad_trace", (String)"KsyunAdSdk has initialized,do not try again");
            iKsyunAdInitResultListener.onFailure(1013, "KsyunAdSdk has initialized,do not try again");
        } else if (this.mIsInitializing.get()) {
            Log.w((String)"ad_trace", (String)"KsyunAdSdk is initializing,please wait");
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    KsyunAdSdk.this.mIsInitializing.compareAndSet(false, true);
                    KsyunAdSdk.this.initPlugin(activity, string2, string3, ksyunAdSdkConfig, iKsyunAdInitResultListener);
                }
            }).start();
        }
    }

    private KsyunAdSdkConfig getDefaultSdkConfig() {
        return this.mSdkConfig;
    }

    private void initPlugin(final Activity activity, final String string2, final String string3, final KsyunAdSdkConfig ksyunAdSdkConfig, final @NonNull IKsyunAdInitResultListener iKsyunAdInitResultListener) {
        KsyunPluginManager.getInstance(activity.getApplicationContext()).loadPlugin(activity.getApplicationContext(), new KsyunPluginManager.PluginManagerListener(){

            @Override
            public void onLoadPluginSuccess() {
                KsyunAdSdk.this.initProxy(activity, string2, string3, ksyunAdSdkConfig, iKsyunAdInitResultListener);
            }

            @Override
            public void onLoadPluginFailure(int n2, String string22) {
                iKsyunAdInitResultListener.onFailure(n2, string22);
            }
        });
    }

    private void initProxy(final Activity activity, String string2, String string3, KsyunAdSdkConfig ksyunAdSdkConfig, final @NonNull IKsyunAdInitResultListener iKsyunAdInitResultListener) {
        this.mPluginSdkProxy = KsyunPluginManager.getInstance(activity.getApplicationContext()).getPluginSdkProxy();
        if (this.mPluginSdkProxy != null) {
            Log.d((String)"GetThread", (String)("sdk init" + Thread.currentThread().getName() + " " + Thread.currentThread().getId() + " is main thread:" + this.isMainThread()));
            this.mPluginSdkProxy.init(activity, string2, string3, ksyunAdSdkConfig, new IKsyunAdInitResultListener(){

                @Override
                public void onSuccess(Map<String, String> map) {
                    KsyunAdSdk.this.mIsInitializing.compareAndSet(true, false);
                    KsyunAdSdk.this.mHasInitialized.compareAndSet(false, true);
                    iKsyunAdInitResultListener.onSuccess(map);
                    KsyunAdSdk.this.startService(activity.getApplicationContext());
                }

                @Override
                public void onFailure(int n2, String string2) {
                    KsyunAdSdk.this.mIsInitializing.compareAndSet(true, false);
                    iKsyunAdInitResultListener.onFailure(n2, string2);
                }
            });
        } else {
            iKsyunAdInitResultListener.onFailure(1001, "sdk plugin loaded failure");
        }
    }

    @Override
    public synchronized void showAd(Activity activity, String string2) {
        if (activity == null) {
            Log.e((String)"ad_trace", (String)"activity can not be null");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Log.e((String)"ad_trace", (String)"adSlotId can not be null");
            return;
        }
        if (!this.mHasInitialized.get()) {
            Log.e((String)"ad_trace", (String)"KsyunAdSdk is not initialized, please call init method first");
        }
        if (this.mPluginSdkProxy != null) {
            this.mPluginSdkProxy.showAd(activity, string2);
        } else {
            Log.e((String)"ad_trace", (String)"sdk plugin loaded failure");
        }
    }

    @Override
    public synchronized void loadAd(String string2, IKsyunAdLoadListener iKsyunAdLoadListener) {
        if (!this.mHasInitialized.get()) {
            Log.e((String)"ad_trace", (String)"KsyunAdSdk is not initialized, please call init method first");
            return;
        }
        if (this.mPluginSdkProxy != null) {
            this.mPluginSdkProxy.loadAd(string2, iKsyunAdLoadListener);
        } else {
            Log.e((String)"ad_trace", (String)"sdk plugin loaded failure");
        }
    }

    private boolean isMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    @Override
    public synchronized void loadAd(@NonNull IKsyunAdLoadListener iKsyunAdLoadListener) {
        if (!this.mHasInitialized.get()) {
            Log.e((String)"ad_trace", (String)"KsyunAdSdk is not initialized, please call init method first");
            iKsyunAdLoadListener.onAdInfoFailed(1002, "KsyunAdSdk is not initialized, please call init method first");
            return;
        }
        if (this.mPluginSdkProxy != null) {
            Log.d((String)"GetThread", (String)("sdk preloadAd" + Thread.currentThread().getName() + " " + Thread.currentThread().getId() + " is main thread:" + this.isMainThread()));
            this.mPluginSdkProxy.loadAd(iKsyunAdLoadListener);
        } else {
            Log.e((String)"ad_trace", (String)"sdk plugin loaded failure");
            iKsyunAdLoadListener.onAdInfoFailed(1001, "sdk plugin loaded failure");
        }
    }

    @Override
    public boolean hasAd(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Log.e((String)"ad_trace", (String)"adSlotId can not be null");
            return false;
        }
        if (!this.mHasInitialized.get()) {
            Log.e((String)"ad_trace", (String)"KsyunAdSdk is not initialized, please call init method first");
            return false;
        }
        if (this.mPluginSdkProxy != null) {
            return this.mPluginSdkProxy.hasAd(string2);
        }
        Log.e((String)"ad_trace", (String)"sdk plugin loaded failure");
        return false;
    }

    @Override
    public synchronized void setRewardVideoAdListener(@NonNull IKsyunRewardVideoAdListener iKsyunRewardVideoAdListener) {
        if (!this.mHasInitialized.get()) {
            Log.e((String)"ad_trace", (String)"KsyunAdSdk is not initialized, please call init method first");
            iKsyunRewardVideoAdListener.onAdAwardFailed("", 1002, "KsyunAdSdk is not initialized, please call init method first");
        }
        if (this.mPluginSdkProxy != null) {
            this.mPluginSdkProxy.setRewardVideoAdListener(iKsyunRewardVideoAdListener);
        } else {
            Log.e((String)"ad_trace", (String)"sdk plugin loaded failure");
            iKsyunRewardVideoAdListener.onAdAwardFailed("", 1001, "sdk plugin loaded failure");
        }
    }

    @Override
    public void setAdListener(@NonNull IKsyunAdListener iKsyunAdListener) {
        if (!this.mHasInitialized.get()) {
            Log.e((String)"ad_trace", (String)"KsyunAdSdk is not initialized, please call init method first");
            iKsyunAdListener.onShowFailed("", 1002, "KsyunAdSdk is not initialized, please call init method first");
        }
        if (this.mPluginSdkProxy != null) {
            this.mPluginSdkProxy.setAdListener(iKsyunAdListener);
        } else {
            Log.e((String)"ad_trace", (String)"sdk plugin loaded failure");
            iKsyunAdListener.onShowFailed("", 1001, "sdk plugin loaded failure");
        }
    }

    @Override
    public void removeAdListener() {
        if (!this.mHasInitialized.get()) {
            Log.e((String)"ad_trace", (String)"KsyunAdSdk is not initialized, please call init method first");
        }
        if (this.mPluginSdkProxy != null) {
            this.mPluginSdkProxy.removeAdListener();
        } else {
            Log.e((String)"ad_trace", (String)"sdk plugin loaded failure");
        }
    }

    @Override
    public void removeRewardVideoAdListener() {
        if (!this.mHasInitialized.get()) {
            Log.e((String)"ad_trace", (String)"KsyunAdSdk is not initialized, please call init method first");
        }
        if (this.mPluginSdkProxy != null) {
            this.mPluginSdkProxy.removeRewardVideoAdListener();
        } else {
            Log.e((String)"ad_trace", (String)"sdk plugin loaded failure");
        }
    }

    @Override
    public void removeAllListener() {
        if (!this.mHasInitialized.get()) {
            Log.e((String)"ad_trace", (String)"KsyunAdSdk is not initialized, please call init method first");
        }
        if (this.mPluginSdkProxy != null) {
            this.mPluginSdkProxy.removeAllListener();
        } else {
            Log.e((String)"ad_trace", (String)"sdk plugin loaded failure");
        }
    }

    @Override
    public synchronized String getSdkVersion() {
        if (!this.mHasInitialized.get()) {
            Log.e((String)"ad_trace", (String)"KsyunAdSdk is not initialized, please call init method first");
            return "";
        }
        if (this.mPluginSdkProxy != null) {
            return this.mPluginSdkProxy.getSdkVersion();
        }
        Log.e((String)"ad_trace", (String)"sdk plugin loaded failure");
        return "";
    }

    @Override
    public void clearCache() {
        if (this.mPluginSdkProxy != null) {
            this.mPluginSdkProxy.clearCache();
        } else {
            Log.e((String)"ad_trace", (String)"sdk plugin mPluginSdkProxy == null ");
        }
    }

    @Override
    public void onResume(Activity activity) {
        if (!this.mHasInitialized.get()) {
            Log.e((String)"ad_trace", (String)"KsyunAdSdk is not initialized, please call init method first");
        }
        if (this.mPluginSdkProxy != null) {
            this.mPluginSdkProxy.onResume(activity);
        } else {
            Log.e((String)"ad_trace", (String)"sdk plugin loaded failure");
        }
    }

    @Override
    public void onPause(Activity activity) {
        if (!this.mHasInitialized.get()) {
            Log.e((String)"ad_trace", (String)"KsyunAdSdk is not initialized, please call init method first");
        }
        if (this.mPluginSdkProxy != null) {
            this.mPluginSdkProxy.onPause(activity);
        } else {
            Log.e((String)"ad_trace", (String)"sdk plugin loaded failure");
        }
    }

    @Override
    public void onDestroy(Activity activity) {
        if (!this.mHasInitialized.get()) {
            Log.e((String)"ad_trace", (String)"KsyunAdSdk is not initialized, please call init method first");
        }
        if (this.mPluginSdkProxy != null) {
            this.mPluginSdkProxy.onDestroy(activity);
        } else {
            Log.e((String)"ad_trace", (String)"sdk plugin loaded failure");
        }
    }

    @Override
    public void setAutoCachedAdSlot(String string2) {
        if (!this.mHasInitialized.get()) {
            Log.e((String)"ad_trace", (String)"KsyunAdSdk is not initialized, please call init method first");
        }
        if (this.mPluginSdkProxy != null) {
            this.mPluginSdkProxy.setAutoCachedAdSlot(string2);
        } else {
            Log.e((String)"ad_trace", (String)"sdk plugin loaded failure");
        }
    }

    private synchronized void stopService(Context context) {
        Intent intent = new Intent();
        intent.setClass(context, AdProxyService.class);
        context.stopService(intent);
    }

    private synchronized void startService(Context context) {
        if (this.mhasStartService.compareAndSet(false, true)) {
            Intent intent = new Intent();
            intent.setClass(context, AdProxyService.class);
            context.startService(intent);
        } else {
            Log.e((String)"ad_trace", (String)"service has start");
        }
    }

    public synchronized void resetSdk(Context context) {
        this.mHasInitialized.compareAndSet(true, false);
        this.mIsInitializing.compareAndSet(true, false);
        this.mPluginSdkProxy = null;
        this.stopService(context);
        this.removeAllListener();
    }

    private void initSdkPlugin(Activity activity, KsyunPluginManager.PluginManagerListener pluginManagerListener) {
        KsyunPluginManager.getInstance(activity.getApplicationContext()).loadPlugin(activity.getApplicationContext(), pluginManagerListener);
    }

    @Override
    public SplashAd initSplashAd(final Activity activity, ViewGroup viewGroup, final String string2, int n2, boolean bl2, final SplashAdListener splashAdListener) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        this.initSdkPlugin(activity, new KsyunPluginManager.PluginManagerListener(){

            @Override
            public void onLoadPluginSuccess() {
                KsyunAdSdk.this.mPluginSdkProxy = KsyunPluginManager.getInstance(activity.getApplicationContext()).getPluginSdkProxy();
                countDownLatch.countDown();
                Log.d((String)"SplashView", (String)"initSplashAd: load success");
            }

            @Override
            public void onLoadPluginFailure(int n2, String string22) {
                countDownLatch.countDown();
                splashAdListener.onSplashAdShowFailed(n2, string2);
                Log.d((String)"SplashView", (String)"initSplashAd: load fail");
            }
        });
        Log.d((String)"SplashView", (String)"initSplashAd: wait");
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        Log.d((String)"SplashView", (String)"initSplashAd: continue");
        this.startService(activity.getApplicationContext());
        if (null != this.mPluginSdkProxy) {
            Log.d((String)"SplashView", (String)"initSplashAd: init");
            return this.mPluginSdkProxy.initSplashAd(activity, viewGroup, string2, n2, bl2, splashAdListener);
        }
        Log.d((String)"SplashView", (String)"initSplashAd: is null");
        return null;
    }

    @Override
    @Deprecated
    public void setSplashAdListener(SplashAdListener splashAdListener) {
        if (this.mPluginSdkProxy != null) {
            Log.d((String)"SplashView", (String)"initSplashAd: is null");
            this.mPluginSdkProxy.setSplashAdListener(splashAdListener);
        } else {
            Log.d((String)"SplashView", (String)"sdk plugin loaded failure");
        }
    }

    @Override
    public void removeSplashAdListener() {
        if (this.mPluginSdkProxy != null) {
            this.mPluginSdkProxy.removeSplashAdListener();
        } else {
            Log.e((String)"SplashView", (String)"sdk plugin loaded failure");
        }
    }

    @Override
    public InterstitialAd initInterstitialAd(Activity activity, String string2, boolean bl2, InterstitialAdListener interstitialAdListener) {
        if (null != this.mPluginSdkProxy) {
            Log.d((String)"InterstitialView", (String)"initInterstitialAd: init");
            return this.mPluginSdkProxy.initInterstitialAd(activity, string2, bl2, interstitialAdListener);
        }
        Log.d((String)"InterstitialView", (String)"initInterstitialAd: mPluginSdkProxy is null");
        return null;
    }

    @Override
    @Deprecated
    public void setInterstitialAdListener(InterstitialAdListener interstitialAdListener) {
        if (!this.mHasInitialized.get()) {
            Log.e((String)"ad_trace", (String)"KsyunAdSdk is not initialized, please call init method first");
        }
        if (this.mPluginSdkProxy != null) {
            this.mPluginSdkProxy.setInterstitialAdListener(interstitialAdListener);
        } else {
            Log.e((String)"ad_trace", (String)"sdk plugin loaded failure");
        }
    }

    @Override
    public void removeInterstitialAdListener() {
        if (!this.mHasInitialized.get()) {
            Log.e((String)"ad_trace", (String)"KsyunAdSdk is not initialized, please call init method first");
        }
        if (this.mPluginSdkProxy != null) {
            this.mPluginSdkProxy.removeInterstitialAdListener();
        } else {
            Log.e((String)"ad_trace", (String)"sdk plugin loaded failure");
        }
    }
}

