package com.yodo1ads.adapter.video;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.bytedance.sdk.openadsdk.AdSlot;
import com.bytedance.sdk.openadsdk.TTAdNative;
import com.bytedance.sdk.openadsdk.TTRewardVideoAd;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1ads.plugin.toutiao.AdConfigToutiao;
import com.yodo1ads.plugin.toutiao.AdvertCoreToutiao;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.advert.video.Yodo1VideoReloadCallback;
import com.yodo1.sdk.kit.YLog;

/**
 * Created by yodo1 on 18/3/5.
 */

public class AdvertAdaptertoutiao extends AdVideoAdapterBase {
    private boolean hasCached = false;
    private TTAdNative mTTAdNative;
    private TTRewardVideoAd mttRewardVideoAd;
    private Yodo1VideoCallback videoCallback;
    private Yodo1VideoReloadCallback reloadCallback;
    private TTAdNative.RewardVideoAdListener rewardAdLister = new TTAdNative.RewardVideoAdListener(){

        @Override
        public void onError(int code, String message) {
            YLog.e("AdvertAdaptertoutiao rewardVideo onError code==" + code + "  message==" + message);
            if(reloadCallback!=null){
                reloadCallback.onReload(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FAILED, getAdvertCode());
            }
        }

        @Override
        public void onRewardVideoAdLoad(TTRewardVideoAd ttRewardVideoAd) {
            if(reloadCallback!=null){
                reloadCallback.onReload(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FINISH, getAdvertCode());
            }

            mttRewardVideoAd = ttRewardVideoAd;
            mttRewardVideoAd.setRewardAdInteractionListener(new TTRewardVideoAd.RewardAdInteractionListener() {

                @Override
                public void onAdShow() {
                    YLog.i( "AdvertAdaptertoutiao rewardVideoAd show");
                    if(videoCallback != null){
                        videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
                    }

                }

                @Override
                public void onAdVideoBarClick() {
                    if(videoCallback != null){
                        videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLICK, getAdvertCode());
                    }
                }

                @Override
                public void onAdClose() {
                    YLog.i( "AdvertAdaptertoutiao rewardVideoAd close");
                    if(videoCallback != null){
                        videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
                    }
                }

                @Override
                public void onVideoComplete() {
                    YLog.i( "AdvertAdaptertoutiao rewardVideoAd complete");
                    if(videoCallback != null){
                        videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_FINISH, getAdvertCode());
                    }
                }

                @Override
                public void onRewardVerify(boolean rewardVerify, int rewardAmount, String rewardName) {
                    YLog.i( "AdvertAdaptertoutiao rewardVideoAd verify:"+rewardVerify+" amount:"+rewardAmount+
                    " name:"+rewardName);
                }
            });
        }

        @Override
        public void onRewardVideoCached() {
            hasCached = true;
        }
    };
    @Override
    public void showVideoAdvert(Activity activity, Yodo1VideoCallback callback) {
        this.videoCallback = callback;
       
        if (mttRewardVideoAd != null && hasCached){
            mttRewardVideoAd.showRewardVideoAd(activity);
            mttRewardVideoAd = null;
        }else{
            YLog.d("AdvertAdaptertoutiao rewardVideoAd 没有广告缓存");
            videoCallback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }

        hasCached = false;
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1VideoReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;
        if(TextUtils.isEmpty(AdConfigToutiao.video_id)){
            YLog.e("toutiao  video_id is null");
            return;
        }
        AdSlot adSlot = new AdSlot.Builder()
                .setCodeId(AdConfigToutiao.video_id)
                .setSupportDeepLink(true)
                .setImageAcceptedSize(1080, 1920)
                .build();
        mTTAdNative.loadRewardVideoAd(adSlot, rewardAdLister);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return mttRewardVideoAd != null && hasCached;
    }

    @Override
    public String getAdvertCode() {
        return AdConfigToutiao.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {
        AdConfigToutiao.video_id = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigToutiao.CHANNEL_CODE
                , AdConfigToutiao.KEY_VIDEO_ID);
        if(TextUtils.isEmpty(AdConfigToutiao.video_id)){
            YLog.e("toutiao  video_id is null");
            return;
        }
        //创建TTAdNative对象,用于调用广告请求接口
        mTTAdNative = AdvertCoreToutiao.getAdManager(activity).createAdNative(activity);
    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
