package com.yodo1ads.adapter.interstitial;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.interstitial.Yodo1InterstitialCallback;
import com.yodo1.advert.interstitial.Yodo1InterstitialReloadCallback;
import com.yodo1ads.plugin.vungle.AdConfigVungle;
import com.yodo1ads.plugin.vungle.AdvertCoreVungle;
import com.yodo1.sdk.kit.YLog;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdaptervungle extends AdInterstitialAdapterBase {

    @Override
    public String getAdvertCode() {
        return AdConfigVungle.CHANNEL_CODE;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {

        AdvertCoreVungle.getInstance().validateAdsAdapter(activity);

    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(final Activity activity) {

        AdvertCoreVungle.getInstance().init(activity);
    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
        AdvertCoreVungle.getInstance().onResume(activity);
    }

    @Override
    public void onPause(Activity activity) {
        AdvertCoreVungle.getInstance().onPause(activity);
    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {
        AdvertCoreVungle.getInstance().onDestroy(activity);
    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }

    @Override
    public void showIntersititalAdvert(final Activity activity,final Yodo1InterstitialCallback callback) {
        YLog.d("Vungle, showVideoAdvert");
        if (TextUtils.isEmpty( AdConfigVungle.APP_ID)){
            YLog.i("Vungle  appid  is null");
            callback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "Vungle  appid  is null", getAdvertCode());

            return ;
        }
        if (TextUtils.isEmpty(AdConfigVungle.INTERSTITIAL_PLACEMENTID)){
            YLog.i("Vungle intertitial placementid is null");
            callback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "Vungle  intertitial placementid  is null", getAdvertCode());
            return;
        }

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (interstitialAdvertIsLoaded(activity)) {

                    // Check a Placement if it is ready to play the Ad
                    AdvertCoreVungle.getInstance().playIntersititalAdvert(AdConfigVungle.INTERSTITIAL_PLACEMENTID,callback);
                }else {
                    callback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
                }
            }
        });
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity,final Yodo1InterstitialReloadCallback callback) {
            if (TextUtils.isEmpty(AdConfigVungle.INTERSTITIAL_PLACEMENTID)){
                YLog.i("Vungle,  reloadInterstitialAdvert Interstitial PlacementId  is null");
                return;
            }
            YLog.d("Vungle, reloadInterstitialAdvert");

            AdvertCoreVungle.getInstance().reloadIntersititalAdvert(AdConfigVungle.INTERSTITIAL_PLACEMENTID,callback);
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
            return  AdvertCoreVungle.getInstance().AdvertIsLoaded(activity,AdConfigVungle.INTERSTITIAL_PLACEMENTID);
    }


}
