package com.yodo1ads.adapter.interstitial;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;

import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.interstitial.Yodo1InterstitialCallback;
import com.yodo1.advert.interstitial.Yodo1InterstitialReloadCallback;
import com.yodo1ads.plugin.oneway.AdConfigOneway;
import com.yodo1ads.plugin.oneway.AdvertCoreOneway;
import com.yodo1.sdk.kit.YLog;


import mobi.oneway.sdk.OWInterstitialAd;
import mobi.oneway.sdk.OWInterstitialAdListener;
import mobi.oneway.sdk.OnewayAdCloseType;
import mobi.oneway.sdk.OnewaySdkError;

/**
 * Created by yodo1 on 17/9/14.
 */
public class AdvertAdapteroneway extends AdInterstitialAdapterBase {

    private boolean isLoaded;
    private Yodo1InterstitialCallback intersititalCallback; //插屏回调
    private Yodo1InterstitialReloadCallback callback;
    @Override
    public String getAdvertCode() {
        return AdConfigOneway.CHANNEL_CODE;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreOneway.getInstance().validateAdsAdapter(activity);

    }


    private OWInterstitialAdListener interstitialAdListener = new OWInterstitialAdListener() {
        @Override
        public void onAdReady() {
            // 广告已经准备好，可以进行播放
            isLoaded = true;
            if(callback != null){
                callback.onResult(Yodo1InterstitialReloadCallback.ADVERT_INTERSTITIAL_RELOAD_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onAdShow(String tag) {
            if(intersititalCallback != null){
                intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onAdClick(String tag) {
            if(intersititalCallback != null){
                intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdClose(String tag, OnewayAdCloseType onewayVideoCloseType) {
            if(intersititalCallback != null){
                intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onSdkError(OnewaySdkError onewaySdkError, String s) {
        }
    };

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {
        AdvertCoreOneway.getInstance().init(activity);
        OWInterstitialAd.init(interstitialAdListener);
    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }

    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1InterstitialCallback callback) {
        this.intersititalCallback = callback;
        if (isLoaded && OWInterstitialAd.isReady()) {
            OWInterstitialAd.show(activity);
        } else {
            intersititalCallback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }

        isLoaded = false;
    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1InterstitialReloadCallback callback) {
        this.callback = callback;
    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return isLoaded;
    }
}
