/*
 * Decompiled with CFR 0.152.
 */
package com.uniplay.adsdk.utils.rsa;

import com.uniplay.adsdk.utils.rsa.Base64Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public final class RSAUtils {
    private static final String KEY_PAIR = "RSA";
    private static final String CIPHER = "RSA/ECB/PKCS1Padding";
    public static final String PublicKey = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAytPGbwp33vhhfpVngiFS\nT9Pi7Z3y6gKHo2hpvaE1W6qHUyXIla8JRZe+hPY96rsVZOc0e4uZCIDVDceifWYS\n1xhQ/KcRfouBMCwTnJCz5jMLfnRBZICpAemRdOpnK4eSQFxPHn9brMAPvFxgFMeT\nqAhi5HhRJuC5IectlJvqCldUeUsnQNW2dMJCr1yL/XxsEaQCQt5iRZ5AXbAydt3Q\nIG9nk4tOtLwh3ST61A2ABTRel1CsFZlxqXJP04absi6GuHpWpUCC18Sxb4acH57R\nDA7VmC0h2A93X1JXcDX3r71oiOjyotKoyVO/eeSM2Uhwvxy3DQcymPkrg2yMxIm4\nCQIDAQAB";

    public static KeyPair generateRSAKeyPair() {
        return RSAUtils.generateRSAKeyPair(1024);
    }

    public static KeyPair generateRSAKeyPair(int n2) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_PAIR);
            keyPairGenerator.initialize(n2);
            return keyPairGenerator.genKeyPair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return null;
        }
    }

    public static byte[] encryptData(byte[] byArray, PublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER);
            cipher.init(1, publicKey);
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static byte[] decryptData(byte[] byArray, PrivateKey privateKey) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER);
            cipher.init(2, privateKey);
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static PublicKey getPublicKey(byte[] byArray) {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_PAIR);
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        return publicKey;
    }

    public static PrivateKey getPrivateKey(byte[] byArray) {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_PAIR);
        PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        return privateKey;
    }

    public static PublicKey getPublicKey(String string2, String string3) {
        BigInteger bigInteger = new BigInteger(string2);
        BigInteger bigInteger2 = new BigInteger(string3);
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger2);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_PAIR);
        PublicKey publicKey = keyFactory.generatePublic(rSAPublicKeySpec);
        return publicKey;
    }

    public static PrivateKey getPrivateKey(String string2, String string3) {
        BigInteger bigInteger = new BigInteger(string2);
        BigInteger bigInteger2 = new BigInteger(string3);
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger2);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_PAIR);
        PrivateKey privateKey = keyFactory.generatePrivate(rSAPublicKeySpec);
        return privateKey;
    }

    public static PublicKey loadPublicKey(String string2) {
        try {
            byte[] byArray = Base64Utils.decode(string2);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_PAIR);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Exception("\u65e0\u6b64\u7b97\u6cd5");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new Exception("\u516c\u94a5\u975e\u6cd5");
        }
        catch (NullPointerException nullPointerException) {
            throw new Exception("\u516c\u94a5\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public static PrivateKey loadPrivateKey(String string2) {
        try {
            byte[] byArray = Base64Utils.decode(string2);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_PAIR);
            return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Exception("\u65e0\u6b64\u7b97\u6cd5");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new Exception("\u79c1\u94a5\u975e\u6cd5");
        }
        catch (NullPointerException nullPointerException) {
            throw new Exception("\u79c1\u94a5\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public static PublicKey loadPublicKey(InputStream inputStream) {
        try {
            return RSAUtils.loadPublicKey(RSAUtils.readKey(inputStream));
        }
        catch (IOException iOException) {
            throw new Exception("\u516c\u94a5\u6570\u636e\u6d41\u8bfb\u53d6\u9519\u8bef");
        }
        catch (NullPointerException nullPointerException) {
            throw new Exception("\u516c\u94a5\u8f93\u5165\u6d41\u4e3a\u7a7a");
        }
    }

    public static PrivateKey loadPrivateKey(InputStream inputStream) {
        try {
            return RSAUtils.loadPrivateKey(RSAUtils.readKey(inputStream));
        }
        catch (IOException iOException) {
            throw new Exception("\u79c1\u94a5\u6570\u636e\u8bfb\u53d6\u9519\u8bef");
        }
        catch (NullPointerException nullPointerException) {
            throw new Exception("\u79c1\u94a5\u8f93\u5165\u6d41\u4e3a\u7a7a");
        }
    }

    private static String readKey(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = null;
        StringBuilder stringBuilder = new StringBuilder();
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.charAt(0) == '-') continue;
            stringBuilder.append(string2);
            stringBuilder.append('\r');
        }
        return stringBuilder.toString();
    }
}

