/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.admobadapters;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.customevent.CustomEventInterstitial;
import com.google.android.gms.ads.mediation.customevent.CustomEventInterstitialListener;
import com.google.android.gms.common.GoogleApiAvailability;
import com.ironsource.admobadapters.GADIronSourceUtils;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.config.ConfigFile;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.InterstitialListener;
import org.json.JSONObject;

public class GADISIronSourceAdapter
implements CustomEventInterstitial,
InterstitialListener {
    private static final String TAG = GADISIronSourceAdapter.class.getSimpleName();
    private static final int INIT_NOT_STARTED = 0;
    private static final int INIT_PENDING = 1;
    private static final int INIT_SUCCEEDED = 2;
    private static int initState;
    private CustomEventInterstitialListener mInterstitialListener;
    private boolean isTestEnabled;
    private String placementName;

    public void requestInterstitialAd(Context context, CustomEventInterstitialListener customEventInterstitialListener, String string2, MediationAdRequest mediationAdRequest, Bundle bundle) {
        try {
            this.mInterstitialListener = customEventInterstitialListener;
            IronSource.setInterstitialListener((InterstitialListener)this);
            if (context instanceof Activity) {
                JSONObject jSONObject = new JSONObject(string2);
                String string3 = jSONObject.optString("applicationKey");
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    string3 = jSONObject.optString("appKey");
                }
                this.isTestEnabled = jSONObject.optBoolean("isTestEnabled", false);
                this.placementName = jSONObject.optString("placementName", "");
                this.onLog("Server params: " + string2);
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    this.initISIronSourceSDK((Activity)context, string3);
                    this.loadISIronSourceSDK();
                } else {
                    this.onLog("You forget to add applicationKey param in the admob parameter.");
                    this.onAdFailedToLoad(1);
                }
            } else {
                this.onLog("Context not an Activity. Returning error!");
                this.onAdFailedToLoad(1);
            }
        }
        catch (Exception exception) {
            this.onLog(exception.getMessage());
            this.onAdFailedToLoad(2);
        }
    }

    public void showInterstitial() {
        this.onLog("showInterstitial");
        try {
            if (TextUtils.isEmpty((CharSequence)this.placementName)) {
                IronSource.showInterstitial();
            } else {
                IronSource.showInterstitial((String)this.placementName);
            }
        }
        catch (Exception exception) {
            this.onLog(exception.toString());
        }
    }

    private void initISIronSourceSDK(Activity activity, String string2) {
        if (initState == 0) {
            initState = 1;
            ConfigFile.getConfigFile().setPluginData("AdMob", "2.5.0", String.valueOf(GoogleApiAvailability.GOOGLE_PLAY_SERVICES_VERSION_CODE));
            IronSource.init((Activity)activity, (String)string2, (IronSource.AD_UNIT[])new IronSource.AD_UNIT[]{IronSource.AD_UNIT.INTERSTITIAL, IronSource.AD_UNIT.REWARDED_VIDEO});
            initState = 2;
        }
    }

    private void loadISIronSourceSDK() {
        this.onLog("loadInterstitial");
        if (IronSource.isInterstitialReady()) {
            this.onInterstitialAdReady();
        } else {
            IronSource.loadInterstitial();
        }
    }

    public void onDestroy() {
    }

    public void onPause() {
    }

    public void onResume() {
    }

    private void onLog(String string2) {
        if (this.isTestEnabled) {
            GADIronSourceUtils.onLog(TAG, string2);
        }
    }

    public void onInterstitialAdReady() {
        if (this.mInterstitialListener != null) {
            this.sendEventOnUIThread(new Runnable(){

                @Override
                public void run() {
                    GADISIronSourceAdapter.this.onLog("onAdLoaded");
                    GADISIronSourceAdapter.this.mInterstitialListener.onAdLoaded();
                }
            });
        }
    }

    public void onInterstitialAdLoadFailed(IronSourceError ironSourceError) {
        this.onAdFailedToLoad(0);
    }

    public void onInterstitialAdOpened() {
        if (this.mInterstitialListener != null) {
            this.sendEventOnUIThread(new Runnable(){

                @Override
                public void run() {
                    GADISIronSourceAdapter.this.onLog("onAdOpened");
                    GADISIronSourceAdapter.this.mInterstitialListener.onAdOpened();
                }
            });
        }
    }

    public void onInterstitialAdClosed() {
        if (this.mInterstitialListener != null) {
            this.sendEventOnUIThread(new Runnable(){

                @Override
                public void run() {
                    GADISIronSourceAdapter.this.onLog("onAdClosed");
                    GADISIronSourceAdapter.this.mInterstitialListener.onAdClosed();
                }
            });
        }
    }

    public void onInterstitialAdShowSucceeded() {
    }

    public void onInterstitialAdShowFailed(IronSourceError ironSourceError) {
        this.onLog("onInterstitialAdShowFailed: " + ironSourceError.getErrorMessage());
    }

    public void onInterstitialAdClicked() {
        if (this.mInterstitialListener != null) {
            this.sendEventOnUIThread(new Runnable(){

                @Override
                public void run() {
                    GADISIronSourceAdapter.this.onLog("onAdClicked");
                    GADISIronSourceAdapter.this.mInterstitialListener.onAdClicked();
                    GADISIronSourceAdapter.this.onLog("onAdLeftApplication");
                    GADISIronSourceAdapter.this.mInterstitialListener.onAdLeftApplication();
                }
            });
        }
    }

    private void sendEventOnUIThread(Runnable runnable) {
        GADIronSourceUtils.sendEventOnUIThread(runnable);
    }

    private void onAdFailedToLoad(final int n2) {
        if (this.mInterstitialListener != null) {
            this.sendEventOnUIThread(new Runnable(){

                @Override
                public void run() {
                    GADISIronSourceAdapter.this.onLog("onAdFailedToLoad:" + n2);
                    GADISIronSourceAdapter.this.mInterstitialListener.onAdFailedToLoad(n2);
                }
            });
        }
    }
}

