package com.yodo1ads.adapter.video;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.os.Handler;
import android.text.TextUtils;

import com.uniplay.adsdk.VideoAd;
import com.uniplay.adsdk.VideoAdListener;
import com.yodo1ads.plugin.uniplay.AdConfigUniplay;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.advert.video.Yodo1VideoReloadCallback;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;


/**
 * Created by yodo1 on 2016/11/21.
 */

public class AdvertAdapteruniplay extends AdVideoAdapterBase {
    private Yodo1VideoCallback callback;
    private Yodo1VideoReloadCallback reloadCallback;
    private VideoAdListener videoAdListener = new VideoAdListener(){

        @Override
        public void onVideoAdReady() {
            YLog.d("Uniplay  onVideoAdReady");
            if(reloadCallback!=null){
                reloadCallback.onReload(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onVideoAdStart() {
            if(callback != null){
                callback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onVideoAdProgress(int i, int i1) {

        }

        @Override
        public void onVideoAdFailed(String s) {
            YLog.i("Uniplay,   onVideoAdFailed. : " + s);
            if(reloadCallback!=null){
                reloadCallback.onReload(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FAILED, getAdvertCode());
            }
        }

        @Override
        public void onVideoAdComplete() {
            if(callback != null){
                callback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onVideoAdClose() {
            if(callback != null){
                callback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }
    };
    @Override
    public void showVideoAdvert(Activity activity,final Yodo1VideoCallback callback) {
        YLog.i("Uniplay,   showVideoAdvert...");
        this.callback = callback;

        if (TextUtils.isEmpty( AdConfigUniplay.VIDEO_ID)){
            callback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", AdConfigUniplay.CHANNEL_CODE);
            YLog.e("Uniplay VideoId  null");
            return;
        }

        if (VideoAd.getInstance().isVideoReady()) {
            VideoAd.getInstance().playVideoAd();
        } else {
            callback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", AdConfigUniplay.CHANNEL_CODE);
        }
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1VideoReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;
        YLog.i("Uniplay,   reloadVideoAdvert...");
        if (TextUtils.isEmpty( AdConfigUniplay.VIDEO_ID)){

            YLog.e("Uniplay VideoId  null");
            return;
        }

        VideoAd.getInstance().loadVideoAd();

    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return VideoAd.getInstance().isVideoReady();
    }

    @Override
    public String getAdvertCode() {
        return AdConfigUniplay.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(final Activity activity) {
        AdConfigUniplay.VIDEO_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd,
                AdConfigUniplay.CHANNEL_CODE, AdConfigUniplay.KEY_Uniplay_VIDEO_ID);

        if (TextUtils.isEmpty( AdConfigUniplay.VIDEO_ID)){

            YLog.e("Uniplay VideoId  null");
            return;
        }
        VideoAd.getInstance().init(activity, AdConfigUniplay.VIDEO_ID, videoAdListener);

    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {

    }

    @Override
    public void onPause(Activity activity) {

    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {

    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
