package com.yodo1ads.adapter.video;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.ksc.ad.sdk.IKsyunAdInitResultListener;
import com.ksc.ad.sdk.IKsyunAdListener;
import com.ksc.ad.sdk.IKsyunAdLoadListener;
import com.ksc.ad.sdk.IKsyunRewardVideoAdListener;
import com.ksc.ad.sdk.KsyunAdSdk;
import com.ksc.ad.sdk.KsyunAdSdkConfig;
import com.ksc.ad.sdk.util.KsyunSdkConstants;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1ads.plugin.jinshanyun.AdConfigJinshanyun;
import com.yodo1ads.plugin.jinshanyun.AdvertCoreJinshanyun;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.advert.video.Yodo1VideoReloadCallback;
import com.yodo1.sdk.kit.YLog;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by yodo1 on 17/9/21.
 */
public class AdvertAdapterjinshanyun extends AdVideoAdapterBase {

    private Yodo1VideoCallback videoCallback; //视频回调
    private Yodo1VideoReloadCallback reloadCallback;
    private List<String> adslot_id = new ArrayList<>();
    private boolean isLoaded;
    private boolean initSuccess = false;
    @Override
    public void showVideoAdvert(Activity activity, Yodo1VideoCallback callback) {
        this.videoCallback = callback;
        if(TextUtils.isEmpty(AdConfigJinshanyun.APP_ID) ){
            YLog.i("Ksy appid is null");
            callback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "APP_ID null", getAdvertCode());
            return;
        }
        YLog.i("Ksy showVideoAdvert");

        for (int i = 0 ;i < adslot_id.size() ;i++){
            boolean isExist = KsyunAdSdk.getInstance().hasAd(adslot_id.get(i));
            YLog.i("Ksy showVideoAdvert   hasLocalAd = " +isExist);
            if (isExist) {
                YLog.i("Ksy showVideoAdvert   adslot_id = " + adslot_id.get(i));
                KsyunAdSdk.getInstance().showAd(activity, adslot_id.get(i));

                break;
            } else {
                if (i == adslot_id.size() -1){
                    callback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
                }
            }
        }
        if (adslot_id.size() == 0){
            callback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
        isLoaded = false;
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1VideoReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;
        if (TextUtils.isEmpty( AdConfigJinshanyun.APP_ID) ){
            YLog.e("Ksy  APP_ID  is null");
            return ;
        }

        if (initSuccess){
            KsyunAdSdk.getInstance().loadAd(new IKsyunAdLoadListener() {
                @Override
                public void onAdInfoSuccess() {

                }

                @Override
                public void onAdInfoFailed(int i, String s) {

                }

                @Override
                public void onAdLoaded(String s) {
                    isLoaded = true;
                }
            });
        } else {
            YLog.i("Ksy  尚未初始化成功");
        }

    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return isLoaded;
    }
    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreJinshanyun.getInstance().validateAdsAdapter(activity);
    }
    @Override
    public String getAdvertCode() {
        return AdConfigJinshanyun.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(final Activity activity) {
        AdConfigJinshanyun.SLOT_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigJinshanyun.CHANNEL_CODE
                , AdConfigJinshanyun.KEY_JSY_SLOT_ID);
        AdConfigJinshanyun.APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigJinshanyun.CHANNEL_CODE
                , AdConfigJinshanyun.KEY_JSY_APP_ID);

        if (TextUtils.isEmpty( AdConfigJinshanyun.APP_ID) ){
            YLog.e("Ksy  APP_ID  is null");
            return ;
        }

        KsyunAdSdkConfig config = new KsyunAdSdkConfig();
        YLog.d("Ksy   APP_ID ： " + AdConfigJinshanyun.APP_ID);
        config.setSdkEnvironment(KsyunAdSdkConfig.RELEASE_ENV);
        config.setShowCloseBtnOfRewardVideo(false);
        config.setCloseBtnComingTimeOfRewardVideo(5);
        config.setEnabeSdkRequestPermission(false);
        KsyunAdSdk.getInstance().init(activity, AdConfigJinshanyun.APP_ID, "Yodo1", config, new
                IKsyunAdInitResultListener() {
                    @Override
                    public void onSuccess(final Map<String, String> map) {
                        YLog.d("Ksy   初始化成功");
                        initSuccess = true;
                        KsyunAdSdk.getInstance().setAdListener(dListener);
                        KsyunAdSdk.getInstance().setRewardVideoAdListener(videoAdListener);
                        String result = map.get(KsyunSdkConstants.KEY_INIT_RESULT_AD_SLOTS);
                        if (!TextUtils.isEmpty(result)) {
                            YLog.d("Ksy   广告位获取成功 " + result);
                            try {
                                JSONArray array = new JSONArray(result);
                                for (int i = 0 ;i < array.length() ;i ++){
                                    JSONObject object = array.optJSONObject(i);
                                    String id = object.optString("adslot_id");
                                    adslot_id.add(id);
                                }

                            }catch (JSONException e){
                            }
                        }
                    }

                    @Override
                    public void onFailure(final int errCode, final String errMsg) {
                        YLog.i("Ksy   初始化失败，errCode：" + errCode + "，errMsg：" + errMsg);

                    }
                });


    }



    IKsyunAdListener dListener = new IKsyunAdListener() {
        @Override
        public void onShowSuccess(String adSlotId) {
            if (videoCallback!=null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onShowFailed(String adSlotId, int erroCode, String erroMsg) {
            //播放失败,预加载下一个奖励视频

        }

        @Override
        public void onADComplete(String adSlotId) {
            YLog.i("Ksy onADComplete ： " + adSlotId);
            //播放成功，预加载下一个奖励视频
            if (videoCallback!=null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onADClick(String adSlotId) {
            if (videoCallback!=null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onADClose(String adSlotId) {
            YLog.i("Ksy onADClose ： " + adSlotId);
            if (videoCallback!=null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }
    };

    private IKsyunRewardVideoAdListener videoAdListener = new IKsyunRewardVideoAdListener(){

        @Override
        public void onAdAwardSuccess(String s) {

        }

        @Override
        public void onAdAwardFailed(String s, int i, String s1) {

        }
    };


    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
    }

    @Override
    public void onPause(Activity activity) {
    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {
    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
