package com.yodo1.plugin.dmp.yodo1.utils;


import android.os.Environment;


import com.yodo1.sdk.kit.YLog;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;


/**
 * 读写sd卡
 * Created by yodo1 on 2017/3/22.
 */
public class Yodo1FileUtils {
    public static final String YODO1FILE = ".yodo1";

    // 写入并保存文件内容到SD卡
    public static void writeFilesToSDCard (String content, String fileName) {

        // 判断SD卡是否存在，并且本程序是否拥有SD卡的权限
        if(Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {

            // 获得SD卡的根目录
            File sdCardPath = Environment.getExternalStorageDirectory();
			/*
			* 文件输出操作
			* */
            File testFile = new File(sdCardPath, fileName);
            // 初始化文件输出流
            FileOutputStream fileOutputStream = null;
            // 以追加模式打开文件输出流
            try {
                fileOutputStream = new FileOutputStream(testFile, true);
                fileOutputStream.write(content.getBytes());
                // 关闭文件输出流
                fileOutputStream.close();
                YLog.d("deviceId存入sd卡");
            } catch (FileNotFoundException e) {
                YLog.d("sd卡读取deviceId失败");
            } catch (IOException e) {
                YLog.d("sd卡读取deviceId失败");
            }

        }
    }

    // 从SD卡上读取文件内容
    public static String readFilesFromSDCard (String fileName) {

        // 定义文件内容字符串
        String content = null;
        // 文件输入流
        FileInputStream fileInputStream = null;

        // 判断SD卡是否存在，并且本程序是否拥有SD卡的权限
        if(Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {

            // 获得SD卡的根目录
            File sdCardPath = Environment.getExternalStorageDirectory();
			/*
			* 文件输出操作
			* */
            try {
                File testFile = new File(sdCardPath, fileName);
                // 打开文件输入流
                fileInputStream = new FileInputStream(testFile);
                // 将文件输入流存放在ByteArrayOutputStream
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                // 定义每次读取一个字节
                byte[] buffer = new byte[1024];
                // 定义每次读取的字节长度
                int len = 0;
                // 读取文件输入流的内容，并存入ByteArrayOutputStream中
                while ((len = fileInputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, len);
                    YLog.d("sd卡读取deviceId成功");
                }
                // 将文件输入流数据以字符串的形式存放
                content = outputStream.toString();
                // 关闭文件输入流
                fileInputStream.close();
                // 关闭ByteArrayOutputStream
                outputStream.close();


            } catch (FileNotFoundException e) {
                YLog.d("sd卡读取deviceId失败");
            } catch (IOException e) {
                YLog.d("sd卡读取deviceId失败");
            }

        }

        // 返回文件内容
        return content;
    }
}
