package com.yodo1.plugin.dmp.yodo1.helper;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;

import com.yodo1.android.ops.net.HttpListener;
import com.yodo1.android.ops.net.Yodo1HttpManage;
import com.yodo1.android.ops.net.Yodo1RequestListener;
import com.yodo1.android.ops.net.Yodo1SDKResponse;
import com.yodo1.nohttp.Headers;
import com.yodo1.nohttp.NoHttp;
import com.yodo1.nohttp.RequestMethod;
import com.yodo1.nohttp.rest.Request;
import com.yodo1.nohttp.rest.Response;
import com.yodo1.onlineconfig.Yodo1OnlineConfig;
import com.yodo1.plugin.dmp.yodo1.utils.Yodo1CommonUtil;
import com.yodo1.plugin.dmp.yodo1.utils.Yodo1DeviceUtils;
import com.yodo1.plugin.dmp.yodo1.utils.Yodo1FileSizeUtils;
import com.yodo1.plugin.dmp.yodo1.utils.Yodo1OperatorUtils;
import com.yodo1.plugin.dmp.yodo1.utils.Yodo1PermissonUtils;
import com.yodo1.sdk.kit.MD5EncodeUtil;
import com.yodo1.sdk.kit.SysUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Cache;
import com.yodo1.sdk.kit.Yodo1PropertiesUtils;
import com.yodo1.sdk.kit.Yodo1SharedPreferences;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;


public class Yodo1AnalyticsForYodo1  implements  Yodo1RequestListener{
	private static final String eventUrl = "https://da.yodo1api.com/log/event";
	private static long launchtime ;//启动时间
	private static long uptime ;//数据上报时间戳
	private static  String analytics_version = "8.1.0";//android版本号
	private static  String sdk_version = "1.1.1";//统计SDK的版本号
	private String device_id = "";
	private static Yodo1Cache yodo1Cache;
	private static String CACHE = "Yodo1AnCache";
	private String appKey = "";

	private final long  upDataTime = 1000*5*60;//上报时间  五分钟上报一次数据
	private Activity mainActivity;

	private static Yodo1AnalyticsForYodo1 instance;
	private Yodo1AnalyticsForYodo1() {
	}
	public static Yodo1AnalyticsForYodo1 getInstance() {
		if (instance == null) {
			instance = new Yodo1AnalyticsForYodo1();
		}
		return instance;
	}

	public void initSDK(Activity activity ,String appKey) {
		this.mainActivity = activity;
		this.appKey = appKey;
		if (yodo1Cache == null){
			yodo1Cache = Yodo1Cache.get(activity);
			device_id = Yodo1DeviceUtils.getDeviceId(activity);//设备ID
		}
		sdk_version = Yodo1PropertiesUtils.getInstance().getBasicConfigValueFromAssets(activity, "version.properties", "versionname");
		if (TextUtils.isEmpty(sdk_version)){
			sdk_version = "1.0.0";
		}
		YLog.v("Yodo1 当前SDK版本号为 ： " + sdk_version);
		analytics_version = SysUtils.getVersionName(activity);
		//如果缓存数据大于10M  清除所有缓存
		File f = new File(activity.getCacheDir(), "Yodo1Cache");
		if (Yodo1FileSizeUtils.getFolderSize(f) > 10){
			if (yodo1Cache != null){
				yodo1Cache.clear();
			}
		}

	}

	public void onResume(final Activity activity){
		if (yodo1Cache == null){
			yodo1Cache = Yodo1Cache.get(activity);
			device_id = Yodo1DeviceUtils.getDeviceId(activity);//设备ID
		}
		launchtime = Yodo1CommonUtil.getUTCTime();
	}

	/**
	 * 保存事件信息
	 * @param eventId
	 * @param map
	 */
	public void onEvent(String eventId, HashMap<String, Object> map) {
		String channel_code = "";
		if(this.mainActivity != null){
			channel_code = Yodo1SharedPreferences.getString(this.mainActivity, "ChannelCode");
		}

		if (TextUtils.isEmpty(channel_code)){
			channel_code = Yodo1OnlineConfig.ChannelCode;
		}
		JSONObject eventJson = new JSONObject();
		JSONObject eventdataJson = new JSONObject();
		JSONObject dataJson = new JSONObject();
		try {
			for (Map.Entry<String, Object> entry : map.entrySet()) {
				if(entry.getValue() != null){
					eventdataJson.put(entry.getKey(),entry.getValue());
				}
			}

			eventJson.put("sessionid",Yodo1AnalyticsManage.sessionid);
			eventJson.put("timestamp",Yodo1CommonUtil.getUTCTime());
			eventJson.put("device_id",device_id);
			eventJson.put("eventid", eventId);
			eventJson.put("event_data", eventdataJson);
			eventJson.put("channel", channel_code);
			eventJson.put("client_version", analytics_version);
			dataJson.put("event",eventJson);
			saveDataForLocal(dataJson);
		} catch (JSONException e) {
			e.printStackTrace();
		}
	}

	/**
	 * 保存启动信息
	 * @param context
	 * @param sessionid
	 * @param duration
	 */
	public void saveLaunchEvent(Context context, String sessionid, String lastTimeSessionid, String duration){
		JSONObject dataJson = new JSONObject();
		String channel_code = "";
		if(this.mainActivity != null){
			channel_code = Yodo1SharedPreferences.getString(this.mainActivity, "ChannelCode");
		}

		if (TextUtils.isEmpty(channel_code)){
			channel_code = Yodo1OnlineConfig.ChannelCode;
		}
		JSONObject launchJson = new JSONObject();
		try {
			launchJson.put("sessionid",sessionid);
			launchJson.put("timestamp",launchtime);
			launchJson.put("os","android");
			launchJson.put("device_id",device_id);
			launchJson.put("channel", channel_code);
			launchJson.put("client_version", analytics_version);
			launchJson.put("network", Yodo1OperatorUtils.getNetWorkType(context));
			launchJson.put("os_version", Yodo1DeviceUtils.getOsVersion());
			launchJson.put("phone_version", Yodo1DeviceUtils.getPhoneVersion());
			launchJson.put("device_name", Yodo1DeviceUtils.getPhoneBrand());
			launchJson.put("bundle_id", Yodo1DeviceUtils.getPackagename(context));

			if (Yodo1PermissonUtils.hasPermission(context,Yodo1PermissonUtils.READ_PHONE_STATE)){
				launchJson.put("mc", Yodo1DeviceUtils.getMacAddress(context));
//				launchJson.put("andid", Yodo1DeviceUtils.getAndroidId(context));
				launchJson.put("imsi", Yodo1OperatorUtils.getIMSI(context));
				launchJson.put("imei", Yodo1OperatorUtils.getIMEI(context));
				launchJson.put("tab", Yodo1OperatorUtils.isTablet(context) ? "1" : "0");//0 手机   1 平板
			}
			JSONObject terminalJson = new JSONObject();
			terminalJson.put("sessionid",lastTimeSessionid);
			terminalJson.put("duration",TextUtils.isEmpty(duration)? "0": duration);//一个session内app运行时间
			launchJson.put("terminal",terminalJson);

			dataJson.put("launch",launchJson);
			saveDataForLocal(dataJson);
//			YLog.d("saveLaunchEvent  : " + dataJson.toString());

//			YLog.d("统计上报应用启动数据");
			Update(Yodo1AnalyticsForYodo1.this);//启动时事件上报

		} catch (JSONException e) {
			e.printStackTrace();
		}

	}

	/**
	 * 信息上报
	 * @param listener 回调
	 */
	int i = 0;
	public void Update(final Yodo1RequestListener listener){
		YLog.d("Yodo1AnalyticsForYodo1   Update 调用次数  " + i++);
		if (TextUtils.isEmpty(appKey)){
			YLog.d("Yodo1AnalyticsForYodo1   appKey为空   中止上报");
			return;
		}
		YLog.d("当前时间 ： " + Yodo1CommonUtil.getUTCTime());
		YLog.d("上一次上传时间： " + uptime);
		if (Yodo1CommonUtil.getUTCTime() - uptime <  upDataTime - 3000){// 5min上报一次  减3s，忽略数据缓存时时差
			YLog.d("Yodo1AnalyticsForYodo1   5min上报一次数据");
			return;
		}
		uptime = Yodo1CommonUtil.getUTCTime();//上报时间
		String cache = yodo1Cache.getAESData(CACHE);
		if (TextUtils.isEmpty(cache)){
			YLog.d("Yodo1AnalyticsForYodo1   上报数据为空   中止上报");
			return;
		}
//		String  url =  "http://192.168.1.132:666/log/event";
//		String  url =  "https://da.yodo1api.com/log/event";
//		String	url = Yodo1OPSBuilder.getInstance().getLogEventConfig();
		String timestamp = Yodo1CommonUtil.getUTCTime()+"";//请求时的时间戳
		String sign = MD5EncodeUtil.MD5Encode(appKey+timestamp+"logupload");
		JSONObject updataJson = new JSONObject();
		try {
			JSONArray array = new JSONArray(cache);
			updataJson.put("game_appkey",appKey);
			updataJson.put("timestamp",timestamp);
			updataJson.put("data", array);
			updataJson.put("sdk_version", sdk_version);
			updataJson.put("sign", sign);

		} catch (JSONException e) {
			e.printStackTrace();
		}

		String submitStr = updataJson.toString();

		Request<String> request = NoHttp.createStringRequest(eventUrl, RequestMethod.POST);
//		request.setDefineRequestBody(submitStr, Yodo1Heads.HEAD_VALUE_CONTENT_TYPE_TEXT);
		byte[] payloadData = null;
		try {
			payloadData = Yodo1CommonUtil.gzipCompress(submitStr);
//			YLog.d("Gzip stats. Size: " + submitStr.getBytes("UTF-8").length + ", Compressed: " + payloadData.length);
			request.addHeader("Content-Length", String.valueOf(payloadData.length));
			request.addHeader(Headers.HEAD_KEY_CONTENT_ENCODING, "gzip");
		} catch (IOException e) {
			e.printStackTrace();
		}
		InputStream input = new ByteArrayInputStream(payloadData);
		request.setDefineRequestBody(input, Headers.HEAD_VALUE_CONTENT_TYPE_JSON);
		Yodo1HttpManage.getInstance().connect(0, request, new HttpListener<String>() {
			@Override
			public void onSucceed(int what, Response<String> response) {
				Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(1, response);
				listener.onYodo1RequestComplete(resp);
			}

			@Override
			public void onFailed(int what, Response<String> response) {
				Yodo1SDKResponse resp = Yodo1HttpManage.getInstance().getResponseObject(1, response);
				listener.onYodo1RequestComplete(resp);
			}
		}, false);

	}


	@Override
	public void onYodo1RequestComplete(Yodo1SDKResponse responseObject) {
		String resMsg = responseObject.getResponseString();
		YLog.d("yodo1游戏事件 上报结果： " + resMsg);

		if (!TextUtils.isEmpty(resMsg)){
			try {
				JSONObject jsonObj = new JSONObject(resMsg);
				int errorCode = jsonObj.optInt("error_code");

				if (errorCode == 0){
					YLog.d("yodo1游戏事件 上报成功 ");
					clearData();//上传成功后清除指定数据

				}else {
				}
			} catch (JSONException e) {
				e.printStackTrace();
			}
		} else {
			YLog.d("yodo1游戏事件 上报失败  返回数据为空 ");
		}
	}
	/**
	 * 将事件缓存至本地
	 * 先读取本地后 将新事件添加进去
	 */
	private void saveDataForLocal(JSONObject dataJson){
		if (yodo1Cache == null && mainActivity != null){
			yodo1Cache = Yodo1Cache.get(mainActivity);
		}

		String cache = yodo1Cache.getAESData(CACHE);
		JSONArray array = null;
		if (!TextUtils.isEmpty(cache)){
			try {
				array = new JSONArray(cache);
			}catch (JSONException e){
				array = new JSONArray();
			}
		} else {
			array = new JSONArray();
		}

		array.put(dataJson);
		yodo1Cache.putAESData(CACHE,array.toString());
		YLog.d("yodo1事件数据已成功缓存至本地");
	}

	/**
	 * 清除指定数据
	 */
	private void clearData(){
		yodo1Cache.remove(CACHE);
		YLog.d("上报成功，删除本地缓存事件数据");
	}

}

