/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.publisher.env;

import android.app.KeyguardManager;
import android.app.UiModeManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.location.Location;
import android.location.LocationManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.storage.StorageManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.view.WindowManager;
import android.webkit.WebView;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.gson.JsonObject;
import com.vungle.publisher.env.i;
import com.vungle.publisher.env.j;
import com.vungle.publisher.env.w;
import com.vungle.publisher.inject.Injector;
import com.vungle.publisher.lm;
import com.vungle.publisher.log.Logger;
import com.vungle.publisher.zb;
import com.vungle.publisher.zj;
import com.vungle.publisher.zo;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AndroidDevice
implements i {
    static int a = 5000;
    private final String k = Build.VERSION.RELEASE;
    final AtomicBoolean b = new AtomicBoolean();
    private boolean l;
    String c;
    String d;
    @Inject
    lm e;
    @Inject
    WindowManager f;
    @Inject
    Context g;
    @Inject
    SharedPreferences h;
    @Inject
    DeviceIdStrategy i;
    @Inject
    String j;

    @Inject
    AndroidDevice() {
        Injector.c().a(this);
    }

    @Override
    public String a() {
        this.h();
        return this.c;
    }

    boolean b() {
        return !TextUtils.isEmpty((CharSequence)this.c);
    }

    void a(String string) {
        this.c = string;
        this.c();
        this.g();
    }

    void c() {
        if (this.b() && this.f()) {
            this.e();
        }
    }

    @Override
    public String d() {
        this.h();
        if (this.f() && this.b()) {
            Logger.w("VungleDevice", "have advertising and Android ID");
            this.e();
        }
        return this.d;
    }

    void e() {
        Logger.i("VungleDevice", "clearing Android ID");
        this.d = null;
    }

    boolean f() {
        return !TextUtils.isEmpty((CharSequence)this.d);
    }

    void b(String string) {
        if (this.b()) {
            Logger.w("VungleDevice", "have advertising id - not setting androidId");
        } else {
            Logger.d("VungleDevice", "setting android ID " + string);
            this.d = string;
            this.g();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void g() {
        boolean bl2 = this.b.getAndSet(true);
        if (!bl2) {
            AtomicBoolean atomicBoolean = this.b;
            synchronized (atomicBoolean) {
                this.b.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void h() {
        block11: {
            try {
                if (this.b.get()) break block11;
                long l2 = System.currentTimeMillis() + (long)a;
                AtomicBoolean atomicBoolean = this.b;
                synchronized (atomicBoolean) {
                    Logger.d("VungleDevice", "waiting for device ID");
                    while (!this.b.get() && System.currentTimeMillis() < l2) {
                        try {
                            this.b.wait(a);
                        }
                        catch (InterruptedException interruptedException) {
                            Logger.v("VungleDevice", "interrupted while awaiting device ID");
                        }
                    }
                }
                if (this.b.get()) {
                    Logger.d("VungleDevice", "obtained device ID");
                    break block11;
                }
                throw new j("timeout after " + a + " ms");
            }
            finally {
                if (!this.i()) {
                    Logger.w("VungleDevice", "no device ID available");
                }
            }
        }
    }

    boolean i() {
        return this.b() || this.f();
    }

    @Override
    public boolean j() {
        return this.l;
    }

    void a(boolean bl2) {
        this.l = bl2;
    }

    @Override
    public Float k() {
        Float f2 = null;
        try {
            f2 = Float.valueOf(this.e.b());
        }
        catch (Exception exception) {
            Logger.d("VungleDevice", "error getting volume info", exception);
        }
        return f2;
    }

    @Override
    public boolean l() {
        boolean bl2 = "mounted".equals(Environment.getExternalStorageState());
        boolean bl3 = zj.a(this.g);
        if (bl3 && bl2) {
            Logger.v("VungleDevice", "external storage writable");
        } else {
            Logger.w("VungleDevice", "external storage not writable");
        }
        return bl3 && bl2;
    }

    public boolean m() {
        return this.c("VungleDevice");
    }

    boolean c(String string) {
        boolean bl2 = false;
        try {
            int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)this.g);
            boolean bl3 = bl2 = n2 == 0;
            if (!bl2) {
                Logger.w(string, "Google Play Services not available: " + GooglePlayServicesUtil.getErrorString((int)n2));
            }
        }
        catch (IllegalStateException illegalStateException) {
            Logger.w("VungleConfig", zb.a(illegalStateException));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Logger.d(string, noClassDefFoundError.getClass().getSimpleName() + ": " + noClassDefFoundError.getMessage());
            Logger.v(string, noClassDefFoundError);
        }
        return bl2;
    }

    @Override
    public void n() {
        this.i.d(this);
    }

    @Override
    public String o() {
        return this.h.getString("defaultUserAgent", null);
    }

    @Override
    public void a(WebView webView) {
        String string = zo.a(webView);
        this.h.edit().putString("defaultUserAgent", string).apply();
    }

    @Override
    public boolean a(Context context) {
        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        return keyguardManager.inKeyguardRestrictedInputMode();
    }

    @Override
    public Long p() {
        Long l2 = null;
        try {
            StorageManager storageManager;
            File file = new File(this.j);
            StatFs statFs = new StatFs(file.getPath());
            if (Build.VERSION.SDK_INT >= 26 && (storageManager = (StorageManager)this.g.getSystemService(StorageManager.class)) != null) {
                UUID uUID = storageManager.getUuidForPath(file);
                l2 = storageManager.getCacheQuotaBytes(uUID);
            }
            l2 = Build.VERSION.SDK_INT >= 18 ? Long.valueOf(statFs.getBlockSizeLong() * statFs.getAvailableBlocksLong()) : Long.valueOf(statFs.getBlockSize() * statFs.getAvailableBlocks());
        }
        catch (Exception exception) {
            Logger.e("VungleDevice", "error getting available bytes");
        }
        return l2;
    }

    @Override
    public String q() {
        return Build.FINGERPRINT;
    }

    @Override
    public int r() {
        return Build.VERSION.SDK_INT;
    }

    @Override
    public boolean s() {
        boolean bl2 = false;
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                if (0 == this.g.checkCallingOrSelfPermission("android.permission.REQUEST_INSTALL_PACKAGES")) {
                    bl2 = this.g.getApplicationContext().getPackageManager().canRequestPackageInstalls();
                }
            } else {
                bl2 = Settings.Secure.getInt((ContentResolver)this.g.getContentResolver(), (String)"install_non_market_apps") == 1;
            }
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            Logger.e("VungleDevice", "isInstallNonMarketAppsEnabled Settings not found", settingNotFoundException);
        }
        Logger.v("VungleDevice", "isInstallNonMarketAppsEnabled: " + bl2);
        return bl2;
    }

    @Override
    public boolean t() {
        boolean bl2;
        if (w.a) {
            String string = "amazon.hardware.fire_tv";
            bl2 = this.g.getApplicationContext().getPackageManager().hasSystemFeature("amazon.hardware.fire_tv");
        } else if (Build.VERSION.SDK_INT >= 23) {
            UiModeManager uiModeManager = (UiModeManager)this.g.getSystemService("uimode");
            bl2 = uiModeManager.getCurrentModeType() == 4;
        } else {
            String string = "com.google.android.tv";
            String string2 = "android.hardware.touchscreen";
            bl2 = this.g.getApplicationContext().getPackageManager().hasSystemFeature("com.google.android.tv") || !this.g.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.touchscreen");
        }
        Logger.v("VungleDevice", "isTV: " + bl2);
        return bl2;
    }

    @Override
    public JsonObject u() {
        Location location = null;
        JsonObject jsonObject = null;
        if (w.a) {
            LocationManager locationManager = (LocationManager)this.g.getSystemService("location");
            for (String string : locationManager.getProviders(true)) {
                Location location2 = locationManager.getLastKnownLocation(string);
                if (location2 == null || location != null && !(location2.getAccuracy() < location.getAccuracy())) continue;
                location = location2;
            }
        } else {
            try {
                int n2 = this.g.getPackageManager().getPackageInfo((String)"com.google.android.gms", (int)0).versionCode;
                if (n2 < 11011000) {
                    Logger.w("VungleDevice", "Play services version less than 11.0.11 !");
                }
                try {
                    FusedLocationProviderClient fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient((Context)this.g);
                    Task task = fusedLocationProviderClient.getLastLocation();
                    try {
                        location = (Location)Tasks.await((Task)task, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException exception) {
                        Logger.w("VungleDevice", exception.getCause());
                    }
                }
                catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
                    Logger.w("VungleDevice", "Location Play services FusedLocationProviderClient classes not present, cant get Loc data");
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Logger.w("VungleDevice", "Play services not present, No Loc data !");
            }
        }
        if (location != null) {
            jsonObject = new JsonObject();
            jsonObject.addProperty("accuracy", String.valueOf(location.getAccuracy()));
            jsonObject.addProperty("latitude", String.valueOf(location.getLatitude()));
            jsonObject.addProperty("longitude", String.valueOf(location.getLongitude()));
            jsonObject.addProperty("speed", String.valueOf(location.getSpeed()));
            jsonObject.addProperty("timestamp", (Number)location.getTime());
        }
        return jsonObject;
    }

    public static abstract class DeviceIdStrategy {
        protected abstract void d(AndroidDevice var1);
    }
}

