package com.yodo1ads.adapter.interstitial;

import android.app.Activity;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.TextUtils;

import com.ironsource.mediationsdk.IronSource;

import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.InterstitialListener;
import com.yodo1.advert.interstitial.AdInterstitialAdapterBase;
import com.yodo1.advert.interstitial.Yodo1InterstitialCallback;
import com.yodo1.advert.interstitial.Yodo1InterstitialReloadCallback;
import com.yodo1ads.plugin.supersonic.AdConfigSupersonic;
import com.yodo1ads.plugin.supersonic.AdvertCoreSupersonic;
import com.yodo1.sdk.kit.YLog;

public class AdvertAdaptersupersonic extends AdInterstitialAdapterBase{
    private Yodo1InterstitialCallback intersititalCallback; //插屏回调
    private Yodo1InterstitialReloadCallback callback;
    private boolean setListener = false;
    InterstitialListener listener = new InterstitialListener() {
        @Override
        public void onInterstitialAdReady() {
            if(callback != null){
                callback.onResult(Yodo1InterstitialReloadCallback.ADVERT_INTERSTITIAL_RELOAD_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdLoadFailed(IronSourceError ironSourceError) {
            if(callback != null){
                callback.onResult(Yodo1InterstitialReloadCallback.ADVERT_INTERSTITIAL_RELOAD_FAILED, getAdvertCode());
            }
            YLog.d("Supersonic onInterstitialAdLoadFailed  = " + ironSourceError.getErrorCode() + "   msg = " + ironSourceError.getErrorMessage());
        }

        @Override
        public void onInterstitialAdOpened() {

        }

        @Override
        public void onInterstitialAdClosed() {
            if(intersititalCallback != null){
                intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdShowSucceeded() {
            if(intersititalCallback != null){
                intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdShowFailed(IronSourceError ironSourceError) {
            YLog.i("Supersonic onInterstitialAdShowFailed  = " + ironSourceError.getErrorCode());
            if(intersititalCallback != null){
                intersititalCallback.onAdError(Yodo1InterstitialCallback.ADVERT_EVENT_DISPLAY_FAILED, "onInterstitialAdShowFailed",getAdvertCode());
            }
        }

        @Override
        public void onInterstitialAdClicked() {
            if(intersititalCallback != null){
                intersititalCallback.onEvent(Yodo1InterstitialCallback.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }


    };
    @Override
    public String getAdvertCode() {
        return AdConfigSupersonic.CHANNEL_CODE;
    }


    @Override
    public void showIntersititalAdvert(Activity activity, Yodo1InterstitialCallback callback) {
        this.intersititalCallback = callback;

        if (TextUtils.isEmpty(AdConfigSupersonic.SUPERSONIC_ID)){
            YLog.e("Supersonic  APPID  is null");
            intersititalCallback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
            return ;
        }
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (IronSource.isInterstitialReady()) {
                    //show the interstitial
                    IronSource.showInterstitial();
                }else {
                    if(intersititalCallback != null){
                        intersititalCallback.onAdError(Yodo1InterstitialCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
                    }
                }

            }
        });

    }

    @Override
    public void reloadInterstitialAdvert(Activity activity, Yodo1InterstitialReloadCallback callback) {
        this.callback = callback;
        if (TextUtils.isEmpty(AdConfigSupersonic.SUPERSONIC_ID)){
            YLog.e("Supersonic  APPID  is null");
            return ;
        }
        if (AdvertCoreSupersonic.initSuccess && !setListener){

            if (!setListener){
                setListener = true;
                IronSource.setInterstitialListener(listener);
            }
            IronSource.loadInterstitial();
        }

    }

    @Override
    public boolean interstitialAdvertIsLoaded(Activity activity) {
        return IronSource.isInterstitialReady();
    }

    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(Activity activity) {

        AdvertCoreSupersonic.getInstance().startIronSourceInitTask(activity);

    }

    @Override
    public void onStart(Activity activity) {
    }

    @Override
    public void onResume(Activity activity) {
        AdvertCoreSupersonic.getInstance().onResume(activity);
    }

    @Override
    public void onPause(Activity activity) {
        AdvertCoreSupersonic.getInstance().onPause(activity);


    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {
    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }

}
