package com.yodo1.advert.callback;


import com.yodo1.advert.entity.AdErrorCode;

public interface BannerCallback {

	/**
	 * Called after an Banner has been dismissed.
	 */
	public void onBannerClosed();

	/**
	 * Called after an Banner has been displayed on the screen.
	 *
	 */
	public void onBannerShow();

	/**
	 * Called after an Banner has attempted to show but failed.
	 * @param errorCode The reason for the error
	 */
	public void onBannerShowFailed(AdErrorCode errorCode);

	/**
	 * Called after an Banner has been clicked.
	 */
	public void onBannerClicked();

	
}
