/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.facebook;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdListener;
import com.facebook.ads.RewardData;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdListener;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.EBannerSize;
import com.ironsource.mediationsdk.IntegrationData;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class FacebookAdapter
extends AbstractAdapter {
    private static final String VERSION = "4.2.0";
    private static final String CORE_SDK_VERSION = "4.28.1";
    private static final String MEDIATION_SERVICE_NAME = "Supersonic";
    private ConcurrentHashMap<String, InterstitialAd> mInterstitialPlacementToAdMap;
    private ConcurrentHashMap<String, RewardedVideoAd> mRewardedVideoPlacementToAdMap;
    private ConcurrentHashMap<String, AdView> mBannerPlacementToAdMap;
    private InterstitialAdListener mInterstitialAdListener;
    private RewardedVideoAdListener mRewardedVideoAdListener;
    private final String PLACEMENT_ID = "placementId";
    private Activity mActivity;

    public static FacebookAdapter startAdapter(String string) {
        return new FacebookAdapter(string);
    }

    public static IntegrationData getIntegrationData(Activity activity) {
        IntegrationData integrationData = new IntegrationData("Facebook", VERSION);
        integrationData.activities = new String[]{"com.facebook.ads.AudienceNetworkActivity"};
        return integrationData;
    }

    private FacebookAdapter(String string) {
        super(string);
        this.mAllBannerSmashes = new CopyOnWriteArrayList();
        this.mRewardedVideoPlacementToAdMap = new ConcurrentHashMap();
        this.mInterstitialPlacementToAdMap = new ConcurrentHashMap();
        this.mBannerPlacementToAdMap = new ConcurrentHashMap();
        this.mInterstitialAdListener = new InterstitialAdListener(){

            public void onInterstitialDisplayed(Ad ad2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onInterstitialDisplayed", 1);
                if (FacebookAdapter.this.mInterstitialPlacementToListenerMap.get(ad2.getPlacementId()) != null) {
                    ((InterstitialSmashListener)FacebookAdapter.this.mInterstitialPlacementToListenerMap.get(ad2.getPlacementId())).onInterstitialAdOpened();
                }
            }

            public void onInterstitialDismissed(Ad ad2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onInterstitialDismissed", 1);
                if (FacebookAdapter.this.mInterstitialPlacementToListenerMap.get(ad2.getPlacementId()) != null) {
                    ((InterstitialSmashListener)FacebookAdapter.this.mInterstitialPlacementToListenerMap.get(ad2.getPlacementId())).onInterstitialAdClosed();
                }
            }

            public void onError(Ad ad2, AdError adError) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "IS Ad, onError; error: " + adError.getErrorMessage(), 1);
                if (FacebookAdapter.this.mInterstitialPlacementToListenerMap.get(ad2.getPlacementId()) != null) {
                    ((InterstitialSmashListener)FacebookAdapter.this.mInterstitialPlacementToListenerMap.get(ad2.getPlacementId())).onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)adError.getErrorMessage()));
                }
            }

            public void onAdLoaded(Ad ad2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "IS Ad, onAdLoaded", 1);
                if (FacebookAdapter.this.mInterstitialPlacementToListenerMap.get(ad2.getPlacementId()) != null) {
                    ((InterstitialSmashListener)FacebookAdapter.this.mInterstitialPlacementToListenerMap.get(ad2.getPlacementId())).onInterstitialAdReady();
                }
            }

            public void onAdClicked(Ad ad2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "IS Ad, onAdClicked", 1);
                if (FacebookAdapter.this.mInterstitialPlacementToListenerMap.get(ad2.getPlacementId()) != null) {
                    ((InterstitialSmashListener)FacebookAdapter.this.mInterstitialPlacementToListenerMap.get(ad2.getPlacementId())).onInterstitialAdClicked();
                }
            }

            public void onLoggingImpression(Ad ad2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "IS Ad, onLoggingImpression", 1);
                if (FacebookAdapter.this.mInterstitialPlacementToListenerMap.get(ad2.getPlacementId()) != null) {
                    ((InterstitialSmashListener)FacebookAdapter.this.mInterstitialPlacementToListenerMap.get(ad2.getPlacementId())).onInterstitialAdShowSucceeded();
                }
            }
        };
        this.mRewardedVideoAdListener = new RewardedVideoAdListener(){

            public void onRewardedVideoCompleted() {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onRewardedVideoCompleted", 1);
                if (FacebookAdapter.this.mActiveRewardedVideoSmash != null) {
                    FacebookAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdEnded();
                    FacebookAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdRewarded();
                }
            }

            public void onLoggingImpression(Ad ad2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "RV Ad, onLoggingImpression", 1);
                if (FacebookAdapter.this.mActiveRewardedVideoSmash != null) {
                    FacebookAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdOpened();
                    FacebookAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdStarted();
                }
            }

            public void onRewardedVideoClosed() {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onRewardedVideoClosed", 1);
                if (FacebookAdapter.this.mActiveRewardedVideoSmash != null) {
                    FacebookAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdClosed();
                }
            }

            public void onError(Ad ad2, AdError adError) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "RV Ad, onError; error: " + adError.getErrorMessage(), 1);
                if (FacebookAdapter.this.mRewardedVideoPlacementToListenerMap.get(ad2.getPlacementId()) != null) {
                    ((RewardedVideoSmashListener)FacebookAdapter.this.mRewardedVideoPlacementToListenerMap.get(ad2.getPlacementId())).onRewardedVideoAvailabilityChanged(false);
                }
            }

            public void onAdLoaded(Ad ad2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "RV Ad, onAdLoaded", 1);
                if (FacebookAdapter.this.mRewardedVideoPlacementToListenerMap.get(ad2.getPlacementId()) != null) {
                    ((RewardedVideoSmashListener)FacebookAdapter.this.mRewardedVideoPlacementToListenerMap.get(ad2.getPlacementId())).onRewardedVideoAvailabilityChanged(true);
                }
            }

            public void onAdClicked(Ad ad2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "RV Ad, onAdClicked", 1);
                if (FacebookAdapter.this.mRewardedVideoPlacementToListenerMap.get(ad2.getPlacementId()) != null) {
                    ((RewardedVideoSmashListener)FacebookAdapter.this.mRewardedVideoPlacementToListenerMap.get(ad2.getPlacementId())).onRewardedVideoAdClicked();
                }
            }
        };
        AdSettings.setMediationService((String)MEDIATION_SERVICE_NAME);
    }

    public String getVersion() {
        return VERSION;
    }

    public String getCoreSDKVersion() {
        return CORE_SDK_VERSION;
    }

    public void initRewardedVideo(Activity activity, String string, String string2, JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        if (TextUtils.isEmpty((CharSequence)jSONObject.optString("placementId"))) {
            if (rewardedVideoSmashListener != null) {
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
            return;
        }
        this.mActivity = activity;
        if (!TextUtils.isEmpty((CharSequence)jSONObject.optString("placementId")) && rewardedVideoSmashListener != null) {
            this.mRewardedVideoPlacementToListenerMap.put(jSONObject.optString("placementId"), rewardedVideoSmashListener);
        }
        this.loadRewardedVideo(jSONObject.optString("placementId"));
    }

    public void fetchRewardedVideo(JSONObject jSONObject) {
        this.loadRewardedVideo(jSONObject.optString("placementId"));
    }

    public boolean isRewardedVideoAvailable(JSONObject jSONObject) {
        return this.mRewardedVideoPlacementToAdMap.get(jSONObject.optString("placementId")) != null && this.mRewardedVideoPlacementToAdMap.get(jSONObject.optString("placementId")).isAdLoaded();
    }

    public void showRewardedVideo(final JSONObject jSONObject, final RewardedVideoSmashListener rewardedVideoSmashListener) {
        this.mActiveRewardedVideoSmash = rewardedVideoSmashListener;
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                block7: {
                    try {
                        RewardedVideoAd rewardedVideoAd = (RewardedVideoAd)FacebookAdapter.this.mRewardedVideoPlacementToAdMap.get(jSONObject.optString("placementId"));
                        if (rewardedVideoAd != null && rewardedVideoAd.isAdLoaded()) {
                            if (!TextUtils.isEmpty((CharSequence)FacebookAdapter.this.getDynamicUserId())) {
                                rewardedVideoAd.setRewardData(new RewardData(FacebookAdapter.this.getDynamicUserId(), "1"));
                            }
                            rewardedVideoAd.show();
                        } else if (rewardedVideoSmashListener != null) {
                            rewardedVideoSmashListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
                        }
                        if (rewardedVideoSmashListener != null) {
                            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
                        }
                    }
                    catch (Exception exception) {
                        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Facebook show failed - " + exception.getMessage(), 3);
                        if (rewardedVideoSmashListener == null) break block7;
                        rewardedVideoSmashListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
                        rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
                    }
                }
            }
        });
    }

    public void onResume(Activity activity) {
        this.mActivity = activity;
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + ":onResume()", 1);
    }

    public void onPause(Activity activity) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + ":onPause()", 1);
    }

    public void initInterstitial(Activity activity, String string, String string2, JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        if (TextUtils.isEmpty((CharSequence)jSONObject.optString("placementId"))) {
            if (interstitialSmashListener != null) {
                interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params", (String)"Interstitial"));
            }
            return;
        }
        this.mActivity = activity;
        if (!TextUtils.isEmpty((CharSequence)jSONObject.optString("placementId")) && interstitialSmashListener != null) {
            this.mInterstitialPlacementToListenerMap.put(jSONObject.optString("placementId"), interstitialSmashListener);
            interstitialSmashListener.onInterstitialInitSuccess();
        }
    }

    public void loadInterstitial(final JSONObject jSONObject, final InterstitialSmashListener interstitialSmashListener) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        if (!TextUtils.isEmpty((CharSequence)jSONObject.optString("placementId"))) {
                            InterstitialAd interstitialAd = new InterstitialAd((Context)FacebookAdapter.this.mActivity, jSONObject.optString("placementId"));
                            interstitialAd.setAdListener(FacebookAdapter.this.mInterstitialAdListener);
                            interstitialAd.loadAd();
                            FacebookAdapter.this.mInterstitialPlacementToAdMap.put(jSONObject.optString("placementId"), interstitialAd);
                        } else {
                            interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)"invalid placement"));
                        }
                    }
                    catch (Exception exception) {
                        if (interstitialSmashListener == null) break block4;
                        interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)exception.getLocalizedMessage()));
                    }
                }
            }
        });
    }

    public void showInterstitial(final JSONObject jSONObject, final InterstitialSmashListener interstitialSmashListener) {
        this.mActiveInterstitialSmash = interstitialSmashListener;
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        if (FacebookAdapter.this.mInterstitialPlacementToAdMap.get(jSONObject.optString("placementId")) != null && ((InterstitialAd)FacebookAdapter.this.mInterstitialPlacementToAdMap.get(jSONObject.optString("placementId"))).isAdLoaded()) {
                            ((InterstitialAd)FacebookAdapter.this.mInterstitialPlacementToAdMap.get(jSONObject.optString("placementId"))).show();
                        } else if (interstitialSmashListener != null) {
                            interstitialSmashListener.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
                        }
                    }
                    catch (Exception exception) {
                        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Facebook show failed - " + exception.getMessage(), 3);
                        if (interstitialSmashListener == null) break block5;
                        interstitialSmashListener.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
                    }
                }
            }
        });
    }

    public boolean isInterstitialReady(JSONObject jSONObject) {
        return this.mInterstitialPlacementToAdMap.get(jSONObject.optString("placementId")) != null && this.mInterstitialPlacementToAdMap.get(jSONObject.optString("placementId")).isAdLoaded();
    }

    public void initBanners(Activity activity, String string, String string2, JSONObject jSONObject, BannerSmashListener bannerSmashListener) {
        this.mActivity = activity;
        if (bannerSmashListener != null) {
            bannerSmashListener.onBannerInitSuccess();
        }
    }

    private AdView createBanner(Activity activity, EBannerSize eBannerSize, JSONObject jSONObject, BannerSmashListener bannerSmashListener) {
        AdSize adSize = AdSize.BANNER_HEIGHT_50;
        switch (eBannerSize) {
            case BANNER: {
                adSize = AdSize.BANNER_HEIGHT_50;
                break;
            }
            case LARGE: {
                adSize = AdSize.BANNER_HEIGHT_90;
                break;
            }
            case RECTANGLE: {
                adSize = AdSize.RECTANGLE_HEIGHT_250;
                break;
            }
            case TABLET: {
                adSize = AdSize.BANNER_HEIGHT_90;
                break;
            }
            case SMART: {
                adSize = this.isLargeScreen(activity) ? AdSize.BANNER_HEIGHT_90 : AdSize.BANNER_HEIGHT_50;
            }
        }
        String string = jSONObject.optString("placementId");
        AdView adView = new AdView((Context)activity, string, adSize);
        this.mBannerPlacementToAdMap.put(string, adView);
        adView.setAdListener(new AdListener(){

            public void onError(Ad ad2, AdError adError) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Banner Ad, onError; error: " + adError.getErrorMessage(), 1);
                if (FacebookAdapter.this.mBannerPlacementToListenerMap.containsKey(ad2.getPlacementId())) {
                    IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)adError.getErrorMessage());
                    ((BannerSmashListener)FacebookAdapter.this.mBannerPlacementToListenerMap.get(ad2.getPlacementId())).onBannerAdLoadFailed(ironSourceError);
                }
            }

            public void onAdLoaded(Ad ad2) {
                if (FacebookAdapter.this.mBannerPlacementToListenerMap.containsKey(ad2.getPlacementId())) {
                    IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Banner Ad, onAdLoaded", 1);
                    if (FacebookAdapter.this.mBannerPlacementToAdMap.get(ad2.getPlacementId()) != null) {
                        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
                        ((BannerSmashListener)FacebookAdapter.this.mBannerPlacementToListenerMap.get(ad2.getPlacementId())).onBannerAdLoaded((View)FacebookAdapter.this.mBannerPlacementToAdMap.get(ad2.getPlacementId()), layoutParams, null);
                    }
                }
            }

            public void onAdClicked(Ad ad2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Banner Ad, onAdClicked", 1);
                if (FacebookAdapter.this.mBannerPlacementToListenerMap.containsKey(ad2.getPlacementId())) {
                    ((BannerSmashListener)FacebookAdapter.this.mBannerPlacementToListenerMap.get(ad2.getPlacementId())).onBannerAdClicked();
                }
            }

            public void onLoggingImpression(Ad ad2) {
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "Banner Ad, onLoggingImpression", 1);
                if (FacebookAdapter.this.mBannerPlacementToListenerMap.containsKey(ad2.getPlacementId())) {
                    ((BannerSmashListener)FacebookAdapter.this.mBannerPlacementToListenerMap.get(ad2.getPlacementId())).onBannerAdScreenPresented();
                }
            }
        });
        if (bannerSmashListener != null) {
            this.mBannerPlacementToListenerMap.put(string, bannerSmashListener);
        }
        return adView;
    }

    public void loadBanner(final IronSourceBannerLayout ironSourceBannerLayout, final JSONObject jSONObject, final BannerSmashListener bannerSmashListener) {
        if (TextUtils.isEmpty((CharSequence)jSONObject.optString("placementId"))) {
            String string = "Banner, " + this.getProviderName() + " - " + "No placement id in the response";
            IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)string);
            if (bannerSmashListener != null) {
                bannerSmashListener.onBannerAdLoadFailed(ironSourceError);
            }
            return;
        }
        if (ironSourceBannerLayout != null) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            AdView adView = FacebookAdapter.this.createBanner(ironSourceBannerLayout.getActivity(), ironSourceBannerLayout.getSize(), jSONObject, bannerSmashListener);
                            adView.loadAd();
                        }
                        catch (Exception exception) {
                            String string = "Banner Load Fail, " + FacebookAdapter.this.getProviderName() + " - " + "failed to retrieve Facebook AdView from banner layout";
                            IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)string);
                            if (bannerSmashListener == null) break block2;
                            bannerSmashListener.onBannerAdLoadFailed(ironSourceError);
                        }
                    }
                }
            });
        }
    }

    public void destroyBanner(final JSONObject jSONObject) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (FacebookAdapter.this.mBannerPlacementToAdMap.get(jSONObject.optString("placementId")) != null) {
                        ((AdView)FacebookAdapter.this.mBannerPlacementToAdMap.get(jSONObject.optString("placementId"))).destroy();
                        FacebookAdapter.this.mBannerPlacementToAdMap.remove(jSONObject.optString("placementId"));
                    }
                }
                catch (Exception exception) {
                    FacebookAdapter.this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, FacebookAdapter.this.getProviderName() + ":destroyBanner() failed with an exception: " + exception, 2);
                }
            }
        });
    }

    public void reloadBanner(final JSONObject jSONObject) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (FacebookAdapter.this.mBannerPlacementToAdMap.get(jSONObject.optString("placementId")) != null) {
                    ((AdView)FacebookAdapter.this.mBannerPlacementToAdMap.get(jSONObject.optString("placementId"))).loadAd();
                }
            }
        });
    }

    private void loadRewardedVideo(final String string) {
        if (this.mActivity != null) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        try {
                            if (!TextUtils.isEmpty((CharSequence)string)) {
                                RewardedVideoAd rewardedVideoAd = new RewardedVideoAd((Context)FacebookAdapter.this.mActivity, string);
                                rewardedVideoAd.setAdListener(FacebookAdapter.this.mRewardedVideoAdListener);
                                rewardedVideoAd.loadAd();
                                FacebookAdapter.this.mRewardedVideoPlacementToAdMap.put(string, rewardedVideoAd);
                            }
                        }
                        catch (Exception exception) {
                            if (FacebookAdapter.this.mRewardedVideoPlacementToListenerMap.get(string) == null) break block3;
                            ((RewardedVideoSmashListener)FacebookAdapter.this.mRewardedVideoPlacementToListenerMap.get(string)).onRewardedVideoAvailabilityChanged(false);
                        }
                    }
                }
            });
        }
    }
}

