package com.yodo1ads.adapter.banner;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.MobileAds;
import com.yodo1.advert.banner.AdBannerAdapterBase;
import com.yodo1.advert.banner.Yodo1BannerAlign;
import com.yodo1.advert.banner.Yodo1BannerCallback;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1ads.plugin.admob.AdConfigAdMob;
import com.yodo1ads.plugin.admob.AdvertCoreAdMob;
import com.yodo1.sdk.kit.YLog;

import static com.google.android.gms.ads.AdSize.BANNER;


public class AdvertAdapteradmob extends AdBannerAdapterBase {
    public static final String KEY_AdMob_BANNER_ID = "ad_admob_banner_unitId";
    public static final String KEY_AdMob_APPID = "ad_admob_banner_appId";
    public static String APPID = "";
    public static String UnitId = "";
    private Activity activity;
    private boolean isLoaded = false;
    private AdRequest adRequest;
    private AdView mAdView;
    private int align = Yodo1BannerAlign.BannerAlignHorizontalCenter | Yodo1BannerAlign.BannerAlignBottom;
    private Yodo1BannerCallback callback;
    private boolean showTag = false;
    private AdListener adListener = new AdListener() {
        @Override
        public void onAdLoaded() {
            isLoaded = true;
            // Code to be executed when an ad finishes loading.
            YLog.d( "Admob onAdLoaded");


        }

        @Override
        public void onAdFailedToLoad(int errorCode) {
            // Code to be executed when an ad request fails.
            YLog.i( "Admob onAdFailedToLoad");
            if (showTag && callback != null){
                showTag = false;

            }
        }

        @Override
        public void onAdOpened() {
            // Code to be executed when an ad opens an overlay that
            // covers the screen.
            YLog.d( "Admob onAdOpened");

        }

        @Override
        public void onAdLeftApplication() {
            // Code to be executed when the user has left the app.
            if (callback != null){
                callback.onEvent(Yodo1BannerCallback.ADVERT_EVENT_CLICK, getAdvertCode());
            }
        }

        @Override
        public void onAdClosed() {
            // Code to be executed when when the user is about to return
            // to the app after tapping on an ad.
            if (callback != null){
                callback.onEvent(Yodo1BannerCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }
    };


    /* 显示banner广告
      * @param activity
      * @param callback
      */
    @Override
    public  void showBanner(Activity activity, Yodo1BannerCallback callback){
        this.callback = callback;

        if (TextUtils.isEmpty(APPID) || TextUtils.isEmpty(UnitId)){
            YLog.e("AdMob  UnitId  is null");
            callback.onAdError(Yodo1BannerCallback.ADVERT_ERROR_COMMON, "showBannerFailed",getAdvertCode());
            return;
        }


        showTag = true;



        if (isLoaded){
            YLog.d("AdMob showBanner ");
            Yodo1BannerAlign.setYodo1BannerLayout(activity,mAdView,align);
            callback.onEvent(Yodo1BannerCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
        } else {
            YLog.d("AdMob showBanner  error");
            callback.onAdError(Yodo1BannerCallback.ADVERT_ERROR_COMMON, "onAdFailedToLoad",getAdvertCode());

        }

    };

    /**
     * banner广告删除
     * @param activity
     */
    @Override
    public  void removeBanner(Activity activity){
        showTag = false;
        isLoaded = false;
        YLog.d("AdMob removeBanner ");

        if (mAdView != null) {
            mAdView.destroy();
            mAdView = null;
        }
    };

    /**
     * 隐藏
     * @param activity
     */
    @Override
    public  void hideBanner(Activity activity){
        showTag = false;

        YLog.d("AdMob hideBanner ");
        if (mAdView != null) {
            Yodo1BannerAlign.removeYodo1BannerLayout(activity,mAdView);
        }
    }


    /**
     * 设置banner展示位置
     * @param activity
     * @param align  banner展示位置
     */
    @Override
    public void setBannerAlign(Activity activity, int align) {
        this.align = align;
        YLog.d("AdMob setBannerAlign");

        initBanner(activity);
    }

    @Override
    public boolean hasLoadBanner() {
        return isLoaded;
    }


    @Override
    public String getAdvertCode() {
        return AdConfigAdMob.CHANNEL_CODE;
    }


    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreAdMob.getInstance().validateAdsAdapter(activity);
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {
        this.activity = activity;
        APPID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, AdConfigAdMob.CHANNEL_CODE
                , KEY_AdMob_APPID);

        UnitId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_BannerAd, AdConfigAdMob.CHANNEL_CODE
                , KEY_AdMob_BANNER_ID);


        if (TextUtils.isEmpty(APPID) || TextUtils.isEmpty(UnitId)){
            YLog.e("AdMob  Appid  is null");
            return;
        }
        //此处读取key
        MobileAds.initialize(activity.getApplicationContext(),
                APPID);

        adRequest = new AdRequest.Builder().build();

        initBanner(activity);
    }

    private void initBanner(Activity activity){
        if (TextUtils.isEmpty(UnitId)){
            YLog.e("AdMob  UnitId  is null");
            return;
        }

        if (mAdView == null){
            mAdView = new AdView(activity);
            mAdView.setAdUnitId(UnitId);
            mAdView.setAdSize(BANNER);
            mAdView.setAdListener(adListener);
            mAdView.loadAd(adRequest);
        }
    }
    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
        if (mAdView != null) {
            mAdView.resume();
        }
    }

    @Override
    public void onPause(Activity activity) {
        if (mAdView != null) {
            mAdView.pause();
        }
    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {
        if (mAdView != null) {
            mAdView.destroy();
        }
    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }


}
