package com.yodo1.sdk.kit;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by zhuxiaochen on 2017/12/26.
 */

public class ValidateUtils {


    public static boolean validateActivities(Activity activity, List<String> activities)
    {
        boolean result = true;

        PackageManager packageManager = activity.getPackageManager();
        for (String act : activities) {
            try
            {
                Class localClass = Class.forName(act);
                Intent intent = new Intent(activity, localClass);

                List<ResolveInfo> list = packageManager.queryIntentActivities(intent, PackageManager.MATCH_DEFAULT_ONLY);
                if (list.size() > 0)
                {
                    validationMessageIsPresent(act, true);
                }
                else
                {
                    result = false;
                    validationMessageIsPresent(act, false);
                }
            }
            catch (ClassNotFoundException e)
            {
                result = false;
                validationMessageIsPresent(act, false);
            }
        }
        return result;
    }

    public static boolean validatePermissions(Activity activity, List<String> permissions)
    {
        boolean result = true;

        PackageManager packageManager = activity.getPackageManager();
        for (String permission : permissions) {
            int permissionExists = packageManager.checkPermission(permission, activity.getPackageName());
            if (permissionExists == 0)
            {
                validationMessageIsPresent(permission, true);
            }
            else
            {
                result = false;
                validationMessageIsPresent(permission, false);
            }
        }
        return result;
    }

    public static boolean validateExternalLibraries(ArrayList<Pair<String, String>> externalLibraries)
    {
        boolean result = true;

        for (Pair<String, String> externalLibrary : externalLibraries) {
            try
            {
                Class localClass = Class.forName((String)externalLibrary.first);

                validationMessageIsPresent((String)externalLibrary.second, true);
            }
            catch (ClassNotFoundException e)
            {
                result = false;
                validationMessageIsPresent((String)externalLibrary.second, false);
            }
        }
        return result;
    }

    public static boolean validateBroadcastReceivers(Activity activity, List<String> broadcastReceivers)
    {
        boolean result = true;

        PackageManager packageManager = activity.getPackageManager();
        for (String broadcastReceiver : broadcastReceivers) {
            try
            {
                Class localClass = Class.forName(broadcastReceiver);
                Intent intent = new Intent(activity, localClass);

                List<ResolveInfo> list = packageManager.queryBroadcastReceivers(intent, PackageManager.MATCH_DEFAULT_ONLY);
                if (list.size() > 0)
                {
                    validationMessageIsPresent(broadcastReceiver, true);
                }
                else
                {
                    result = false;
                    validationMessageIsPresent(broadcastReceiver, false);
                }
            }
            catch (ClassNotFoundException e)
            {
                result = false;
                validationMessageIsPresent(broadcastReceiver, false);
            }
        }
        return result;
    }

    @SuppressLint("NewApi")
    public static boolean validateContentProviders(Activity activity, List<String> providers)
    {

        if (Build.VERSION.SDK_INT < 19){
            Log.e("Yodo1IntegrationHelper", providers.toString() + "   Android版本过低  无法校验ContentProvider");
            return false;
        }
        boolean result = true;

        PackageManager packageManager = activity.getPackageManager();
        for (String provider : providers) {
            try
            {
                Class localClass = Class.forName(provider);
                Intent intent = new Intent(activity, localClass);

                List<ResolveInfo> list = packageManager.queryIntentContentProviders(intent, PackageManager.MATCH_DEFAULT_ONLY);
                if (list.size() > 0)
                {
                    validationMessageIsPresent(provider, true);
                }
                else
                {
                    result = false;
                    validationMessageIsPresent(provider, false);
                }
            }
            catch (ClassNotFoundException e)
            {
                result = false;
                validationMessageIsPresent(provider, false);
            }
        }
        return result;
    }

    public static boolean validateServices(Activity activity, List<String> services)
    {
        boolean result = true;

        PackageManager packageManager = activity.getPackageManager();
        for (String service : services) {
            try
            {
                Class localClass = Class.forName(service);
                Intent intent = new Intent(activity, localClass);

                List<ResolveInfo> list = packageManager.queryIntentServices(intent, PackageManager.MATCH_DEFAULT_ONLY);
                if (list.size() > 0)
                {
                    validationMessageIsPresent(service, true);
                }
                else
                {
                    result = false;
                    validationMessageIsPresent(service, false);
                }
            }
            catch (ClassNotFoundException e)
            {
                result = false;
                validationMessageIsPresent(service, false);
            }
        }
        return result;
    }


    public static boolean validateMetaData(Activity activity, List<String> metaData)
    {
        boolean result = true;
        ApplicationInfo appInfo = null;
        try {
            appInfo = activity.getPackageManager()
                    .getApplicationInfo(activity.getPackageName(),
                            PackageManager.GET_META_DATA);

            for (String meta : metaData) {
                String data = appInfo.metaData.get(meta).toString();
                if (!TextUtils.isEmpty(data)){
                    result = true;
                    validationMessageIsPresent(meta, true);
                } else {
                    result = false;
                    validationMessageIsPresent(meta, false);
                }
            }

        } catch (Exception e) {
            result = false;
        }

        return result;
    }

    /**
     * 返回AndroidManifest.xml中注册的所有Activity的class
     * @param context                环境
     * @param activityName  包名
     */
    public final static void getActivitiesClass(Context context, String activityName){

        List<Class> returnClassList = new ArrayList<Class>();
        try {
            //Get all activity classes in the AndroidManifest.xml
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), PackageManager.GET_ACTIVITIES);
            if(packageInfo.activities!=null){
                for(ActivityInfo ai: packageInfo.activities){
                    if (ai.name.equals(activityName)){
                        validationMessageIsPresent(activityName, true);

                        return;
                    }
                }

            }
            validationMessageIsPresent(activityName, false);

        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

    }

    /**
     * 返回AndroidManifest.xml中注册的所有Service的class
     * @param context                环境
     * @param serviceName            包名
     */
    public final static void getServiceClass(Context context, String serviceName){

        try {
            //Get all activity classes in the AndroidManifest.xml
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), PackageManager.GET_SERVICES);
            if(packageInfo.services!=null){
                for(ServiceInfo ai: packageInfo.services){
                    if (ai.name.equals(serviceName)){
                        validationMessageIsPresent(serviceName, true);
                        return;
                    }
                }

            }
            validationMessageIsPresent(serviceName, false);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

    }


    /**
     * 返回AndroidManifest.xml中注册的所有receiver的class
     * @param context                环境
     * @param receiverName  包名
     */
    public final static void getReceiverClass(Context context, String receiverName){

        List<Class> returnClassList = new ArrayList<Class>();
        try {
            //Get all activity classes in the AndroidManifest.xml
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), PackageManager.GET_RECEIVERS);
            if(packageInfo.receivers!=null){
                for(ActivityInfo ai: packageInfo.receivers){
                    if (ai.name.equals(receiverName)){
                        validationMessageIsPresent(receiverName, true);

                        return;
                    }
                }

            }
            validationMessageIsPresent(receiverName, false);

        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

    }



    private static void validationMessageIsPresent(String paramToValidate, boolean successful)
    {
        if (successful) {
            Log.i("Yodo1IntegrationHelper",paramToValidate + " - VERIFIED");
        } else {
            Log.e("Yodo1IntegrationHelper", paramToValidate + " - MISSING");
        }
    }



}
