package com.yodo1.android.ops.net;

import android.text.TextUtils;

import org.json.JSONObject;


/**
 * Package the result of network request
 * @author talaya
 *
 */
public class Yodo1SDKResponse {
	private int requestType;
	private boolean isSuccess;
	private JSONObject response;
	private String rawData;
	private int errorCode; 
	private String message;

	public Yodo1SDKResponse(int requestType, boolean isSuccess){
		this.requestType = requestType;
		this.isSuccess = isSuccess;
		this.errorCode = 0;
	}
	public Yodo1SDKResponse(int requestType, boolean isSuccess, int errorCode){
		this.requestType = requestType;
		this.isSuccess = isSuccess;
		this.errorCode = errorCode;
	}
	
	/**
	 * Network reuquest type that indentifies whitch network request the current response for
	 * @return
	 */
	public int getRequestType() {
		return requestType;
	}
	/**
	 * Whether current network request successful
	 * @return
	 */
	public boolean isSuccess() {
		return isSuccess;
	}
	
	/**
	 * Set response type success.
	 * @param isSuccess
	 */
	public void setSuccess(boolean isSuccess) {
		this.isSuccess = isSuccess;
	}

	/**
	 * When the value of isSuccess() is false it means request failed. You can get the detail by errorCode.
	 * @return
	 */
	public int getErrorCode() {
		return errorCode;
	}
	
	/**
	 * Set errorCode for Yodo1SDKResponse objcet.
	 * @param errorCode
	 */
	public void setErrorCode(int errorCode) {
		this.errorCode = errorCode;
	}
	
	/**
	 * The data that the network responses. It is a JSONObject object
	 * @return
	 */
	public JSONObject getResponse() {
		return response;
	}
	
	/**
	 * Set json format data for Yodo1SDKResponse objcet.
	 * @param jsonData
	 */
	public void setResponse(JSONObject jsonData) {
		this.response = jsonData;
	}
	
	/**
	 * Get raw byte array that the network responses.
	 * @return
	 */
	public String getRawData() {
		return rawData;
	}
	
	public String getResponseString(){
		if (TextUtils.isEmpty(rawData)){
			return  null;
		}
		
		return rawData;
	}
	/**
	 * Set raw byte array data for Yodo1SDKResponse objcet.
	 * @param rawData
	 */
	public void setRawData(String rawData) {
		this.rawData = rawData;
	}
	/**
	 * Get string format data that the network responses.
	 */
	public String getMessage() {
		return message;
	}
	/**
	 * Set string format for Yodo1SDKResponse objcet.
	 */
	public void setMessage(String message) {
		this.message = message;
	}
}
