package com.yodo1.advert.callback;


import com.yodo1.advert.entity.AdErrorCode;

public interface InterstitialCallback {

	/**
	 * Called after an interstitial has been dismissed.
	 *
	 */
	public void onInterstitialClosed();

	/**
	 * Called after an interstitial has been displayed on the screen.
	 *
	 */
	public void onInterstitialShowSucceeded();

	/**
	 * Called after an interstitial has attempted to show but failed.
	 * @param errorCode The reason for the error
	 */
	public void onInterstitialShowFailed(AdErrorCode errorCode);

	/**
	 * Called after an interstitial has been clicked.
	 */
	public void onInterstitialClicked();

	
}
