/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.tapjoy;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.IntegrationData;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.tapjoy.TJActionRequest;
import com.tapjoy.TJConnectListener;
import com.tapjoy.TJError;
import com.tapjoy.TJPlacement;
import com.tapjoy.TJPlacementListener;
import com.tapjoy.TJPlacementVideoListener;
import com.tapjoy.Tapjoy;
import com.tapjoy.TapjoyLog;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

public class TapjoyAdapter
extends AbstractAdapter
implements TJPlacementListener,
TJPlacementVideoListener {
    private static final String VERSION = "4.1.0";
    private static final String CORE_SDK_VERSION = "11.11.0";
    private EInitState mInitState = EInitState.NOT_INIT;
    private Set<String> mInitiatedAdUnits;
    private ConcurrentHashMap<String, TJPlacement> mInterstitialPlacementToAdMap;
    private ConcurrentHashMap<String, TJPlacement> mRewardedVideoPlacementToAdMap = new ConcurrentHashMap();
    private final String SDK_KEY = "sdkKey";
    private final String PLACEMENT_NAME = "placementName";

    public static TapjoyAdapter startAdapter(String string) {
        return new TapjoyAdapter(string);
    }

    private TapjoyAdapter(String string) {
        super(string);
        this.mInterstitialPlacementToAdMap = new ConcurrentHashMap();
    }

    public static IntegrationData getIntegrationData(Activity activity) {
        IntegrationData integrationData = new IntegrationData("Tapjoy", VERSION);
        integrationData.activities = new String[]{"com.tapjoy.TJAdUnitActivity", "com.tapjoy.mraid.view.ActionHandler", "com.tapjoy.mraid.view.Browser", "com.tapjoy.TJContentActivity"};
        return integrationData;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getCoreSDKVersion() {
        return CORE_SDK_VERSION;
    }

    private void initSDK(final Activity activity, final String string, JSONObject jSONObject) {
        this.setInitState(EInitState.INIT_IN_PROGRESS);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        boolean bl2 = false;
        try {
            bl2 = this.isAdaptersDebugEnabled();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (bl2) {
            hashtable.put("TJC_OPTION_ENABLE_LOGGING", "true");
            Tapjoy.setDebugEnabled((boolean)true);
            TapjoyLog.setDebugEnabled((boolean)true);
        } else {
            hashtable.put("TJC_OPTION_ENABLE_LOGGING", "false");
            Tapjoy.setDebugEnabled((boolean)false);
            TapjoyLog.setDebugEnabled((boolean)false);
        }
        Tapjoy.connect((Context)activity.getApplicationContext(), (String)jSONObject.optString("sdkKey"), hashtable, (TJConnectListener)new TJConnectListener(){

            public void onConnectSuccess() {
                TapjoyAdapter.this.setInitState(EInitState.INIT_SUCCESS);
                Tapjoy.setUserID((String)string);
                if (TapjoyAdapter.this.mInitiatedAdUnits != null) {
                    TJPlacement tJPlacement;
                    if (TapjoyAdapter.this.mInitiatedAdUnits.contains("Rewarded Video")) {
                        for (Map.Entry entry : TapjoyAdapter.this.mRewardedVideoPlacementToListenerMap.entrySet()) {
                            if (!Tapjoy.isConnected()) {
                                if (entry.getValue() == null) continue;
                                ((RewardedVideoSmashListener)entry.getValue()).onRewardedVideoAvailabilityChanged(false);
                                continue;
                            }
                            tJPlacement = new TJPlacement((Context)activity, (String)entry.getKey(), (TJPlacementListener)TapjoyAdapter.this);
                            tJPlacement.setMediationName("supersonic");
                            tJPlacement.setAdapterVersion(TapjoyAdapter.VERSION);
                            tJPlacement.setVideoListener((TJPlacementVideoListener)TapjoyAdapter.this);
                            if (!TextUtils.isEmpty((CharSequence)((CharSequence)entry.getKey()))) {
                                TapjoyAdapter.this.mRewardedVideoPlacementToAdMap.put(entry.getKey(), tJPlacement);
                            }
                            tJPlacement.requestContent();
                        }
                    }
                    if (TapjoyAdapter.this.mInitiatedAdUnits.contains("Interstitial")) {
                        for (Map.Entry entry : TapjoyAdapter.this.mInterstitialPlacementToListenerMap.entrySet()) {
                            if (!Tapjoy.isConnected()) {
                                if (entry.getValue() == null) continue;
                                ((InterstitialSmashListener)entry.getValue()).onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Not Connected", (String)"Interstitial"));
                                continue;
                            }
                            tJPlacement = new TJPlacement((Context)activity, (String)entry.getKey(), (TJPlacementListener)TapjoyAdapter.this);
                            tJPlacement.setMediationName("supersonic");
                            tJPlacement.setAdapterVersion(TapjoyAdapter.VERSION);
                            if (!TextUtils.isEmpty((CharSequence)((CharSequence)entry.getKey()))) {
                                TapjoyAdapter.this.mInterstitialPlacementToAdMap.put(entry.getKey(), tJPlacement);
                            }
                            if (entry.getValue() == null) continue;
                            ((InterstitialSmashListener)entry.getValue()).onInterstitialInitSuccess();
                        }
                    }
                }
            }

            public void onConnectFailure() {
                if (TapjoyAdapter.this.mInitiatedAdUnits != null) {
                    if (TapjoyAdapter.this.mInitiatedAdUnits.contains("Rewarded Video")) {
                        for (Map.Entry entry : TapjoyAdapter.this.mRewardedVideoPlacementToListenerMap.entrySet()) {
                            if (entry.getValue() == null) continue;
                            ((RewardedVideoSmashListener)entry.getValue()).onRewardedVideoAvailabilityChanged(false);
                        }
                    }
                    if (TapjoyAdapter.this.mInitiatedAdUnits.contains("Interstitial")) {
                        for (Map.Entry entry : TapjoyAdapter.this.mInterstitialPlacementToListenerMap.entrySet()) {
                            if (entry.getValue() == null) continue;
                            ((InterstitialSmashListener)entry.getValue()).onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Not Connected", (String)"Interstitial"));
                        }
                    }
                }
            }
        });
    }

    private synchronized void setInitState(EInitState eInitState) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + ":init state changed from " + (Object)((Object)this.mInitState) + " to " + (Object)((Object)eInitState) + ")", 1);
        this.mInitState = eInitState;
    }

    private synchronized EInitState getCurrentInitState() {
        return this.mInitState;
    }

    private void addInitiatedAdUnit(String string) {
        if (this.mInitiatedAdUnits == null) {
            this.mInitiatedAdUnits = new HashSet<String>();
        }
        this.mInitiatedAdUnits.add(string);
    }

    public void initRewardedVideo(Activity activity, String string, String string2, JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        if (TextUtils.isEmpty((CharSequence)jSONObject.optString("sdkKey")) || TextUtils.isEmpty((CharSequence)jSONObject.optString("placementName"))) {
            if (rewardedVideoSmashListener != null) {
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)jSONObject.optString("placementName")) && rewardedVideoSmashListener != null) {
            this.mRewardedVideoPlacementToListenerMap.put(jSONObject.optString("placementName"), rewardedVideoSmashListener);
        }
        this.addInitiatedAdUnit("Rewarded Video");
        switch (this.getCurrentInitState()) {
            case NOT_INIT: {
                this.initSDK(activity, string2, jSONObject);
                break;
            }
            case INIT_IN_PROGRESS: {
                break;
            }
            case INIT_SUCCESS: {
                if (!Tapjoy.isConnected()) {
                    if (rewardedVideoSmashListener == null) break;
                    rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
                    break;
                }
                if (TextUtils.isEmpty((CharSequence)jSONObject.optString("placementName"))) break;
                TJPlacement tJPlacement = new TJPlacement((Context)activity, jSONObject.optString("placementName"), (TJPlacementListener)this);
                tJPlacement.setMediationName("supersonic");
                tJPlacement.setAdapterVersion(VERSION);
                tJPlacement.setVideoListener((TJPlacementVideoListener)this);
                this.mRewardedVideoPlacementToAdMap.put(jSONObject.optString("placementName"), tJPlacement);
                tJPlacement.requestContent();
                break;
            }
            case INIT_FAIL: {
                if (rewardedVideoSmashListener == null) break;
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
        }
    }

    public void fetchRewardedVideo(JSONObject jSONObject) {
        if (this.mRewardedVideoPlacementToAdMap.get(jSONObject.optString("placementName")) != null) {
            this.mRewardedVideoPlacementToAdMap.get(jSONObject.optString("placementName")).requestContent();
        }
    }

    public void showRewardedVideo(JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        if (this.mRewardedVideoPlacementToAdMap.get(jSONObject.optString("placementName")) != null && this.mRewardedVideoPlacementToAdMap.get(jSONObject.optString("placementName")).isContentReady()) {
            this.mRewardedVideoPlacementToAdMap.get(jSONObject.optString("placementName")).showContent();
        } else if (rewardedVideoSmashListener != null) {
            rewardedVideoSmashListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
        }
    }

    public boolean isRewardedVideoAvailable(JSONObject jSONObject) {
        return this.mRewardedVideoPlacementToAdMap.get(jSONObject.optString("placementName")) != null && this.mRewardedVideoPlacementToAdMap.get(jSONObject.optString("placementName")).isContentReady();
    }

    public void initInterstitial(Activity activity, String string, String string2, JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        if (TextUtils.isEmpty((CharSequence)jSONObject.optString("sdkKey")) || TextUtils.isEmpty((CharSequence)jSONObject.optString("placementName"))) {
            if (interstitialSmashListener != null) {
                interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params", (String)"Interstitial"));
            }
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)jSONObject.optString("placementName")) && interstitialSmashListener != null) {
            this.mInterstitialPlacementToListenerMap.put(jSONObject.optString("placementName"), interstitialSmashListener);
        }
        this.addInitiatedAdUnit("Interstitial");
        switch (this.getCurrentInitState()) {
            case NOT_INIT: {
                this.initSDK(activity, string2, jSONObject);
                break;
            }
            case INIT_IN_PROGRESS: {
                break;
            }
            case INIT_SUCCESS: {
                if (!Tapjoy.isConnected()) {
                    if (interstitialSmashListener != null) {
                        interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Init Failed", (String)"Interstitial"));
                    }
                } else if (!TextUtils.isEmpty((CharSequence)jSONObject.optString("placementName"))) {
                    TJPlacement tJPlacement = new TJPlacement((Context)activity, jSONObject.optString("placementName"), (TJPlacementListener)this);
                    tJPlacement.setMediationName("supersonic");
                    tJPlacement.setAdapterVersion(VERSION);
                    this.mInterstitialPlacementToAdMap.put(jSONObject.optString("placementName"), tJPlacement);
                    if (interstitialSmashListener != null) {
                        interstitialSmashListener.onInterstitialInitSuccess();
                    }
                }
                if (interstitialSmashListener == null) break;
                interstitialSmashListener.onInterstitialInitSuccess();
                break;
            }
            case INIT_FAIL: {
                if (interstitialSmashListener == null) break;
                interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Init Failed", (String)"Interstitial"));
            }
        }
    }

    public void loadInterstitial(JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        if (this.mInterstitialPlacementToAdMap.get(jSONObject.optString("placementName")) != null) {
            this.mInterstitialPlacementToAdMap.get(jSONObject.optString("placementName")).requestContent();
        } else if (interstitialSmashListener != null) {
            interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)"Load error"));
        }
    }

    public void showInterstitial(JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        if (this.mInterstitialPlacementToAdMap.get(jSONObject.optString("placementName")) != null && this.mInterstitialPlacementToAdMap.get(jSONObject.optString("placementName")).isContentReady()) {
            this.mInterstitialPlacementToAdMap.get(jSONObject.optString("placementName")).showContent();
        } else if (interstitialSmashListener != null) {
            interstitialSmashListener.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
        }
    }

    public boolean isInterstitialReady(JSONObject jSONObject) {
        return this.mInterstitialPlacementToAdMap.get(jSONObject.optString("placementName")) != null && this.mInterstitialPlacementToAdMap.get(jSONObject.optString("placementName")).isContentReady();
    }

    public void onRequestSuccess(TJPlacement tJPlacement) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onRequestSuccess(tjPlacement: " + tJPlacement.getName(), 1);
    }

    public void onRequestFailure(TJPlacement tJPlacement, TJError tJError) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onRequestFailure(tjPlacement: " + tJPlacement.getName() + ", tjError: " + tJError.message + ")", 1);
        if (this.mRewardedVideoPlacementToListenerMap.get(tJPlacement.getName()) != null) {
            ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(tJPlacement.getName())).onRewardedVideoAvailabilityChanged(false);
        }
        if (this.mInterstitialPlacementToListenerMap.get(tJPlacement.getName()) != null) {
            ((InterstitialSmashListener)this.mInterstitialPlacementToListenerMap.get(tJPlacement.getName())).onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)tJError.message));
        }
    }

    public void onContentReady(TJPlacement tJPlacement) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onContentReady(tjPlacement: " + tJPlacement.getName() + ")", 1);
        if (this.mRewardedVideoPlacementToListenerMap.get(tJPlacement.getName()) != null) {
            ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(tJPlacement.getName())).onRewardedVideoAvailabilityChanged(true);
        }
        if (this.mInterstitialPlacementToListenerMap.get(tJPlacement.getName()) != null) {
            ((InterstitialSmashListener)this.mInterstitialPlacementToListenerMap.get(tJPlacement.getName())).onInterstitialAdReady();
        }
    }

    public void onContentShow(TJPlacement tJPlacement) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onContentShow(tjPlacement: " + tJPlacement.getName() + ")", 1);
        if (this.mRewardedVideoPlacementToListenerMap.get(tJPlacement.getName()) != null) {
            ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(tJPlacement.getName())).onRewardedVideoAdOpened();
            ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(tJPlacement.getName())).onRewardedVideoAvailabilityChanged(false);
        }
        if (this.mInterstitialPlacementToListenerMap.get(tJPlacement.getName()) != null) {
            ((InterstitialSmashListener)this.mInterstitialPlacementToListenerMap.get(tJPlacement.getName())).onInterstitialAdOpened();
            ((InterstitialSmashListener)this.mInterstitialPlacementToListenerMap.get(tJPlacement.getName())).onInterstitialAdShowSucceeded();
        }
    }

    public void onContentDismiss(TJPlacement tJPlacement) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onContentDismiss(tjPlacement: " + tJPlacement.getName() + ")", 1);
        if (this.mRewardedVideoPlacementToListenerMap.get(tJPlacement.getName()) != null) {
            ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(tJPlacement.getName())).onRewardedVideoAdClosed();
        }
        if (this.mInterstitialPlacementToListenerMap.get(tJPlacement.getName()) != null) {
            ((InterstitialSmashListener)this.mInterstitialPlacementToListenerMap.get(tJPlacement.getName())).onInterstitialAdClosed();
        }
    }

    public void onPurchaseRequest(TJPlacement tJPlacement, TJActionRequest tJActionRequest, String string) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onPurchaseRequest(tjPlacement: " + tJPlacement.getName(), 1);
    }

    public void onRewardRequest(TJPlacement tJPlacement, TJActionRequest tJActionRequest, String string, int n2) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onRewardRequest(tjPlacement: " + tJPlacement.getName(), 1);
    }

    public void onVideoStart(TJPlacement tJPlacement) {
        this.log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + ":onRewardedVideoAdStarted()", 1);
        if (this.mRewardedVideoPlacementToListenerMap.get(tJPlacement.getName()) != null) {
            ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(tJPlacement.getName())).onRewardedVideoAdStarted();
        }
    }

    public void onVideoError(TJPlacement tJPlacement, String string) {
        this.log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + ":onVideoError(error: " + string + ")", 1);
    }

    public void onVideoComplete(TJPlacement tJPlacement) {
        this.log(IronSourceLogger.IronSourceTag.INTERNAL, this.getProviderName() + ":onVideoComplete()", 1);
        if (this.mRewardedVideoPlacementToListenerMap.get(tJPlacement.getName()) != null) {
            ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(tJPlacement.getName())).onRewardedVideoAdEnded();
            ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(tJPlacement.getName())).onRewardedVideoAdRewarded();
        }
    }

    private static enum EInitState {
        NOT_INIT,
        INIT_IN_PROGRESS,
        INIT_SUCCESS,
        INIT_FAIL;

    }
}

