package com.yodo1ads.plugin.mobvista;

import android.app.Activity;
import android.text.TextUtils;

import com.mobvista.msdk.MobVistaSDK;
import com.mobvista.msdk.out.MobVistaSDKFactory;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.ValidateUtils;
import com.yodo1.sdk.kit.YLog;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Created by yodo1 on 2016/4/21.
 */
public class AdvertCoreMobVista {
    private static AdvertCoreMobVista instance;
    private AdvertCoreMobVista(){}
    public static AdvertCoreMobVista getInstance(){
        if(instance == null){
            instance = new AdvertCoreMobVista();
        }
        return instance;
    }



    private boolean validate = false;
    public  void validateAdsAdapter(Activity activity){
        if(!validate) {
            List<String> mobActivities = Arrays.asList(new String[] { "com.mobvista.msdk.reward.player.MVRewardVideoActivity" });
            ValidateUtils.validateActivities(activity,mobActivities);

            validate = true;
        }

    }

    private boolean isInit = false;

    public  void init(final Activity activity){
        if(!isInit) {
            AdConfigMobvista.APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd,
                    AdConfigMobvista.CHANNEL_CODE, AdConfigMobvista.KEY_MOBVISTA_APP_ID);
            AdConfigMobvista.APP_KEY = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd,
                    AdConfigMobvista.CHANNEL_CODE, AdConfigMobvista.KEY_MOBVISTA_APP_KEY);

            if (TextUtils.isEmpty(AdConfigMobvista.APP_ID) && TextUtils.isEmpty(AdConfigMobvista.APP_KEY)){
                AdConfigMobvista.APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd,
                        AdConfigMobvista.CHANNEL_CODE, AdConfigMobvista.KEY_MOBVISTA_APP_ID);
                AdConfigMobvista.APP_KEY = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd,
                        AdConfigMobvista.CHANNEL_CODE, AdConfigMobvista.KEY_MOBVISTA_APP_KEY);
            }

            if (TextUtils.isEmpty(AdConfigMobvista.APP_ID) && TextUtils.isEmpty(AdConfigMobvista.APP_KEY)){
                YLog.e("Mobvista  key未获取到");
                return;
            }
            YLog.d("Mobvista  appid:  " + AdConfigMobvista.APP_ID);
            // init sdk
            MobVistaSDK sdk = MobVistaSDKFactory.getMobVistaSDK();
            // test appId and appKey

            Map<String, String> map = sdk.getMVConfigurationMap(AdConfigMobvista.APP_ID, AdConfigMobvista.APP_KEY );

            // if you modify applicationId, please add the following attributes,
            // otherwise it will crash
            // map.put(MobVistaConstans.PACKAGE_NAME_MANIFEST, "your AndroidManifest
            // package value");
            sdk.init(map, activity.getApplication());
            isInit = true;
        }

    }

}
