/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.admobadapters;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import com.google.android.gms.common.GoogleApiAvailability;
import com.ironsource.admobadapters.GADIronSourceReward;
import com.ironsource.admobadapters.GADIronSourceUtils;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.config.ConfigFile;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.RewardedVideoListener;
import org.json.JSONException;
import org.json.JSONObject;

public class GADRVIronSourceAdapter
implements MediationRewardedVideoAdAdapter,
RewardedVideoListener {
    private static final String TAG = GADRVIronSourceAdapter.class.getSimpleName();
    private boolean isTestEnabled;
    private String placementName;
    private static boolean mIsInitialized;
    private MediationRewardedVideoAdListener mMediationRewardedVideoAdListener;

    private void initRVIronSourceSDK(Activity activity, String string) {
        if (!this.isInitialized()) {
            ConfigFile.getConfigFile().setPluginData("AdMob", "2.5.0", String.valueOf(GoogleApiAvailability.GOOGLE_PLAY_SERVICES_VERSION_CODE));
            IronSource.init((Activity)activity, (String)string, (IronSource.AD_UNIT[])new IronSource.AD_UNIT[]{IronSource.AD_UNIT.REWARDED_VIDEO, IronSource.AD_UNIT.INTERSTITIAL});
            this.onRewardedVideoInitSuccess();
        }
    }

    public void initialize(Context context, MediationAdRequest mediationAdRequest, String string, MediationRewardedVideoAdListener mediationRewardedVideoAdListener, Bundle bundle, Bundle bundle2) {
        this.onLog("initialize");
        this.mMediationRewardedVideoAdListener = mediationRewardedVideoAdListener;
        IronSource.setRewardedVideoListener((RewardedVideoListener)this);
        if (!(context instanceof Activity)) {
            Log.d((String)TAG, (String)"Sample SDK requires an Activity context to initialize");
            this.mMediationRewardedVideoAdListener.onInitializationFailed((MediationRewardedVideoAdAdapter)this, 1);
            return;
        }
        String string2 = bundle.getString("parameter");
        try {
            JSONObject jSONObject = new JSONObject(string2);
            this.isTestEnabled = jSONObject.optBoolean("isTestEnabled", false);
            this.placementName = jSONObject.optString("placementName", "");
            this.onLog("Server params: " + string2);
            String string3 = jSONObject.optString("applicationKey");
            if (TextUtils.isEmpty((CharSequence)string3)) {
                string3 = jSONObject.optString("appKey");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                this.initRVIronSourceSDK((Activity)context, string3);
            } else {
                this.onLog("onInitializationFailed");
                this.mMediationRewardedVideoAdListener.onInitializationFailed((MediationRewardedVideoAdAdapter)this, 1);
            }
        }
        catch (JSONException jSONException) {
            this.onLog("onInitializationFailed");
            this.mMediationRewardedVideoAdListener.onInitializationFailed((MediationRewardedVideoAdAdapter)this, 1);
        }
    }

    public void loadAd(MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle2) {
        this.onLog("loadAd");
        if (IronSource.isRewardedVideoAvailable()) {
            this.onLog("onAdLoaded");
            this.mMediationRewardedVideoAdListener.onAdLoaded((MediationRewardedVideoAdAdapter)this);
        }
    }

    public void showVideo() {
        this.onLog("showVideo");
        if (TextUtils.isEmpty((CharSequence)this.placementName)) {
            IronSource.showRewardedVideo();
        } else {
            IronSource.showRewardedVideo((String)this.placementName);
        }
    }

    public boolean isInitialized() {
        this.onLog("isInitialized: " + mIsInitialized);
        return mIsInitialized;
    }

    public void onDestroy() {
        this.onLog("onDestroy");
    }

    public void onPause() {
        this.onLog("onPause");
    }

    public void onResume() {
        this.onLog("onResume");
    }

    private void onLog(String string) {
        if (this.isTestEnabled) {
            Log.d((String)TAG, (String)string);
        }
    }

    private void onRewardedVideoInitSuccess() {
        if (this.mMediationRewardedVideoAdListener != null) {
            mIsInitialized = true;
            this.sendEventOnUIThread(new Runnable(){

                @Override
                public void run() {
                    GADRVIronSourceAdapter.this.onLog("onInitializationSucceeded");
                    GADRVIronSourceAdapter.this.mMediationRewardedVideoAdListener.onInitializationSucceeded((MediationRewardedVideoAdAdapter)GADRVIronSourceAdapter.this);
                }
            });
        }
    }

    public void onRewardedVideoAvailabilityChanged(final boolean bl) {
        this.onLog("onRewardedVideoAvailabilityChanged " + bl);
        if (this.mMediationRewardedVideoAdListener != null) {
            this.sendEventOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (bl) {
                        GADRVIronSourceAdapter.this.onLog("onAdLoaded");
                        GADRVIronSourceAdapter.this.mMediationRewardedVideoAdListener.onAdLoaded((MediationRewardedVideoAdAdapter)GADRVIronSourceAdapter.this);
                    } else {
                        GADRVIronSourceAdapter.this.onLog("onAdFailedToLoad");
                        GADRVIronSourceAdapter.this.mMediationRewardedVideoAdListener.onAdFailedToLoad((MediationRewardedVideoAdAdapter)GADRVIronSourceAdapter.this, 3);
                    }
                }
            });
        }
    }

    public void onRewardedVideoAdOpened() {
        if (this.mMediationRewardedVideoAdListener != null) {
            this.sendEventOnUIThread(new Runnable(){

                @Override
                public void run() {
                    GADRVIronSourceAdapter.this.onLog("onAdOpened");
                    GADRVIronSourceAdapter.this.mMediationRewardedVideoAdListener.onAdOpened((MediationRewardedVideoAdAdapter)GADRVIronSourceAdapter.this);
                    GADRVIronSourceAdapter.this.onLog("onVideoStarted");
                    GADRVIronSourceAdapter.this.mMediationRewardedVideoAdListener.onVideoStarted((MediationRewardedVideoAdAdapter)GADRVIronSourceAdapter.this);
                }
            });
        }
    }

    public void onRewardedVideoAdClosed() {
        if (this.mMediationRewardedVideoAdListener != null) {
            this.sendEventOnUIThread(new Runnable(){

                @Override
                public void run() {
                    GADRVIronSourceAdapter.this.onLog("onAdClosed");
                    GADRVIronSourceAdapter.this.mMediationRewardedVideoAdListener.onAdClosed((MediationRewardedVideoAdAdapter)GADRVIronSourceAdapter.this);
                }
            });
        }
    }

    public void onRewardedVideoAdStarted() {
    }

    public void onRewardedVideoAdEnded() {
    }

    private void sendEventOnUIThread(Runnable runnable) {
        GADIronSourceUtils.sendEventOnUIThread(runnable);
    }

    public void onRewardedVideoAdRewarded(final Placement placement) {
        if (placement == null) {
            this.onLog("IronSource Placement Error");
            return;
        }
        final GADIronSourceReward gADIronSourceReward = new GADIronSourceReward(placement);
        if (this.mMediationRewardedVideoAdListener != null) {
            this.sendEventOnUIThread(new Runnable(){

                @Override
                public void run() {
                    GADRVIronSourceAdapter.this.onLog("onRewarded: " + gADIronSourceReward.getType() + " " + gADIronSourceReward.getAmount());
                    GADRVIronSourceAdapter.this.mMediationRewardedVideoAdListener.onRewarded((MediationRewardedVideoAdAdapter)GADRVIronSourceAdapter.this, (RewardItem)new GADIronSourceReward(placement));
                }
            });
        }
    }

    public void onRewardedVideoAdShowFailed(IronSourceError ironSourceError) {
        this.onLog("onRewardedVideoAdShowFailed: " + ironSourceError.getErrorMessage());
    }

    private static int getAdRequestErrorType(IronSourceError ironSourceError) {
        switch (ironSourceError.getErrorCode()) {
            case 501: 
            case 502: 
            case 505: 
            case 506: 
            case 508: 
            case 510: {
                return 0;
            }
            case 509: 
            case 524: {
                return 3;
            }
            case 520: {
                return 2;
            }
        }
        return 0;
    }
}

