package com.yodo1.plugin.dmp.yodo1.helper;

import android.app.Activity;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;

import com.yodo1.plugin.dmp.yodo1.utils.Yodo1CommonUtil;
import com.yodo1.plugin.dmp.yodo1.utils.Yodo1DeviceUtils;
import com.yodo1.plugin.dmp.yodo1.utils.Yodo1FileSizeUtils;
import com.yodo1.sdk.kit.YLog;
import com.yodo1.sdk.kit.Yodo1Cache;

import java.io.File;
import java.util.Timer;
import java.util.TimerTask;

/**
 * Created by yodo1 on 18/5/8.
 */

public class Yodo1AnalyticsManage {

    private boolean isLuanch = false;
    private static long launchtime ;//启动时间
    private static long terminaltime ;//一次APP运行的结束时间
    private static long duration = 0;
    private static boolean newsession = false;
    private static String sessionid = "";
    private static final String SESSIONID = "sessionid";
    private static final String DURATION = "duration";
    private static final String TERMINALTIME = "terminaltime";
    private static Yodo1Cache yodo1Cache;
    private String device_id = "";

    private final long  refashDataTime = 5000;//5s刷新一次数据时间
    private final long  upDataTime = 5000*60;//上报时间  五分钟上报一次数据
    private Activity mainActivity;
    private static Yodo1AnalyticsForYodo1 helper = Yodo1AnalyticsForYodo1.getInstance();
    private static Yodo1AnalyticsForGA gaHelper = Yodo1AnalyticsForGA.getInstance();

    final int WHAT = 5000;
    final int WHAT_REFRESH = 5001;
    final Handler handler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case WHAT:
                    helper.Update(helper);
                    gaHelper.Update(gaHelper);
                    break;
                case WHAT_REFRESH:
                    toBackRefreshDate();//每5s刷新一次数据
                    break;
            }
        }
    };

    private static Yodo1AnalyticsManage instance;

    public static Yodo1AnalyticsManage getInstance() {
        if (instance == null) {
            instance = new Yodo1AnalyticsManage();
        }
        return instance;
    }

    public void initSDK(Activity activity,String appKey) {
        this.mainActivity = activity;
        isLuanch = true;
        if (yodo1Cache == null){
            yodo1Cache = Yodo1Cache.get(activity);
            device_id = Yodo1DeviceUtils.getDeviceId(activity);//设备ID
        }
        //如果缓存数据大于10M  清除所有缓存
        File f = new File(activity.getCacheDir(), "Yodo1Cache");
        if (Yodo1FileSizeUtils.getFolderSize(f) > 10){
            if (yodo1Cache != null){
                yodo1Cache.clear();
            }
        }
        helper.initSDK(activity, appKey);
        gaHelper.initSDK(activity);

    }

    public void onResume(final Activity activity){
        helper.onResume(activity);
        gaHelper.onResume(activity);
        if (yodo1Cache == null){
            yodo1Cache = Yodo1Cache.get(activity);
        }
        launchtime = Yodo1CommonUtil.getUTCTime();
        sessionid = yodo1Cache.getAESData(SESSIONID);
        String t = yodo1Cache.getAESData(TERMINALTIME);
        terminaltime = Yodo1CommonUtil.getLongValues(t);
        String d = yodo1Cache.getAESData(DURATION);
        duration = Yodo1CommonUtil.getLongValues(d);
        final String lastTimeSessionid = sessionid;

        YLog.d("launchdata   onResume: " + (!TextUtils.isEmpty(sessionid) && launchtime - terminaltime > 30000));
        //判断sessionid是否存在
        //如果sessionid不存在，或者应用在后台时间超过30s，生成新的并保存到本地
        if (isLuanch || TextUtils.isEmpty(sessionid) || (!TextUtils.isEmpty(sessionid) && launchtime - terminaltime > 30000)){
            sessionid = device_id +  Yodo1CommonUtil.getUTCTime();
            yodo1Cache.putAESData(SESSIONID,sessionid);//保存sessionid

            final String lastduration = yodo1Cache.getAESData(DURATION);
            yodo1Cache.putAESData(DURATION,"0");
            duration = 0;

            newsession = true;
            YLog.d("launchdata   duration onResume: " + lastduration);
            //保存新建launch事件
            YLog.d("launchdata  sessionid onResume: " + sessionid);

            //启动后延时1s保存launch信息    确保SDK已经初始化完成
            new Handler().postDelayed(new Runnable() {
                @Override
                public void run() {
                    helper.saveLaunchEvent(activity,sessionid,lastTimeSessionid,lastduration);
                }
            },1000);


        }
        startUpdate();//定时5min上报事件信息
        refreshDate();//定时5s刷新本地信息
    }

    public void onPause(Activity activity){
        if (yodo1Cache == null){
            yodo1Cache = Yodo1Cache.get(activity);
        }
        isLuanch = false;
        toBackRefreshDate();
        closeUpdate();//关闭定时器
    }

    public void onDestroy(){
        gaHelper.onDestroy();
    }

    /**
     * 本地缓存数据刷新
     */
    public static void toBackRefreshDate(){
        long currentduration = 0;
        terminaltime = Yodo1CommonUtil.getUTCTime();
        currentduration = terminaltime-launchtime;
        launchtime = terminaltime;
        if (newsession){
            duration = currentduration;
            newsession = false;
        } else {
            duration = duration + currentduration;
        }
        yodo1Cache.putAESData(DURATION,String.valueOf(duration));//保存duration
        yodo1Cache.putAESData(TERMINALTIME,String.valueOf(terminaltime));//保存terminaltime
    }

    private static Timer timer,timer1;
    private static TimerTask task,task1;
    //定时器  调用update方法
    public void startUpdate(){
        task = new TimerTask() {
            @Override
            public void run() {
                Message message = new Message();
                message.what = WHAT;
                handler.sendMessage(message);
            }
        };

        timer = new Timer();
        timer.schedule(task, 5000, upDataTime);
    }


    //定时器 刷新数据
    public void refreshDate(){
        task1 = new TimerTask() {
            @Override
            public void run() {
                Message message = new Message();
                message.what = WHAT_REFRESH;
                handler.sendMessage(message);
            }
        };

        timer1 = new Timer();
        timer1.schedule(task1, 0, refashDataTime);
    }

    //关闭定时器
    public  void closeUpdate(){
        if (timer!=null) {
            timer.cancel();
            timer=null;
        }
        if (task!=null) {
            task.cancel();
            task=null;
        }

        if (timer1!=null) {
            timer1.cancel();
            timer1=null;
        }
        if (task1!=null) {
            task1.cancel();
            task1=null;
        }
    }

}
