package com.yodo1.android.ops.net;

import android.content.Context;
import android.text.TextUtils;

import com.yodo1.sdk.kit.YLog;

public class Yodo1OPSBuilder {
	private static Yodo1OPSBuilder instance;
	private Yodo1OPSBuilder(){}
	public static Yodo1OPSBuilder getInstance(){
		if(instance == null){
			instance = new Yodo1OPSBuilder();
		}
		return instance;
	}
	
	public final static String BUILD_PRODUCTION = "product"; //正式环境
	public final static String BUILD_TEST = "test"; //测试环境

	private static String BUILD_CODE = BUILD_PRODUCTION;
	
	private Context context;
	private String gameAppKey;
	private String gameRegionCode;
	private String gamePublishChannelCode;
	private boolean isInit = false; //是否启用了ops

//	private static final String API_SERVER_URL_PRODUCTION =  "http://172.16.100.158:8088/uc_ap";
	private static final String API_SERVER_URL_PRODUCTION =  "https://uc-ap.yodo1api.com/uc_ap";
	private static String API_SERVER_URL_TEST = "http://172.16.100.48:8083/uc_ap";
	
	private static final String PAYMENT_SERVER_PRODUCT = "https://payment.yodo1api.com/payment";
	private static String PAYMENT_SERVER_TEST = "http://172.16.100.48:8083/payment";

	private static final String GAMESUPPORT_SERVER_PRODUCT = "https://activationcode.yodo1api.com";

	private static final String GAMESUPPORT_SERVER_ONLINECONFIG = "https://olc.yodo1api.com";
	private static final String GAMESUPPORT_SERVER_ONLINECONFIG_CDN = "https://ocd.yodo1api.com/configfiles";
	private static final String GAMESUPPORT_SERVER_PUTEVENT = "https://da.yodo1api.com";

	/** 设置ops服务器为测试或者正式 */
	public void setOPSBuildCode(String buildName,String url){
		BUILD_CODE = buildName;
		API_SERVER_URL_TEST = url + "/uc_ap";
		PAYMENT_SERVER_TEST = url + "/payment";
	}
	
	public boolean isTestServer(){
		if(BUILD_TEST.equals(BUILD_CODE)){
			return true;
		}else{
			return false;
		}
	}
	
	/**
	 * 初始化
	 * @param context
	 * @param gameAppKey ops的appkey
	 * @param gameRegionCode ops的regionCode
	 * @param gamePublishChannelCode 发布渠道
	 */
	public void create(Context context, String gameAppKey, String gameRegionCode, String gamePublishChannelCode){
		this.context = context.getApplicationContext();
		this.gameAppKey = gameAppKey;
		this.gameRegionCode = gameRegionCode;
		this.gamePublishChannelCode = gamePublishChannelCode;
		this.isInit = true;

		YLog.v("[OPS - GameAppKey] : " + gameAppKey);
		YLog.v("[OPS - RegionCode] : " + gameRegionCode);
		YLog.v("[发布渠道] : " + gamePublishChannelCode);
		
	}
	
	// 0 - uc, 1-payment , 2 - activationcode
	private String getServerHost(int type){
		switch (type) {
		case 1:
			return getServerHostForPayment();
		case 2:
			return getServerHostForActivationcode();
		case 3://获取在线参数
			return getServerHostForOnlineConfig();
		case 4://获取在线参数  静态文件
			return getServerHostForCDN();
		case 5://统计事件上报
			return getServerHostForPutEvent();
		default:
			return getServerHostForUserCenter();
		}
	}

	private String getServerHostForOnlineConfig(){
		return GAMESUPPORT_SERVER_ONLINECONFIG;
	}
	private String getServerHostForCDN(){
		return GAMESUPPORT_SERVER_ONLINECONFIG_CDN;
	}
	private String getServerHostForPutEvent(){
		return GAMESUPPORT_SERVER_PUTEVENT;
	}


	private String getServerHostForActivationcode(){
		return GAMESUPPORT_SERVER_PRODUCT;
	}

	private String getServerHostForUserCenter(){
		if(!TextUtils.isEmpty(BUILD_CODE)){
			if(BUILD_TEST.equals(BUILD_CODE)){
				return API_SERVER_URL_TEST;
			}else{
				return API_SERVER_URL_PRODUCTION;
			}
		}else{
			return API_SERVER_URL_PRODUCTION;
		}
	}
	
	private String getServerHostForPayment(){
		if(!TextUtils.isEmpty(BUILD_CODE)){
			if(BUILD_TEST.equals(BUILD_CODE)){
				return PAYMENT_SERVER_TEST;
			}else{
				return PAYMENT_SERVER_PRODUCT;
			}
		}else{
			return PAYMENT_SERVER_PRODUCT;
		}
	}
	
	public Context getApplicationContext(){
		return context;
	}
	
	public String getGameAppKey() {
		return gameAppKey;
	}

	public void setGameAppKey(String gameAppKey) {
		this.gameAppKey = gameAppKey;
	}

	public String getGameRegionCode() {
		return gameRegionCode;
	}

	public void setGameRegionCode(String gameRegionCode) {
		this.gameRegionCode = gameRegionCode;
	}

	public String getGamePublishChannelCode() {
		return gamePublishChannelCode;
	}

	public boolean isInit() {
		return isInit;
	}
	public void setGamePublishChannelCode(String gamePublishChannelCode) {
		this.gamePublishChannelCode = gamePublishChannelCode;
	}

	/*************  UserCenter  *************/
	public String getDeviceUidReplace(){
		return getServerHost(0) + "/channel/device/uidReplace";
	}
	public String getDeviceUidTransfer(){
		return getServerHost(0) + "/channel/device/uidTransfer";
	}
	
	public String getChannelLoginUrl(){
		return getServerHost(0) + "/channel/login";
	}
	public String getDeviceConvertUrl(){
		return  getServerHost(0) + "/channel/device/convert";
	}
	
	public String getDeviceLoginUrl(){
		return getServerHost(0) + "/channel/device/login";
	}
	
	public String getGameLoginUrl(){
		return getServerHost(0) + "/channel/yodo1/login";
	}
	
	public String getGameRegUrl(){
		return getServerHost(0) + "/channel/yodo1/reg";
	}
	public String getGameRegPhoneUrl(){
		return getServerHost(0) + "/channel/yodo1/regwithphone";
	}
	
	public String getUpdateUrl(){
		return getServerHost(0)+"/client/update";
	}
	
	public String getRegionListUrl(){
		return getServerHost(0) + "/client/getRegionList";
	}
	public String getVerificationCodeUrl(){
		return getServerHost(0) + "/channel/yodo1/getVerificationCode";
	}
	public String getUpdatePwd(){
		return getServerHost(0) + "/channel/yodo1/updatePWD";
	}
	/*************  Payment  *************/
	public String getQueryOrderStatus(){
		return getServerHost(1) + "/order/getOrderStatus";
	}
	public String getCreateOrder(){
		return getServerHost(1) + "/order/create";
	}
	public String getValidateOrder(){
		return getServerHost(1) + "/order/validate";
	}
	public String getMissOrder(){
		return getServerHost(1) + "/order/missorders";
	}
	public String getSubmitLocalOrder(){
		return getServerHost(1) + "/order/ClientCallback";
	}
	public String getSendGoods(){
		return getServerHost(1) + "/order/sendGoodsOver";
	}
	public String syncOrderInfo(){
		return getServerHost(1) + "/order/verifyOrder";
	}


	/*************  activationcode  *************/
	public String getActivationcode(){
		return getServerHost(2) + "/activationcode/activateWithReward";
	}

	/*************  获取在线参数  *************/
//	public String getOnlineConfig(){
//		return getServerHost(3) + "/config/getData";
//	}
	public String getOnlineConfig(){
		return getServerHost(3) + "/config/getData?timeTemp="+System.currentTimeMillis();
	}
	public String getCDNOnlineConfig(){
		return getServerHost(4) + "/";
	}

	public String getLogEventConfig(){
		return getServerHost(5) + "/log/event";
	}


}
