package com.yodo1.advert.open;

import android.app.Activity;
import android.app.Application;
import android.util.Log;

import com.yodo1.advert.callback.BannerCallback;
import com.yodo1.advert.callback.InterstitialCallback;
import com.yodo1.advert.callback.VideoCallback;
import com.yodo1.advert.helper.Yodo1AdvertHelper;
import com.yodo1.sdk.kit.YLog;

/**
 * 广告开放接口
 * Created by zhuxiaochen on 2017/8/30.
 */
public class Yodo1Advert {
    public static boolean openLog = false;
    private static Yodo1AdvertHelper helper = Yodo1AdvertHelper.getInstance();

    public static void setOnLog(boolean onLog){
        YLog.setOnLog(onLog);

        if (onLog){
            openLog = true;
            YLog.d("Yodo1Advert 您当前处于测试模式");

        }
//        YLog.setDebugMode(onLog);
    }
    /**
     * 显示插屏广告
     *
     * @param activity
     * @param callback
     * @return 如果插屏开关关闭，或时间间隔未到,则返回false
     */
    public static boolean showInterstitial(final Activity activity, final InterstitialCallback callback) {
        YLog.d("call Yodo1Advert showInterstitialAd ...");
        return helper.showInterstitialAd(activity, callback);
    }
    /**
     * 游戏插屏广告是否缓冲完成
     *
     * @param activity
     * @return 如果游戏视频缓冲失败，正在缓冲中，或游戏视频列表为空,则返回false
     */
    public static boolean interstitialIsReady(Activity activity) {
        YLog.d("call Yodo1Advert interstitialAdReady ...");
        return helper.interstitialAdIsLoaded(activity);
    }

    /**
     * 显示游戏视频广告
     *
     * @param activity
     * @param callback
     * @return 如果游戏视频列表为空, 则返回false
     */
    public static boolean showVideo(final Activity activity, final VideoCallback callback) {
        YLog.d("call Yodo1Advert showVideoAd ...");
        return helper.showVideoAd(activity, callback);
    }

    /**
     * 游戏视频广告是否缓冲完成
     *
     * @param activity
     * @return 如果游戏视频缓冲失败，正在缓冲中，或游戏视频列表为空,则返回false
     */
    public static boolean videoIsReady(Activity activity) {
        YLog.d("call Yodo1Advert videoAdIsLoaded ...");
        return helper.videoAdIsLoaded(activity);
    }

    /**
     * 设置banner位置
     *
     * @param activity
     * @param align
     */
    public static void  SetBannerAlign( Activity activity,  int align){
        YLog.d("call Yodo1Advert setBannerAlign ...");
        helper.SetBannerAlign(activity,align);
    }


    /**
     * 展示banner
     *
     * @param activity
     */
    public static void ShowBanner(Activity activity,  BannerCallback callback) {
        YLog.d("call Yodo1Advert showBanner ...");
        helper.ShowBanner(activity,callback);
    }

    /**
     * 隐藏Banner
     *
     * @param activity
     */
    public static void HideBanner(Activity activity) {
        YLog.d("call Yodo1Advert hideBanner ...");
        helper.HideBanner1(activity);
    }

    /**
     * 移除Banner
     *
     * @param activity
     */
    public static void RemoveBanner(Activity activity) {
        YLog.d("call Yodo1Advert removeBanner ...");
        helper.RemoveBanner1(activity);
    }


    /**
     * Application初始化
     *
     * @param application
     */
    public static void createApp(Application application) {
        YLog.d("call Yodo1Game life cycle createApp ...");
        helper.onCreateApplication(application);
    }

    /**
     * 初始化SDK
     * 请在使用其他接口之前，于onCreate中调用
     *
     * @param activity
     * @param appKey
     */
    public static void initSDK(Activity activity, String appKey) {
        YLog.d("call Yodo1Game life cycle initSDK ...");
        helper.init(activity, appKey);
    }


    public static void onStart(Activity activity) {
        YLog.d("call Yodo1Game life cycle onStart ...");
        helper.onStart(activity);

    }
    public static void onResume(Activity activity) {
        YLog.d("call Yodo1Game life cycle onResume ...");
        helper.onResume(activity);

    }
    public static void onStop(Activity activity) {
        YLog.d("call Yodo1Game life cycle onStop ...");
        helper.onStop(activity);

    }
    public static void onPause(Activity activity) {
        YLog.d("call Yodo1Game life cycle onPause ...");
        helper.onPause(activity);
    }

    public static void onDestroy(Activity activity) {
        YLog.d("call Yodo1Game life cycle onDestroy ...");
        helper.onDestroy(activity);
    }

}
