/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.admob;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.InterstitialAd;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.reward.RewardItem;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.EBannerSize;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.BannerSmashListener;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class AdMobAdapter
extends AbstractAdapter {
    private static final String VERSION = "4.0.3";
    private static final String CORE_SDK_VERSION = "9.0.2";
    private final String IRONSOURCE_REQUEST_AGENT = "ironSource";
    private boolean mIsInterstitialReady = false;
    private boolean mIsRewardedVideoReady = false;
    private int mGender;
    private int mAge = -1;
    private RewardedVideoAd mRewardedVideoAd;
    private InterstitialAd mInterstitialAd;
    private boolean mDidInitSdk = false;
    private final String AD_UNIT_ID = "adUnitId";
    private final String APP_ID = "appId";
    private RewardedVideoAdListener rewardedVideoAdListener = new RewardedVideoAdListener(){

        public void onRewardedVideoAdLoaded() {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onRewardedVideoAdLoaded", 1);
            AdMobAdapter.this.mIsRewardedVideoReady = true;
            for (RewardedVideoSmashListener rewardedVideoSmashListener : AdMobAdapter.this.mAllRewardedVideoSmashes) {
                if (rewardedVideoSmashListener == null) continue;
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(true);
            }
        }

        public void onRewardedVideoAdOpened() {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onRewardedVideoAdOpened", 1);
            AdMobAdapter.this.mIsRewardedVideoReady = false;
            if (AdMobAdapter.this.mActiveRewardedVideoSmash != null) {
                AdMobAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdOpened();
            }
            for (RewardedVideoSmashListener rewardedVideoSmashListener : AdMobAdapter.this.mAllRewardedVideoSmashes) {
                if (rewardedVideoSmashListener == null) continue;
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
        }

        public void onRewardedVideoStarted() {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onRewardedVideoStarted", 1);
            if (AdMobAdapter.this.mActiveRewardedVideoSmash != null) {
                AdMobAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdStarted();
            }
        }

        public void onRewardedVideoAdClosed() {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onRewardedVideoAdClosed", 1);
            if (AdMobAdapter.this.mActiveRewardedVideoSmash != null) {
                AdMobAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdClosed();
            }
        }

        public void onRewarded(RewardItem rewardItem) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onRewarded", 1);
            if (AdMobAdapter.this.mActiveRewardedVideoSmash != null) {
                AdMobAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdRewarded();
            }
        }

        public void onRewardedVideoAdLeftApplication() {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onRewardedVideoAdLeftApplication", 1);
            if (AdMobAdapter.this.mActiveRewardedVideoSmash != null) {
                AdMobAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdClicked();
            }
        }

        public void onRewardedVideoAdFailedToLoad(int n2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onRewardedVideoAdFailedToLoad", 1);
            AdMobAdapter.this.mIsRewardedVideoReady = false;
            for (RewardedVideoSmashListener rewardedVideoSmashListener : AdMobAdapter.this.mAllRewardedVideoSmashes) {
                if (rewardedVideoSmashListener == null) continue;
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
        }
    };
    private AdListener mInterstitialAdListener = new AdListener(){

        public void onAdClosed() {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onAdClosed", 1);
            if (AdMobAdapter.this.mActiveInterstitialSmash != null) {
                AdMobAdapter.this.mActiveInterstitialSmash.onInterstitialAdClosed();
            }
        }

        public void onAdFailedToLoad(int n2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onAdFailedToLoad", 1);
            String string2 = AdMobAdapter.this.getErrorString(n2) + "( " + n2 + " )";
            for (InterstitialSmashListener interstitialSmashListener : AdMobAdapter.this.mAllInterstitialSmashes) {
                if (interstitialSmashListener == null) continue;
                interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)string2));
            }
        }

        public void onAdLeftApplication() {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onAdLeftApplication", 1);
            if (AdMobAdapter.this.mActiveInterstitialSmash != null) {
                AdMobAdapter.this.mActiveInterstitialSmash.onInterstitialAdClicked();
            }
        }

        public void onAdOpened() {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onAdOpened", 1);
            if (AdMobAdapter.this.mActiveInterstitialSmash != null) {
                AdMobAdapter.this.mActiveInterstitialSmash.onInterstitialAdOpened();
                AdMobAdapter.this.mActiveInterstitialSmash.onInterstitialAdShowSucceeded();
            }
        }

        public void onAdLoaded() {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onAdLoaded", 1);
            AdMobAdapter.this.mIsInterstitialReady = true;
            for (InterstitialSmashListener interstitialSmashListener : AdMobAdapter.this.mAllInterstitialSmashes) {
                if (interstitialSmashListener == null) continue;
                interstitialSmashListener.onInterstitialAdReady();
            }
        }
    };

    public static AdMobAdapter startAdapter(String string2) {
        return new AdMobAdapter(string2);
    }

    private AdMobAdapter(String string2) {
        super(string2);
        this.mAllBannerSmashes = new CopyOnWriteArrayList();
    }

    public String getVersion() {
        return VERSION;
    }

    public String getCoreSDKVersion() {
        return CORE_SDK_VERSION;
    }

    public void onResume(final Activity activity) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (AdMobAdapter.this.mRewardedVideoAd != null) {
                    AdMobAdapter.this.mRewardedVideoAd.resume((Context)activity);
                }
            }
        });
    }

    public void onPause(final Activity activity) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (AdMobAdapter.this.mRewardedVideoAd != null) {
                    AdMobAdapter.this.mRewardedVideoAd.pause((Context)activity);
                }
            }
        });
    }

    public void setAge(int n2) {
        this.mAge = n2;
    }

    public void setGender(String string2) {
        switch (string2) {
            case "female": {
                this.mGender = 2;
                break;
            }
            case "male": {
                this.mGender = 1;
                break;
            }
            default: {
                this.mGender = 0;
            }
        }
    }

    private synchronized void initSDK(Activity activity, String string2) {
        if (!this.mDidInitSdk) {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                MobileAds.initialize((Context)activity.getApplicationContext(), (String)string2);
            } else {
                MobileAds.initialize((Context)activity.getApplicationContext());
            }
            this.mDidInitSdk = true;
        }
    }

    public void initRewardedVideo(final Activity activity, String string2, String string3, final JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        if (TextUtils.isEmpty((CharSequence)jSONObject.optString("appId"))) {
            if (rewardedVideoSmashListener != null) {
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
            return;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                AdMobAdapter.this.initSDK(activity, jSONObject.optString("appId"));
                AdMobAdapter.this.mRewardedVideoAd = MobileAds.getRewardedVideoAdInstance((Context)activity);
                AdMobAdapter.this.mRewardedVideoAd.setRewardedVideoAdListener(AdMobAdapter.this.rewardedVideoAdListener);
                AdMobAdapter.this.loadRewardedVideoAd(jSONObject);
            }
        });
    }

    public void fetchRewardedVideo(JSONObject jSONObject) {
        this.loadRewardedVideoAd(jSONObject);
    }

    private void loadRewardedVideoAd(final JSONObject jSONObject) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                String string2 = jSONObject.optString("adUnitId");
                AdRequest adRequest = AdMobAdapter.this.createAdRequest();
                AdMobAdapter.this.mRewardedVideoAd.loadAd(string2, adRequest);
            }
        });
    }

    public boolean isRewardedVideoAvailable(JSONObject jSONObject) {
        return this.mRewardedVideoAd != null && this.mIsRewardedVideoReady;
    }

    public void showRewardedVideo(JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        this.mActiveRewardedVideoSmash = rewardedVideoSmashListener;
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (AdMobAdapter.this.mRewardedVideoAd.isLoaded()) {
                    AdMobAdapter.this.mRewardedVideoAd.show();
                } else {
                    if (AdMobAdapter.this.mActiveRewardedVideoSmash != null) {
                        AdMobAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
                    }
                    for (RewardedVideoSmashListener rewardedVideoSmashListener : AdMobAdapter.this.mAllRewardedVideoSmashes) {
                        if (rewardedVideoSmashListener == null) continue;
                        rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
                    }
                }
            }
        });
    }

    public void initInterstitial(Activity activity, String string2, String string3, JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        if (TextUtils.isEmpty((CharSequence)jSONObject.optString("appId"))) {
            if (interstitialSmashListener != null) {
                interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params", (String)"Interstitial"));
            }
            return;
        }
        this.initSDK(activity, jSONObject.optString("appId"));
        this.mInterstitialAd = new InterstitialAd((Context)activity);
        this.mInterstitialAd.setAdUnitId(jSONObject.optString("adUnitId"));
        this.mInterstitialAd.setAdListener(this.mInterstitialAdListener);
        for (InterstitialSmashListener interstitialSmashListener2 : this.mAllInterstitialSmashes) {
            if (interstitialSmashListener2 == null) continue;
            interstitialSmashListener2.onInterstitialInitSuccess();
        }
    }

    public void loadInterstitial(JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (AdMobAdapter.this.mInterstitialAd.isLoaded()) {
                    AdMobAdapter.this.mIsInterstitialReady = true;
                    for (InterstitialSmashListener interstitialSmashListener : AdMobAdapter.this.mAllInterstitialSmashes) {
                        if (interstitialSmashListener == null) continue;
                        interstitialSmashListener.onInterstitialAdReady();
                    }
                } else if (!AdMobAdapter.this.mInterstitialAd.isLoading() && !AdMobAdapter.this.mInterstitialAd.isLoaded()) {
                    AdRequest adRequest = AdMobAdapter.this.createAdRequest();
                    AdMobAdapter.this.mInterstitialAd.loadAd(adRequest);
                }
            }
        });
    }

    public void showInterstitial(JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        this.mActiveInterstitialSmash = interstitialSmashListener;
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (AdMobAdapter.this.mInterstitialAd != null && AdMobAdapter.this.mInterstitialAd.isLoaded()) {
                    AdMobAdapter.this.mInterstitialAd.show();
                    AdMobAdapter.this.mIsInterstitialReady = false;
                } else if (AdMobAdapter.this.mActiveInterstitialSmash != null) {
                    AdMobAdapter.this.mActiveInterstitialSmash.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
                }
            }
        });
    }

    public boolean isInterstitialReady(JSONObject jSONObject) {
        return this.mIsInterstitialReady;
    }

    protected void addBannerListener(BannerSmashListener bannerSmashListener) {
        this.mAllBannerSmashes.add(bannerSmashListener);
    }

    protected void removeBannerListener(BannerSmashListener bannerSmashListener) {
        this.mAllBannerSmashes.remove(bannerSmashListener);
    }

    public void initBanners(Activity activity, String string2, String string3, JSONObject jSONObject) {
        this.initSDK(activity, jSONObject.optString("appId"));
        for (BannerSmashListener bannerSmashListener : this.mAllBannerSmashes) {
            if (bannerSmashListener == null) continue;
            bannerSmashListener.onBannerInitSuccess();
        }
    }

    private AdView createBanner(Activity activity, EBannerSize eBannerSize, JSONObject jSONObject) {
        AdView adView = new AdView((Context)activity);
        if (jSONObject != null) {
            adView.setAdUnitId(jSONObject.optString("adUnitId"));
        }
        switch (eBannerSize) {
            case BANNER: {
                adView.setAdSize(new AdSize(-1, 50));
                break;
            }
            case LARGE: {
                adView.setAdSize(new AdSize(-1, 90));
                break;
            }
            case RECTANGLE: {
                adView.setAdSize(AdSize.MEDIUM_RECTANGLE);
                break;
            }
            case TABLET: {
                adView.setAdSize(new AdSize(-1, 90));
                break;
            }
            case SMART: {
                adView.setAdSize(AdSize.SMART_BANNER);
            }
        }
        adView.setAdListener(new AdListener(){

            public void onAdClosed() {
                super.onAdClosed();
                if (AdMobAdapter.this.mActiveBannerSmash != null) {
                    AdMobAdapter.this.mActiveBannerSmash.onBannerAdScreenDismissed();
                }
            }

            public void onAdFailedToLoad(int n2) {
                super.onAdFailedToLoad(n2);
                if (AdMobAdapter.this.mActiveBannerSmash != null) {
                    String string2 = AdMobAdapter.this.getErrorString(n2) + "( " + n2 + " )";
                    IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)string2);
                    AdMobAdapter.this.removeBannerViews();
                    AdMobAdapter.this.mActiveBannerSmash.onBannerAdLoadFailed(ironSourceError);
                }
            }

            public void onAdLeftApplication() {
                super.onAdLeftApplication();
                if (AdMobAdapter.this.mActiveBannerSmash != null) {
                    AdMobAdapter.this.mActiveBannerSmash.onBannerAdClicked();
                    AdMobAdapter.this.mActiveBannerSmash.onBannerAdLeftApplication();
                }
            }

            public void onAdOpened() {
                super.onAdOpened();
                if (AdMobAdapter.this.mActiveBannerSmash != null) {
                    AdMobAdapter.this.mActiveBannerSmash.onBannerAdScreenPresented();
                }
            }

            public void onAdLoaded() {
                super.onAdLoaded();
                if (AdMobAdapter.this.mActiveBannerSmash != null) {
                    AdMobAdapter.this.mActiveBannerSmash.onBannerAdLoaded();
                }
            }
        });
        return adView;
    }

    public void loadBanner(IronSourceBannerLayout ironSourceBannerLayout, final JSONObject jSONObject, BannerSmashListener bannerSmashListener) {
        this.mActiveBannerSmash = bannerSmashListener;
        if (ironSourceBannerLayout != null) {
            this.mIronSourceBanner = ironSourceBannerLayout;
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        try {
                            AdView adView = AdMobAdapter.this.createBanner(AdMobAdapter.this.mIronSourceBanner.getActivity(), AdMobAdapter.this.mIronSourceBanner.getSize(), jSONObject);
                            AdMobAdapter.this.mCurrentAdNetworkBanner = (View)adView;
                            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -1);
                            AdMobAdapter.this.mIronSourceBanner.addView((View)adView, 0, (ViewGroup.LayoutParams)layoutParams);
                            if (AdMobAdapter.this.mActiveBannerSmash != null) {
                                AdMobAdapter.this.mActiveBannerSmash.attachSmashToBanner((View)adView);
                            }
                            AdRequest adRequest = AdMobAdapter.this.createAdRequest();
                            adView.loadAd(adRequest);
                        }
                        catch (Exception exception) {
                            String string2 = "Banner Load Fail, " + AdMobAdapter.this.getProviderName() + " - " + "failed to retrieve AdMob AdView from banner layout";
                            IronSourceError ironSourceError = ErrorBuilder.buildLoadFailedError((String)string2);
                            if (AdMobAdapter.this.mActiveBannerSmash == null) break block3;
                            AdMobAdapter.this.mActiveBannerSmash.attachSmashToBanner(null);
                            AdMobAdapter.this.mActiveBannerSmash.onBannerAdLoadFailed(ironSourceError);
                        }
                    }
                }
            });
        }
    }

    public void destroyBanner(IronSourceBannerLayout ironSourceBannerLayout) {
        if (ironSourceBannerLayout != null) {
            try {
                AdView adView = (AdView)ironSourceBannerLayout.getBannerView();
                if (adView != null) {
                    adView.destroy();
                }
            }
            catch (Exception exception) {
                this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + ":destroyBanner() failed with an exception: " + exception, 2);
            }
        }
    }

    private AdRequest createAdRequest() {
        AdRequest.Builder builder = new AdRequest.Builder();
        builder.setGender(this.mGender);
        builder.setRequestAgent("ironSource");
        if (this.mAge > -1) {
            builder.tagForChildDirectedTreatment(this.mAge < 13);
        }
        return builder.build();
    }

    private String getErrorString(int n2) {
        switch (n2) {
            case 0: {
                return "Internal error";
            }
            case 1: {
                return "The ad request was invalid";
            }
            case 2: {
                return "The ad request was unsuccessful due to network connectivity";
            }
            case 3: {
                return "The ad request was successful, but no ad was returned due to lack of ad inventory";
            }
        }
        return "Unknown error";
    }
}

