/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.adcolony;

import android.app.Activity;
import android.text.TextUtils;
import com.adcolony.sdk.AdColony;
import com.adcolony.sdk.AdColonyAppOptions;
import com.adcolony.sdk.AdColonyInterstitial;
import com.adcolony.sdk.AdColonyInterstitialListener;
import com.adcolony.sdk.AdColonyReward;
import com.adcolony.sdk.AdColonyRewardListener;
import com.adcolony.sdk.AdColonyUserMetadata;
import com.adcolony.sdk.AdColonyZone;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.InterstitialSmash;
import com.ironsource.mediationsdk.RewardedVideoSmash;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.json.JSONObject;

class AdColonyAdapter
extends AbstractAdapter {
    private static final String VERSION = "4.0.1";
    private static final String CORE_SDK_VERSION = "3.2.1";
    private Boolean mAlreadyInitiated = false;
    private boolean mDidCallLoad = false;
    private AdColonyInterstitialListener mAdColonyInterstitialListener;
    private AdColonyRewardListener mAdColonyRewardListener;
    private AdColonyInterstitialListener mAdColonyRewardedVideoListener;
    private final String APP_ID = "appID";
    private final String ZONE_ID = "zoneId";
    private Map<String, AdColonyInterstitial> mZoneToAdMap = new HashMap<String, AdColonyInterstitial>();

    public static AdColonyAdapter startAdapter(String string) {
        return new AdColonyAdapter(string);
    }

    private AdColonyAdapter(String string) {
        super(string);
    }

    public String getVersion() {
        return VERSION;
    }

    public String getCoreSDKVersion() {
        return CORE_SDK_VERSION;
    }

    public void setAge(int n2) {
        try {
            AdColony.getAppOptions().getUserMetadata().setUserAge(n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setGender(String string) {
        try {
            AdColony.getAppOptions().getUserMetadata().setUserGender(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void init(final Activity activity, final String string, final String string2, final String string3, final String string4, final HashSet<String> hashSet) {
        activity.runOnUiThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Boolean bl = AdColonyAdapter.this.mAlreadyInitiated;
                synchronized (bl) {
                    if (!AdColonyAdapter.this.mAlreadyInitiated.booleanValue()) {
                        AdColonyAppOptions adColonyAppOptions = new AdColonyAppOptions();
                        adColonyAppOptions.setUserID(string);
                        AdColonyUserMetadata object = new AdColonyUserMetadata();
                        adColonyAppOptions.setUserMetadata(object);
                        AdColony.configure((Activity)activity, (AdColonyAppOptions)adColonyAppOptions, (String)string3, (String[])hashSet.toArray(new String[hashSet.size()]));
                        AdColonyAdapter.this.mAlreadyInitiated = true;
                    }
                    if (string2.equals("IS")) {
                        for (Map.Entry entry : AdColonyAdapter.this.mInterstitialPlacementToListenerMap.entrySet()) {
                            if (entry.getValue() == null) continue;
                            ((InterstitialSmashListener)entry.getValue()).onInterstitialInitSuccess();
                        }
                    } else if (string2.equals("RV") && string4 != null) {
                        AdColonyAdapter.this.loadRewardedVideo(string4);
                    }
                }
            }
        });
    }

    private void loadRewardedVideo(String string) {
        AdColonyInterstitial adColonyInterstitial;
        if (this.mAdColonyRewardListener == null) {
            this.mAdColonyRewardListener = new AdColonyRewardListener(){

                public void onReward(AdColonyReward adColonyReward) {
                    IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, AdColonyAdapter.this.getProviderName() + " :RewardedVideo:onReward", 0);
                    try {
                        RewardedVideoSmashListener rewardedVideoSmashListener = (RewardedVideoSmashListener)AdColonyAdapter.this.mRewardedVideoPlacementToListenerMap.get(adColonyReward.getZoneID());
                        if (adColonyReward.success() && rewardedVideoSmashListener != null) {
                            rewardedVideoSmashListener.onRewardedVideoAdRewarded();
                        }
                    }
                    catch (Throwable throwable) {
                        IronSourceLoggerManager.getLogger().logException(IronSourceLogger.IronSourceTag.ADAPTER_CALLBACK, AdColonyAdapter.this.getProviderName() + ":onReward()", throwable);
                    }
                }
            };
        }
        if (this.mAdColonyRewardedVideoListener == null) {
            this.mAdColonyRewardedVideoListener = new AdColonyInterstitialListener(){

                public void onRequestFilled(AdColonyInterstitial adColonyInterstitial) {
                    AdColonyAdapter.this.log(IronSourceLogger.IronSourceTag.INTERNAL, AdColonyAdapter.this.getProviderName() + " :RewardedVideo:onRequestFilled():", 0);
                    if (adColonyInterstitial != null && !TextUtils.isEmpty((CharSequence)adColonyInterstitial.getZoneID())) {
                        AdColonyAdapter.this.mZoneToAdMap.put(adColonyInterstitial.getZoneID(), adColonyInterstitial);
                    }
                    for (Map.Entry entry : AdColonyAdapter.this.mRewardedVideoPlacementToListenerMap.entrySet()) {
                        if (entry.getValue() == null) continue;
                        ((RewardedVideoSmashListener)entry.getValue()).onRewardedVideoAvailabilityChanged(true);
                    }
                }

                public void onRequestNotFilled(AdColonyZone adColonyZone) {
                    AdColonyAdapter.this.log(IronSourceLogger.IronSourceTag.INTERNAL, AdColonyAdapter.this.getProviderName() + " :RewardedVideo:onRequestNotFilled():zone: " + adColonyZone.getZoneID(), 0);
                    RewardedVideoSmashListener rewardedVideoSmashListener = (RewardedVideoSmashListener)AdColonyAdapter.this.mRewardedVideoPlacementToListenerMap.get(adColonyZone.getZoneID());
                    if (rewardedVideoSmashListener != null) {
                        rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
                    }
                }

                public void onOpened(AdColonyInterstitial adColonyInterstitial) {
                    AdColonyAdapter.this.log(IronSourceLogger.IronSourceTag.INTERNAL, AdColonyAdapter.this.getProviderName() + ":RewardedVideo:onOpened():", 0);
                    RewardedVideoSmashListener rewardedVideoSmashListener = (RewardedVideoSmashListener)AdColonyAdapter.this.mRewardedVideoPlacementToListenerMap.get(adColonyInterstitial.getZoneID());
                    if (rewardedVideoSmashListener != null) {
                        rewardedVideoSmashListener.onRewardedVideoAdOpened();
                        rewardedVideoSmashListener.onRewardedVideoAdStarted();
                    }
                }

                public void onClosed(AdColonyInterstitial adColonyInterstitial) {
                    AdColonyAdapter.this.log(IronSourceLogger.IronSourceTag.INTERNAL, AdColonyAdapter.this.getProviderName() + ":RewardedVideo:onClosed():", 0);
                    RewardedVideoSmashListener rewardedVideoSmashListener = (RewardedVideoSmashListener)AdColonyAdapter.this.mRewardedVideoPlacementToListenerMap.get(adColonyInterstitial.getZoneID());
                    if (rewardedVideoSmashListener != null) {
                        rewardedVideoSmashListener.onRewardedVideoAdEnded();
                        rewardedVideoSmashListener.onRewardedVideoAdClosed();
                    }
                }

                public void onClicked(AdColonyInterstitial adColonyInterstitial) {
                    AdColonyAdapter.this.log(IronSourceLogger.IronSourceTag.INTERNAL, AdColonyAdapter.this.getProviderName() + " :RewardedVideo:onClicked():", 0);
                    RewardedVideoSmashListener rewardedVideoSmashListener = (RewardedVideoSmashListener)AdColonyAdapter.this.mRewardedVideoPlacementToListenerMap.get(adColonyInterstitial.getZoneID());
                    if (rewardedVideoSmashListener != null) {
                        rewardedVideoSmashListener.onRewardedVideoAdClicked();
                    }
                }

                public void onExpiring(AdColonyInterstitial adColonyInterstitial) {
                    AdColonyAdapter.this.log(IronSourceLogger.IronSourceTag.INTERNAL, AdColonyAdapter.this.getProviderName() + " :RewardedVideo:onExpiring():", 0);
                    AdColony.requestInterstitial((String)adColonyInterstitial.getZoneID(), (AdColonyInterstitialListener)AdColonyAdapter.this.mAdColonyRewardedVideoListener);
                }
            };
        }
        if ((adColonyInterstitial = this.mZoneToAdMap.get(string)) == null || adColonyInterstitial.isExpired()) {
            AdColony.setRewardListener((AdColonyRewardListener)this.mAdColonyRewardListener);
            AdColony.requestInterstitial((String)string, (AdColonyInterstitialListener)this.mAdColonyRewardedVideoListener);
        }
    }

    public void initRewardedVideo(Activity activity, String string, String string2, JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        block5: {
            try {
                String string3 = jSONObject.optString("appID");
                String string4 = jSONObject.optString("zoneId");
                if (!TextUtils.isEmpty((CharSequence)string4) && rewardedVideoSmashListener != null) {
                    this.mRewardedVideoPlacementToListenerMap.put(string4, rewardedVideoSmashListener);
                }
                if (TextUtils.isEmpty((CharSequence)string3) || TextUtils.isEmpty((CharSequence)string4)) {
                    if (rewardedVideoSmashListener != null) {
                        rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
                    }
                    return;
                }
                HashSet hashSet = ((RewardedVideoSmash)rewardedVideoSmashListener).getAllSettingsForProvider("zoneId");
                this.init(activity, string2, "RV", string3, string4, hashSet);
            }
            catch (Exception exception) {
                if (rewardedVideoSmashListener == null) break block5;
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
        }
    }

    public void fetchRewardedVideo(JSONObject jSONObject) {
        this.loadRewardedVideo(jSONObject.optString("zoneId"));
    }

    public void showRewardedVideo(JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        try {
            String string = jSONObject.optString("zoneId");
            AdColonyInterstitial adColonyInterstitial = this.mZoneToAdMap.get(string);
            if (adColonyInterstitial != null && !adColonyInterstitial.isExpired()) {
                adColonyInterstitial.show();
            } else {
                if (rewardedVideoSmashListener != null) {
                    rewardedVideoSmashListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
                }
                for (Map.Entry entry : this.mRewardedVideoPlacementToListenerMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    ((RewardedVideoSmashListener)entry.getValue()).onRewardedVideoAvailabilityChanged(false);
                }
                AdColony.requestInterstitial((String)string, (AdColonyInterstitialListener)this.mAdColonyRewardedVideoListener);
            }
        }
        catch (Exception exception) {
            if (rewardedVideoSmashListener != null) {
                rewardedVideoSmashListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
            }
            for (Map.Entry entry : this.mRewardedVideoPlacementToListenerMap.entrySet()) {
                if (entry.getValue() == null) continue;
                ((RewardedVideoSmashListener)entry.getValue()).onRewardedVideoAvailabilityChanged(false);
            }
        }
    }

    public synchronized boolean isRewardedVideoAvailable(JSONObject jSONObject) {
        try {
            String string = jSONObject.optString("zoneId");
            AdColonyInterstitial adColonyInterstitial = this.mZoneToAdMap.get(string);
            return adColonyInterstitial != null && !adColonyInterstitial.isExpired();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void initInterstitial(Activity activity, String string, String string2, JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        try {
            String string3 = jSONObject.optString("appID");
            if (TextUtils.isEmpty((CharSequence)string3)) {
                if (interstitialSmashListener != null) {
                    interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params", (String)"Interstitial"));
                }
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)jSONObject.optString("zoneId")) && interstitialSmashListener != null) {
                this.mInterstitialPlacementToListenerMap.put(jSONObject.optString("zoneId"), interstitialSmashListener);
            }
            HashSet hashSet = ((InterstitialSmash)interstitialSmashListener).getAllSettingsForProvider("zoneId");
            this.init(activity, string2, "IS", string3, null, hashSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadInterstitial(JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        try {
            boolean bl;
            String string = jSONObject.optString("zoneId");
            AdColonyInterstitial adColonyInterstitial = this.mZoneToAdMap.get(string);
            boolean bl2 = bl = adColonyInterstitial != null && !adColonyInterstitial.isExpired();
            if (bl) {
                if (interstitialSmashListener != null) {
                    interstitialSmashListener.onInterstitialAdReady();
                }
                return;
            }
            this.mDidCallLoad = true;
            if (this.mAdColonyInterstitialListener == null) {
                this.mAdColonyInterstitialListener = new AdColonyInterstitialListener(){

                    public void onRequestFilled(AdColonyInterstitial adColonyInterstitial) {
                        AdColonyAdapter.this.log(IronSourceLogger.IronSourceTag.INTERNAL, AdColonyAdapter.this.getProviderName() + " :Interstitial:onRequestFilled():", 0);
                        if (adColonyInterstitial != null && !TextUtils.isEmpty((CharSequence)adColonyInterstitial.getZoneID())) {
                            AdColonyAdapter.this.mZoneToAdMap.put(adColonyInterstitial.getZoneID(), adColonyInterstitial);
                        }
                        if (AdColonyAdapter.this.mDidCallLoad) {
                            AdColonyAdapter.this.mDidCallLoad = false;
                            InterstitialSmashListener interstitialSmashListener = (InterstitialSmashListener)AdColonyAdapter.this.mInterstitialPlacementToListenerMap.get(adColonyInterstitial.getZoneID());
                            if (interstitialSmashListener != null) {
                                interstitialSmashListener.onInterstitialAdReady();
                            }
                        }
                    }

                    public void onRequestNotFilled(AdColonyZone adColonyZone) {
                        AdColonyAdapter.this.log(IronSourceLogger.IronSourceTag.INTERNAL, AdColonyAdapter.this.getProviderName() + " :Interstitial:onRequestNotFilled():zone: " + adColonyZone.getZoneID(), 0);
                        AdColonyAdapter.this.mDidCallLoad = false;
                        InterstitialSmashListener interstitialSmashListener = (InterstitialSmashListener)AdColonyAdapter.this.mInterstitialPlacementToListenerMap.get(adColonyZone.getZoneID());
                        if (interstitialSmashListener != null) {
                            interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)"Request Not Filled"));
                        }
                    }

                    public void onOpened(AdColonyInterstitial adColonyInterstitial) {
                        AdColonyAdapter.this.log(IronSourceLogger.IronSourceTag.INTERNAL, AdColonyAdapter.this.getProviderName() + " :Interstitial:onOpened():", 0);
                        InterstitialSmashListener interstitialSmashListener = (InterstitialSmashListener)AdColonyAdapter.this.mInterstitialPlacementToListenerMap.get(adColonyInterstitial.getZoneID());
                        if (interstitialSmashListener != null) {
                            interstitialSmashListener.onInterstitialAdOpened();
                            interstitialSmashListener.onInterstitialAdShowSucceeded();
                        }
                    }

                    public void onClosed(AdColonyInterstitial adColonyInterstitial) {
                        AdColonyAdapter.this.log(IronSourceLogger.IronSourceTag.INTERNAL, AdColonyAdapter.this.getProviderName() + " :Interstitial:onClosed():", 0);
                        InterstitialSmashListener interstitialSmashListener = (InterstitialSmashListener)AdColonyAdapter.this.mInterstitialPlacementToListenerMap.get(adColonyInterstitial.getZoneID());
                        if (interstitialSmashListener != null) {
                            interstitialSmashListener.onInterstitialAdClosed();
                            if (AdColonyAdapter.this.mZoneToAdMap.containsKey(adColonyInterstitial.getZoneID())) {
                                AdColonyAdapter.this.mZoneToAdMap.remove(adColonyInterstitial.getZoneID());
                            }
                        }
                    }

                    public void onClicked(AdColonyInterstitial adColonyInterstitial) {
                        AdColonyAdapter.this.log(IronSourceLogger.IronSourceTag.INTERNAL, AdColonyAdapter.this.getProviderName() + " :Interstitial:onClicked():", 0);
                        InterstitialSmashListener interstitialSmashListener = (InterstitialSmashListener)AdColonyAdapter.this.mInterstitialPlacementToListenerMap.get(adColonyInterstitial.getZoneID());
                        if (interstitialSmashListener != null) {
                            interstitialSmashListener.onInterstitialAdClicked();
                        }
                    }

                    public void onExpiring(AdColonyInterstitial adColonyInterstitial) {
                        AdColonyAdapter.this.log(IronSourceLogger.IronSourceTag.INTERNAL, AdColonyAdapter.this.getProviderName() + " :Interstitial:onExpiring():", 0);
                        AdColony.requestInterstitial((String)adColonyInterstitial.getZoneID(), (AdColonyInterstitialListener)AdColonyAdapter.this.mAdColonyInterstitialListener);
                    }
                };
            }
            if (adColonyInterstitial == null || adColonyInterstitial.isExpired()) {
                AdColony.requestInterstitial((String)string, (AdColonyInterstitialListener)this.mAdColonyInterstitialListener);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showInterstitial(JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        try {
            String string = jSONObject.optString("zoneId");
            AdColonyInterstitial adColonyInterstitial = this.mZoneToAdMap.get(string);
            if (adColonyInterstitial != null && !adColonyInterstitial.isExpired()) {
                adColonyInterstitial.show();
            } else if (interstitialSmashListener != null) {
                interstitialSmashListener.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isInterstitialReady(JSONObject jSONObject) {
        try {
            String string = jSONObject.optString("zoneId");
            AdColonyInterstitial adColonyInterstitial = this.mZoneToAdMap.get(string);
            return adColonyInterstitial != null && !adColonyInterstitial.isExpired();
        }
        catch (Exception exception) {
            return false;
        }
    }
}

