/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.vungle;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.InterstitialSmash;
import com.ironsource.mediationsdk.RewardedVideoSmash;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import com.vungle.publisher.AdConfig;
import com.vungle.publisher.VungleAdEventListener;
import com.vungle.publisher.VungleInitListener;
import com.vungle.publisher.VunglePub;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

class VungleAdapter
extends AbstractAdapter
implements VungleAdEventListener,
VungleInitListener {
    private static final String VERSION = "4.0.2";
    private static final String CORE_SDK_VERSION = "5.3.2";
    private VunglePub mVunglePub;
    private EInitState mInitState = EInitState.NOT_INIT;
    private Set<String> mInitiatedAdUnits;
    private String mCurrentUserId;
    private boolean mDidCallLoad = false;
    private final String APP_ID = "AppID";
    private final String PLACEMENT_ID = "PlacementId";

    public static VungleAdapter startAdapter(String string) {
        return new VungleAdapter(string);
    }

    private VungleAdapter(String string) {
        super(string);
    }

    private synchronized void setInitState(EInitState eInitState) {
        this.log(IronSourceLogger.IronSourceTag.ADAPTER_API, this.getProviderName() + ":init state changed from " + (Object)((Object)this.mInitState) + " to " + (Object)((Object)eInitState) + ")", 1);
        this.mInitState = eInitState;
    }

    private synchronized EInitState getCurrentInitState() {
        return this.mInitState;
    }

    public String getVersion() {
        return VERSION;
    }

    public String getCoreSDKVersion() {
        return CORE_SDK_VERSION;
    }

    public void onResume(Activity activity) {
        if (this.mVunglePub != null) {
            this.mVunglePub.onResume();
        }
    }

    public void onPause(Activity activity) {
        if (this.mVunglePub != null) {
            this.mVunglePub.onPause();
        }
    }

    public void initRewardedVideo(Activity activity, String string, String string2, JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        if (TextUtils.isEmpty((CharSequence)jSONObject.optString("AppID")) || TextUtils.isEmpty((CharSequence)jSONObject.optString("PlacementId"))) {
            if (rewardedVideoSmashListener != null) {
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)jSONObject.optString("PlacementId")) && rewardedVideoSmashListener != null) {
            this.mRewardedVideoPlacementToListenerMap.put(jSONObject.optString("PlacementId"), rewardedVideoSmashListener);
        }
        this.addInitiatedAdUnit("Rewarded Video");
        HashSet hashSet = new HashSet();
        switch (this.getCurrentInitState()) {
            case NOT_INIT: {
                if (rewardedVideoSmashListener != null) {
                    hashSet = ((RewardedVideoSmash)rewardedVideoSmashListener).getAllSettingsForProvider("PlacementId");
                }
                this.initSdk(activity, jSONObject.optString("AppID"), string2, hashSet);
                break;
            }
            case INIT_IN_PROGRESS: {
                break;
            }
            case INIT_SUCCESS: {
                if (this.mVunglePub.isAdPlayable(jSONObject.optString("PlacementId"))) {
                    if (rewardedVideoSmashListener == null) break;
                    rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(true);
                    break;
                }
                this.mVunglePub.loadAd(jSONObject.optString("PlacementId"));
                break;
            }
            case INIT_FAIL: {
                if (rewardedVideoSmashListener == null) break;
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
        }
    }

    private void initSdk(final Activity activity, final String string, String string2, HashSet<String> hashSet) {
        this.setInitState(EInitState.INIT_IN_PROGRESS);
        final String[] stringArray = hashSet.toArray(new String[hashSet.size()]);
        this.mVunglePub = VunglePub.getInstance();
        this.mCurrentUserId = string2;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                VungleAdapter.this.mVunglePub.init((Context)activity, string, stringArray, (VungleInitListener)VungleAdapter.this);
                VungleAdapter.this.mVunglePub.clearAndSetEventListeners(new VungleAdEventListener[]{VungleAdapter.this});
            }
        });
    }

    private void addInitiatedAdUnit(String string) {
        if (this.mInitiatedAdUnits == null) {
            this.mInitiatedAdUnits = new HashSet<String>();
        }
        this.mInitiatedAdUnits.add(string);
    }

    public void fetchRewardedVideo(JSONObject jSONObject) {
    }

    public void showRewardedVideo(JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        if (this.mVunglePub != null) {
            boolean bl = this.mVunglePub.isAdPlayable(jSONObject.optString("PlacementId"));
            if (bl) {
                AdConfig adConfig = new AdConfig();
                adConfig.setIncentivizedUserId(this.mCurrentUserId);
                this.mVunglePub.playAd(jSONObject.optString("PlacementId"), adConfig);
            } else if (rewardedVideoSmashListener != null) {
                rewardedVideoSmashListener.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
        }
    }

    public boolean isRewardedVideoAvailable(JSONObject jSONObject) {
        return this.mVunglePub != null && this.mVunglePub.isInitialized() && this.mVunglePub.isAdPlayable(jSONObject.optString("PlacementId"));
    }

    public void initInterstitial(Activity activity, String string, String string2, JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        if (TextUtils.isEmpty((CharSequence)jSONObject.optString("AppID")) || TextUtils.isEmpty((CharSequence)jSONObject.optString("PlacementId"))) {
            if (interstitialSmashListener != null) {
                interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params", (String)"Interstitial"));
            }
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)jSONObject.optString("PlacementId")) && interstitialSmashListener != null) {
            this.mInterstitialPlacementToListenerMap.put(jSONObject.optString("PlacementId"), interstitialSmashListener);
        }
        this.addInitiatedAdUnit("Interstitial");
        HashSet hashSet = new HashSet();
        switch (this.getCurrentInitState()) {
            case NOT_INIT: {
                if (interstitialSmashListener != null) {
                    hashSet = ((InterstitialSmash)interstitialSmashListener).getAllSettingsForProvider("PlacementId");
                }
                this.initSdk(activity, jSONObject.optString("AppID"), string2, hashSet);
                break;
            }
            case INIT_IN_PROGRESS: {
                break;
            }
            case INIT_SUCCESS: {
                if (interstitialSmashListener == null) break;
                interstitialSmashListener.onInterstitialInitSuccess();
                break;
            }
            case INIT_FAIL: {
                if (interstitialSmashListener == null) break;
                interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Init Failed", (String)"Interstitial"));
            }
        }
    }

    public void loadInterstitial(JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        if (this.mVunglePub.isAdPlayable(jSONObject.optString("PlacementId"))) {
            if (interstitialSmashListener != null) {
                interstitialSmashListener.onInterstitialAdReady();
            }
        } else {
            this.mDidCallLoad = true;
            this.mVunglePub.loadAd(jSONObject.optString("PlacementId"));
        }
    }

    public void showInterstitial(JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        if (this.mVunglePub != null && this.mVunglePub.isAdPlayable(jSONObject.optString("PlacementId"))) {
            this.mVunglePub.playAd(jSONObject.optString("PlacementId"), this.mVunglePub.getGlobalAdConfig());
        } else if (interstitialSmashListener != null) {
            interstitialSmashListener.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
        }
    }

    public boolean isInterstitialReady(JSONObject jSONObject) {
        return this.mVunglePub != null && this.mVunglePub.isInitialized() && this.mVunglePub.isAdPlayable(jSONObject.optString("PlacementId"));
    }

    public void onSuccess() {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onSuccess()", 1);
        this.setInitState(EInitState.INIT_SUCCESS);
        if (this.mInitiatedAdUnits != null) {
            if (this.mInitiatedAdUnits.contains("Rewarded Video")) {
                for (Map.Entry entry : this.mRewardedVideoPlacementToListenerMap.entrySet()) {
                    if (this.mVunglePub.isAdPlayable((String)entry.getKey())) {
                        if (entry.getValue() == null) continue;
                        ((RewardedVideoSmashListener)entry.getValue()).onRewardedVideoAvailabilityChanged(true);
                        continue;
                    }
                    this.mVunglePub.loadAd((String)entry.getKey());
                }
            }
            if (this.mInitiatedAdUnits.contains("Interstitial")) {
                for (Map.Entry entry : this.mInterstitialPlacementToListenerMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    ((InterstitialSmashListener)entry.getValue()).onInterstitialInitSuccess();
                }
            }
        }
    }

    public void onFailure(Throwable throwable) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onFailure()", 1);
        this.setInitState(EInitState.INIT_FAIL);
        if (this.mInitiatedAdUnits != null) {
            if (this.mInitiatedAdUnits.contains("Rewarded Video")) {
                for (Map.Entry entry : this.mRewardedVideoPlacementToListenerMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    ((RewardedVideoSmashListener)entry.getValue()).onRewardedVideoAvailabilityChanged(false);
                }
            }
            if (this.mInitiatedAdUnits.contains("Interstitial")) {
                for (Map.Entry entry : this.mInterstitialPlacementToListenerMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    ((InterstitialSmashListener)entry.getValue()).onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Init Failed", (String)"Interstitial"));
                }
            }
        }
    }

    public void onAdEnd(String string, boolean bl, boolean bl2) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onAdEnd(wasSuccessfulView: " + bl + ", wasCallToActionClicked:" + bl2 + ")", 1);
        if (this.mRewardedVideoPlacementToListenerMap.get(string) != null) {
            ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(string)).onRewardedVideoAdEnded();
            if (bl) {
                ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(string)).onRewardedVideoAdRewarded();
            }
            ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(string)).onRewardedVideoAdClosed();
            boolean bl3 = this.mVunglePub.isAdPlayable(string);
            ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(string)).onRewardedVideoAvailabilityChanged(bl3);
            if (!bl3) {
                this.mVunglePub.loadAd(string);
            }
        } else if (this.mInterstitialPlacementToListenerMap.get(string) != null) {
            if (bl2) {
                ((InterstitialSmashListener)this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdClicked();
            }
            ((InterstitialSmashListener)this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdClosed();
        }
    }

    public void onAdStart(String string) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onAdStart, placementReferenceId: " + string, 1);
        if (this.mRewardedVideoPlacementToListenerMap.get(string) != null) {
            ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(string)).onRewardedVideoAdOpened();
            ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(string)).onRewardedVideoAdStarted();
        } else if (this.mInterstitialPlacementToListenerMap.get(string) != null) {
            ((InterstitialSmashListener)this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdOpened();
            ((InterstitialSmashListener)this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdShowSucceeded();
        }
    }

    public void onUnableToPlayAd(String string, String string2) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onUnableToPlayAd, placementReferenceId: " + string, 1);
        if (this.mRewardedVideoPlacementToListenerMap.get(string) != null) {
            ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(string)).onRewardedVideoAvailabilityChanged(false);
            ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(string)).onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
        } else if (this.mInterstitialPlacementToListenerMap.get(string) != null) {
            ((InterstitialSmashListener)this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
        }
    }

    public void onAdAvailabilityUpdate(String string, boolean bl) {
        IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "onAdAvailabilityUpdate, placementReferenceId: " + string + ", isAdAvailable: " + bl, 1);
        if (this.mRewardedVideoPlacementToListenerMap.get(string) != null) {
            ((RewardedVideoSmashListener)this.mRewardedVideoPlacementToListenerMap.get(string)).onRewardedVideoAvailabilityChanged(bl);
        } else if (this.mInterstitialPlacementToListenerMap.get(string) != null && this.mDidCallLoad) {
            this.mDidCallLoad = false;
            if (bl) {
                ((InterstitialSmashListener)this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdReady();
            } else {
                ((InterstitialSmashListener)this.mInterstitialPlacementToListenerMap.get(string)).onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)"No Ads"));
            }
        }
    }

    private static enum EInitState {
        NOT_INIT,
        INIT_IN_PROGRESS,
        INIT_SUCCESS,
        INIT_FAIL;

    }
}

