/*
 * Decompiled with CFR 0.152.
 */
package com.ironsource.adapters.chartboost;

import android.app.Activity;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.chartboost.sdk.Chartboost;
import com.chartboost.sdk.ChartboostDelegate;
import com.chartboost.sdk.Libraries.CBLogging;
import com.chartboost.sdk.Model.CBError;
import com.ironsource.mediationsdk.AbstractAdapter;
import com.ironsource.mediationsdk.logger.IronSourceLogger;
import com.ironsource.mediationsdk.logger.IronSourceLoggerManager;
import com.ironsource.mediationsdk.sdk.InterstitialSmashListener;
import com.ironsource.mediationsdk.sdk.RewardedVideoSmashListener;
import com.ironsource.mediationsdk.utils.ErrorBuilder;
import org.json.JSONObject;

class ChartboostAdapter
extends AbstractAdapter {
    private static final String VERSION = "4.0.1";
    private static final String CORE_SDK_VERSION = "7.0.0";
    private CbDelegate mDelegate;
    private Boolean mAlreadyCalledInit = false;
    private boolean mDidCallLoad = false;
    private boolean mDidCallInitInterstitial = false;
    private boolean mInitiatedSuccessfully = false;
    private final String APP_ID = "appID";
    private final String APP_SIGNATURE = "appSignature";

    public static ChartboostAdapter startAdapter(String string2) {
        return new ChartboostAdapter(string2);
    }

    private ChartboostAdapter(String string2) {
        super(string2);
    }

    public String getVersion() {
        return VERSION;
    }

    public String getCoreSDKVersion() {
        return CORE_SDK_VERSION;
    }

    public void onResume(Activity activity) {
        if (activity != null) {
            Chartboost.onStart(activity);
            Chartboost.onResume(activity);
        }
    }

    public void onPause(Activity activity) {
        if (activity != null) {
            Chartboost.onPause(activity);
            Chartboost.onStop(activity);
        }
    }

    private synchronized void init(final Activity activity, final String string2, final String string3, final String string4, final String string5) {
        activity.runOnUiThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Boolean bl = ChartboostAdapter.this.mAlreadyCalledInit;
                synchronized (bl) {
                    if (!ChartboostAdapter.this.mAlreadyCalledInit.booleanValue()) {
                        ChartboostAdapter.this.mAlreadyCalledInit = true;
                        Chartboost.setDelegate(ChartboostAdapter.this.mDelegate);
                        Chartboost.startWithAppId(activity, string4, string5);
                        boolean bl2 = false;
                        try {
                            bl2 = ChartboostAdapter.this.isAdaptersDebugEnabled();
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            // empty catch block
                        }
                        if (bl2) {
                            Chartboost.setLoggingLevel(CBLogging.Level.ALL);
                        } else {
                            Chartboost.setLoggingLevel(CBLogging.Level.NONE);
                        }
                        if ("Unity".equals(ChartboostAdapter.this.getPluginType()) && !TextUtils.isEmpty((CharSequence)ChartboostAdapter.this.getPluginFrameworkVersion())) {
                            Chartboost.setFramework(Chartboost.CBFramework.CBFrameworkUnity, ChartboostAdapter.this.getPluginFrameworkVersion());
                        }
                        Chartboost.setMediation(Chartboost.CBMediation.CBMediationSupersonic, ChartboostAdapter.VERSION);
                        Chartboost.setCustomId(string2);
                        Chartboost.setAutoCacheAds(true);
                        Chartboost.onCreate(activity);
                        Chartboost.onStart(activity);
                        Chartboost.onResume(activity);
                    }
                    if (string3.equals("RV")) {
                        Chartboost.cacheRewardedVideo("Default");
                    } else if (string3.equals("IS") && ChartboostAdapter.this.mInitiatedSuccessfully) {
                        ChartboostAdapter.this.reportInterstitialInitSuccess();
                    }
                }
            }
        });
    }

    public void initRewardedVideo(Activity activity, String string2, String string3, JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        if (TextUtils.isEmpty((CharSequence)jSONObject.optString("appID")) || TextUtils.isEmpty((CharSequence)jSONObject.optString("appSignature"))) {
            if (rewardedVideoSmashListener != null) {
                rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(false);
            }
            return;
        }
        if (this.mDelegate == null) {
            this.mDelegate = new CbDelegate();
        }
        this.init(activity, string3, "RV", jSONObject.optString("appID"), jSONObject.optString("appSignature"));
    }

    public void fetchRewardedVideo(JSONObject jSONObject) {
    }

    public void showRewardedVideo(JSONObject jSONObject, RewardedVideoSmashListener rewardedVideoSmashListener) {
        this.mActiveRewardedVideoSmash = rewardedVideoSmashListener;
        if (Chartboost.hasRewardedVideo("Default")) {
            Chartboost.showRewardedVideo("Default");
        } else {
            Chartboost.cacheRewardedVideo("Default");
            if (this.mActiveRewardedVideoSmash != null) {
                this.mActiveRewardedVideoSmash.onRewardedVideoAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Rewarded Video"));
            }
            for (RewardedVideoSmashListener rewardedVideoSmashListener2 : this.mAllRewardedVideoSmashes) {
                if (rewardedVideoSmashListener2 == null) continue;
                rewardedVideoSmashListener2.onRewardedVideoAvailabilityChanged(false);
            }
        }
    }

    public boolean isRewardedVideoAvailable(JSONObject jSONObject) {
        return Chartboost.hasRewardedVideo("Default");
    }

    public void initInterstitial(Activity activity, String string2, String string3, JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        if (TextUtils.isEmpty((CharSequence)jSONObject.optString("appID")) || TextUtils.isEmpty((CharSequence)jSONObject.optString("appSignature"))) {
            if (interstitialSmashListener != null) {
                interstitialSmashListener.onInterstitialInitFailed(ErrorBuilder.buildInitFailedError((String)"Missing params", (String)"Interstitial"));
            }
            return;
        }
        this.mDidCallInitInterstitial = true;
        if (this.mDelegate == null) {
            this.mDelegate = new CbDelegate();
        }
        this.init(activity, string3, "IS", jSONObject.optString("appID"), jSONObject.optString("appSignature"));
    }

    public void loadInterstitial(JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        this.mDidCallLoad = true;
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                Chartboost.cacheInterstitial("Default");
            }
        });
    }

    public void showInterstitial(JSONObject jSONObject, InterstitialSmashListener interstitialSmashListener) {
        this.mActiveInterstitialSmash = interstitialSmashListener;
        if (Chartboost.hasInterstitial("Default")) {
            Chartboost.showInterstitial("Default");
        } else if (this.mActiveInterstitialSmash != null) {
            this.mActiveInterstitialSmash.onInterstitialAdShowFailed(ErrorBuilder.buildNoAdsToShowError((String)"Interstitial"));
        }
    }

    public boolean isInterstitialReady(JSONObject jSONObject) {
        return Chartboost.hasInterstitial("Default");
    }

    private void reportInterstitialInitSuccess() {
        if (this.mDidCallInitInterstitial) {
            this.mDidCallInitInterstitial = false;
            for (InterstitialSmashListener interstitialSmashListener : this.mAllInterstitialSmashes) {
                if (interstitialSmashListener == null) continue;
                interstitialSmashListener.onInterstitialInitSuccess();
            }
        }
    }

    private void updateRVAvailability(boolean bl) {
        for (RewardedVideoSmashListener rewardedVideoSmashListener : this.mAllRewardedVideoSmashes) {
            if (rewardedVideoSmashListener == null) continue;
            rewardedVideoSmashListener.onRewardedVideoAvailabilityChanged(bl);
        }
    }

    private class CbDelegate
    extends ChartboostDelegate {
        private CbDelegate() {
        }

        @Override
        public void didDisplayRewardedVideo(String string2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "didDisplayRewardedVideo ; location: " + string2, 1);
            if (ChartboostAdapter.this.mActiveRewardedVideoSmash != null) {
                ChartboostAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdOpened();
            }
        }

        @Override
        public void didCacheRewardedVideo(String string2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "didCacheRewardedVideo ; location: " + string2, 1);
            ChartboostAdapter.this.updateRVAvailability(true);
        }

        @Override
        public void didFailToLoadRewardedVideo(String string2, CBError.CBImpressionError cBImpressionError) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "didFailToLoadRewardedVideo ; location: " + string2 + " ; error: " + cBImpressionError.toString(), 1);
            if (!Chartboost.hasRewardedVideo("Default")) {
                ChartboostAdapter.this.updateRVAvailability(false);
            } else {
                ChartboostAdapter.this.updateRVAvailability(true);
            }
        }

        @Override
        public void didDismissRewardedVideo(String string2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "didDismissRewardedVideo ; location: " + string2, 1);
        }

        @Override
        public void didCloseRewardedVideo(String string2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "didCloseRewardedVideo ; location: " + string2, 1);
            if (ChartboostAdapter.this.mActiveRewardedVideoSmash != null) {
                ChartboostAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdClosed();
            }
        }

        @Override
        public void didClickRewardedVideo(String string2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "didClickRewardedVideo ; location: " + string2, 1);
            if (ChartboostAdapter.this.mActiveRewardedVideoSmash != null) {
                ChartboostAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdClicked();
            }
        }

        @Override
        public void didCompleteRewardedVideo(String string2, int n2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "didCompleteRewardedVideo ; location: " + string2, 1);
            if (ChartboostAdapter.this.mActiveRewardedVideoSmash != null) {
                ChartboostAdapter.this.mActiveRewardedVideoSmash.onRewardedVideoAdRewarded();
            }
        }

        @Override
        public void willDisplayVideo(String string2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "willDisplayVideo ; location: " + string2, 1);
        }

        @Override
        public void didCacheInterstitial(String string2) {
            if (ChartboostAdapter.this.mDidCallLoad) {
                ChartboostAdapter.this.mDidCallLoad = false;
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "didCacheInterstitial ; location: " + string2, 1);
                for (InterstitialSmashListener interstitialSmashListener : ChartboostAdapter.this.mAllInterstitialSmashes) {
                    if (interstitialSmashListener == null) continue;
                    interstitialSmashListener.onInterstitialAdReady();
                }
            }
        }

        @Override
        public void didFailToLoadInterstitial(String string2, CBError.CBImpressionError cBImpressionError) {
            if (ChartboostAdapter.this.mDidCallLoad) {
                ChartboostAdapter.this.mDidCallLoad = false;
                IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "didFailToLoadInterstitial ; location: " + string2 + " ; error: " + cBImpressionError.toString(), 1);
                for (InterstitialSmashListener interstitialSmashListener : ChartboostAdapter.this.mAllInterstitialSmashes) {
                    if (interstitialSmashListener == null) continue;
                    interstitialSmashListener.onInterstitialAdLoadFailed(ErrorBuilder.buildLoadFailedError((String)cBImpressionError.toString()));
                }
            }
        }

        @Override
        public void didDismissInterstitial(String string2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "didDismissInterstitial ; location: " + string2, 1);
            if (ChartboostAdapter.this.mActiveInterstitialSmash != null) {
                ChartboostAdapter.this.mActiveInterstitialSmash.onInterstitialAdClosed();
            }
        }

        @Override
        public void didCloseInterstitial(String string2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "didCloseInterstitial ; location: " + string2, 1);
        }

        @Override
        public void didClickInterstitial(String string2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "didClickInterstitial ; location: " + string2, 1);
            if (ChartboostAdapter.this.mActiveInterstitialSmash != null) {
                ChartboostAdapter.this.mActiveInterstitialSmash.onInterstitialAdClicked();
            }
        }

        @Override
        public void didDisplayInterstitial(String string2) {
            IronSourceLoggerManager.getLogger().log(IronSourceLogger.IronSourceTag.INTERNAL, "didDisplayInterstitial ; location: " + string2, 1);
            if (ChartboostAdapter.this.mActiveInterstitialSmash != null) {
                ChartboostAdapter.this.mActiveInterstitialSmash.onInterstitialAdOpened();
                ChartboostAdapter.this.mActiveInterstitialSmash.onInterstitialAdShowSucceeded();
            }
        }

        @Override
        public void didInitialize() {
            ChartboostAdapter.this.mInitiatedSuccessfully = true;
            ChartboostAdapter.this.reportInterstitialInitSuccess();
        }
    }
}

