package com.yodo1ads.plugin.supersonic;

import android.app.Activity;
import android.content.Intent;
import android.os.AsyncTask;
import android.text.TextUtils;

import com.ironsource.adapters.supersonicads.SupersonicConfig;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.sdk.SSAFactory;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;


/**
 * Created by yodo1 on 2016/4/21.
 */
public class AdvertCoreSupersonic {
    private final String FALLBACK_USER_ID = "userId";
    private boolean init = false;

    private static AdvertCoreSupersonic instance;
    private AdvertCoreSupersonic(){}
    public static AdvertCoreSupersonic getInstance(){
        if(instance == null){
            instance = new AdvertCoreSupersonic();
        }
        return instance;
    }

    public void onResume(Activity activity) {
        if (TextUtils.isEmpty(AdConfigSupersonic.SUPERSONIC_ID)){
            YLog.e("Supersonic  APPID  is null");
            return;
        }
        IronSource.onResume(activity);

    }

    public void onPause(Activity activity) {
        if (TextUtils.isEmpty(AdConfigSupersonic.SUPERSONIC_ID)){
            YLog.e("Supersonic  APPID  is null");
            return;
        }
        IronSource.onPause(activity);
    }


    public void startIronSourceInitTask(final Activity activity){

        if (!init){
            init = true;
            //若插屏视频广告key一致，读取一个即可
            AdConfigSupersonic.SUPERSONIC_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigSupersonic.CHANNEL_CODE
                    , AdConfigSupersonic.KEY_SUPERSONIC_APP_ID);
            if (TextUtils.isEmpty(AdConfigSupersonic.SUPERSONIC_ID)){
                AdConfigSupersonic.SUPERSONIC_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_InterstitialAd, AdConfigSupersonic.CHANNEL_CODE
                        , AdConfigSupersonic.KEY_SUPERSONIC_APP_ID);
            }

            if (TextUtils.isEmpty(AdConfigSupersonic.SUPERSONIC_ID)){
                YLog.e("Supersonic  APPID  is null");
                return;
            }

            // getting advertiser id should be done on a background thread
            AsyncTask<Void, Void, String> task = new AsyncTask<Void, Void, String>() {
                @Override
                protected String doInBackground(Void... params) {
                    return IronSource.getAdvertiserId(activity);
                }
                @Override
                protected void onPostExecute(String advertisingId) {
                    if (TextUtils.isEmpty(advertisingId)) {
                        advertisingId = FALLBACK_USER_ID;
                    }
                    // we're using an advertisingId as the 'userId'

                    YLog.i("Supersonic  advertisingId = " + advertisingId);
                    initIronSource(activity, AdConfigSupersonic.SUPERSONIC_ID, advertisingId);
                }
            };
            task.execute();
        }

    }

    private void initIronSource(Activity activity,String appKey, String userId) {
        // IronSource Advertiser SDK call
        SSAFactory.getAdvertiserInstance().reportAppStarted(activity);
        // Be sure to set a listener to each product that is being initiated
        // set the IronSource rewarded video listener
//        IronSource.setRewardedVideoListener(activity);

        // set client side callbacks for the offerwall
        SupersonicConfig.getConfigObj().setClientSideCallbacks(true);
        // set the interstitial listener
//        IronSource.setInterstitialListener(activity);

        // set the IronSource user id
        IronSource.setUserId(userId);
        // init the IronSource SDK
        IronSource.init(activity, appKey);


        activity.sendBroadcast(new Intent(AdConfigSupersonic.ACTION));
    }

}
