package com.yodo1ads.plugin.jinshanyun;

import android.app.Activity;
import android.text.TextUtils;

import com.ks.client.ads.ADApplication;
import com.ks.client.ads.ADSDK;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.ValidateUtils;
import com.yodo1.sdk.kit.YLog;

import java.util.Arrays;
import java.util.List;

/**
 * Created by yodo1 on 17/10/27.
 */
public class AdvertCoreJinshanyun {

    private static AdvertCoreJinshanyun instance;

    public static AdvertCoreJinshanyun getInstance(){
        if(instance == null){
            instance = new AdvertCoreJinshanyun();
        }
        return instance;
    }

    private boolean isInit = false;

    public void init(Activity activity){
        if(!isInit) {
            AdConfigJinshanyun.APP_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigJinshanyun.CHANNEL_CODE
                    , AdConfigJinshanyun.KEY_JSY_APP_ID);

            if(TextUtils.isEmpty(AdConfigJinshanyun.APP_ID)){
                YLog.e("AdvertAdapterJinshanyun video APP_ID is null");
                return;
            }
            ADApplication.getInstance().init(activity, false,true);
            //应用id,当meta-data也有adsdk_appid,以方法中的参数为准.
            ADApplication.getInstance().init(activity, AdConfigJinshanyun.APP_ID, true,true);
            ADSDK.getInstance().setDebug(false).setLogSwitch(true);
            isInit = true;
        }

    }


    private boolean validate = false;
    public  void validateAdsAdapter(Activity activity){
        if(!validate) {
            List<String> jinshanActivities = Arrays.asList(new String[] { "com.ks.client.ads.AdActivity", "com.ks.permission.RequestPermissionActivity" });
            ValidateUtils.validateActivities(activity,jinshanActivities);

            List<String> jinshanService = Arrays.asList(new String[] { "com.ks.client.ads.DownloadService" });
            ValidateUtils.validateServices(activity,jinshanService);
            validate = true;
        }

    }
}
