package com.yodo1ads.plugin.chartboost;

import android.app.Activity;
import android.text.TextUtils;

import com.chartboost.sdk.Chartboost;
import com.chartboost.sdk.Libraries.CBLogging;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.sdk.kit.YLog;

/**
 * Created by yodo1 on 2016/3/22.
 */
public class AdvertCoreChartboost {
    private static AdvertCoreChartboost instance;
    private AdvertCoreChartboost(){}
    public static AdvertCoreChartboost getInstance(){
        if(instance == null){
            instance = new AdvertCoreChartboost();
        }
        return instance;
    }

    private boolean isInit = false;

    public void init(Activity activity){
        if(!isInit) {
            AdConfigChartboost.CHARTBOOST_APP_ID =   Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd
                    , AdConfigChartboost.CHANNEL_CODE, AdConfigChartboost.KEY_CHARTBOOST_APP_ID);
            AdConfigChartboost.CHARTBOOST_SIGNATURE_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd
                    , AdConfigChartboost.CHANNEL_CODE, AdConfigChartboost.KEY_CHARTBOOST_SIGNATURE_ID);

//            AdConfigChartboost.CHARTBOOST_APP_ID =   "4f7b433509b6025804000002";
//            AdConfigChartboost.CHARTBOOST_SIGNATURE_ID = "dd2d41b69ac01b80f443f5b6cf06096d457f82bd";

            if (TextUtils.isEmpty( AdConfigChartboost.CHARTBOOST_APP_ID) && TextUtils.isEmpty( AdConfigChartboost.CHARTBOOST_SIGNATURE_ID)){
                YLog.e("Chartboost  appid  is null");
                return ;
            }
            Chartboost.startWithAppId(activity, AdConfigChartboost.CHARTBOOST_APP_ID, AdConfigChartboost.CHARTBOOST_SIGNATURE_ID);
            Chartboost.setLoggingLevel(CBLogging.Level.ALL);
            Chartboost.onCreate(activity);
            Chartboost.onStart(activity);
            Chartboost.onResume(activity);
            isInit = true;
        }
    }



    public void onResume(Activity activity) {
        if (TextUtils.isEmpty( AdConfigChartboost.CHARTBOOST_APP_ID) && TextUtils.isEmpty( AdConfigChartboost.CHARTBOOST_SIGNATURE_ID)){
            YLog.e("Chartboost  appid  is null");
            return ;
        }

        Chartboost.onStart(activity);
        Chartboost.onResume(activity);
    }


    public void onPause(Activity activity) {
        if (TextUtils.isEmpty( AdConfigChartboost.CHARTBOOST_APP_ID) && TextUtils.isEmpty( AdConfigChartboost.CHARTBOOST_SIGNATURE_ID)){
            YLog.e("Chartboost  appid  is null");
            return ;
        }
        Chartboost.onPause(activity);
        Chartboost.onStop(activity);
    }


    public void onDestroy(Activity activity) {
        if (TextUtils.isEmpty( AdConfigChartboost.CHARTBOOST_APP_ID) && TextUtils.isEmpty( AdConfigChartboost.CHARTBOOST_SIGNATURE_ID)){
            YLog.e("Chartboost  appid  is null");
            return ;
        }
        Chartboost.onDestroy(activity);
    }
}
