package com.yodo1ads.adapter.video;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.text.TextUtils;

import com.yodo1ads.plugin.vungle.AdConfigVungle;
import com.yodo1ads.plugin.vungle.AdvertCoreVungle;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.advert.video.Yodo1VideoReloadCallback;
import com.yodo1.sdk.kit.YLog;

/**
 * Created by yodo1 on 2016/3/21.
 */
public class AdvertAdaptervungle extends AdVideoAdapterBase {

    @Override
    public void showVideoAdvert(final Activity activity,final Yodo1VideoCallback callback) {
        YLog.d("Vungle, showVideoAdvert");
        if (TextUtils.isEmpty( AdConfigVungle.APP_ID)){
            YLog.i("Vungle  appid  is null");
            callback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "Vungle  appid  is null", getAdvertCode());
            return ;
        }
        if (TextUtils.isEmpty(AdConfigVungle.PLACEMENTID)){
            YLog.i("Vungle video placementid is null");
            callback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "Vungle  video placementid  is null", getAdvertCode());
            return;
        }

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (videoAdvertIsLoaded(activity)) {

                    // Check a Placement if it is ready to play the Ad
                    AdvertCoreVungle.getInstance().playVideoAdvert(AdConfigVungle.PLACEMENTID,callback);
                }else {
                    callback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
                }
            }
        });
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1VideoReloadCallback reloadCallback) {
        if (TextUtils.isEmpty(AdConfigVungle.PLACEMENTID)){
            YLog.i("Vungle,  reloadVideoAdvert Video PlacementId  is null");
            return;
        }
        YLog.d("Vungle, reloadVideoAdvert");

        AdvertCoreVungle.getInstance().reloadVideoAdvert(AdConfigVungle.PLACEMENTID,reloadCallback);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {

        return  AdvertCoreVungle.getInstance().AdvertIsLoaded(activity,AdConfigVungle.PLACEMENTID);
    }

    @Override
    public String getAdvertCode() {
        return AdConfigVungle.CHANNEL_CODE;
    }

    @Override
    public void validateAdsAdapter(Activity activity) {

        AdvertCoreVungle.getInstance().validateAdsAdapter(activity);

    }



    @Override
    public void onCreateApplication(Application application) {
    }

    @Override
    public void onCreate(final Activity activity) {

        AdvertCoreVungle.getInstance().init(activity);
    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
        AdvertCoreVungle.getInstance().onResume(activity);
    }

    @Override
    public void onPause(Activity activity) {
        AdvertCoreVungle.getInstance().onPause(activity);
    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {
        AdvertCoreVungle.getInstance().onDestroy(activity);
    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
