package com.yodo1ads.adapter.video;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.tapjoy.TJActionRequest;
import com.tapjoy.TJError;
import com.tapjoy.TJPlacement;
import com.tapjoy.TJPlacementListener;
import com.tapjoy.TJPlacementVideoListener;
import com.tapjoy.Tapjoy;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.advert.video.Yodo1VideoReloadCallback;
import com.yodo1.sdk.kit.YLog;
import com.yodo1ads.plugin.tapjoy.AdConfigTapjoy;
import com.yodo1ads.plugin.tapjoy.AdvertCoreTapjoy;


/**
 * Created by houjingsheng on 2016/9/13.
 */
public class AdvertAdaptertapjoy extends AdVideoAdapterBase {
    private boolean isInitSuccess = false;
    private Yodo1VideoCallback callback;
    private Yodo1VideoReloadCallback reloadCallback;
    private TJPlacement directPlayPlacement;
    private boolean isReady;
    private boolean isConnect;

    private TJPlacementListener videoListener = new TJPlacementListener() {

        @Override
        public void onRequestSuccess(TJPlacement tjPlacement) {
            YLog.d("Tapjoy  onRequestSuccess");
        }

        @Override
        public void onRequestFailure(TJPlacement tjPlacement, TJError tjError) {
            YLog.d("Tapjoy  onRequestFailure");
            if(reloadCallback!=null){
                reloadCallback.onReload(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FAILED, getAdvertCode());
            }
        }

        @Override
        public void onContentReady(TJPlacement tjPlacement) {
            YLog.d("Tapjoy  onContentReady");
            isReady = true;
            if(reloadCallback!=null){
                reloadCallback.onReload(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onContentShow(TJPlacement tjPlacement) {
            YLog.d("Tapjoy  onContentShow");
            if(callback != null){
                callback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onContentDismiss(TJPlacement tjPlacement) {
            YLog.d("Tapjoy  onContentDismiss");
            if(callback != null){
                callback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onPurchaseRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s) {
            YLog.d("Tapjoy  onPurchaseRequest");
        }

        @Override
        public void onRewardRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s, int i) {
            YLog.d("Tapjoy  onRewardRequest");
        }
    };

    @Override
    public void showVideoAdvert(Activity activity,final Yodo1VideoCallback callback) {
        this.callback = callback;
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (directPlayPlacement != null && directPlayPlacement.isContentReady() && isReady) {
                    directPlayPlacement.showContent();

                } else {
                    callback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", AdConfigTapjoy.CHANNEL_CODE);
                }

            }
        });

        isReady = false;
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1VideoReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;
        if(TextUtils.isEmpty(AdConfigTapjoy.placementVideo)){
            YLog.e("AdvertAdapterTapjoy, placementVideo is null");
            return;
        }

        try {
            if(Tapjoy.isConnected()) {
                onConnectSuccess();
                directPlayPlacement.requestContent();
            } else {
                YLog.d("Tapjoy SDK must finish connecting before requesting content.");
            }
        }catch (Exception e){
            e.printStackTrace();
        }catch (Error e){
            e.printStackTrace();
        }

    }

    private void onConnectSuccess() {
        directPlayPlacement = Tapjoy.getPlacement(AdConfigTapjoy.placementVideo, videoListener);

        directPlayPlacement.setVideoListener(new TJPlacementVideoListener() {
            @Override
            public void onVideoStart(TJPlacement placement) {
                YLog.d("Tapjoy Video has started has started for: " + placement.getName());

            }

            @Override
            public void onVideoError(TJPlacement placement, String message) {
                YLog.d("Tapjoy Video error: " + message + " for " + placement.getName());
            }

            @Override
            public void onVideoComplete(TJPlacement placement) {
                YLog.d("Tapjoy Video has completed for: " + placement.getName());

                // Best Practice: We recommend calling getCurrencyBalance as often as possible so the user�s balance is always up-to-date.
                if(callback != null){
                    callback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_FINISH, getAdvertCode());
                    isReady = false;
                }
            }

        });

    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return isReady;
    }

    @Override
    public String getAdvertCode() {
        return AdConfigTapjoy.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(final Activity activity) {
        AdvertCoreTapjoy.getInstance().init(activity);
    }

    @Override
    public void onStart(Activity activity) {
    }

    @Override
    public void onResume(Activity activity) {
        AdvertCoreTapjoy.getInstance().onActivityStart(activity);
    }

    @Override
    public void onPause(Activity activity) {
        AdvertCoreTapjoy.getInstance().onActivityStop(activity);
    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {
    }

    @Override
    public void onDestroy(Activity activity) {
    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }


}
