package com.yodo1ads.adapter.video;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.afk.client.ads.ADSDK;
import com.afk.client.ads.AdEventListener;
import com.afk.client.ads.VideoStatus;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1ads.plugin.tad.AdConfigTad;
import com.yodo1ads.plugin.tad.AdvertCoreTad;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.advert.video.Yodo1VideoReloadCallback;
import com.yodo1.sdk.kit.ValidateUtils;
import com.yodo1.sdk.kit.YLog;

import java.util.Arrays;
import java.util.List;


/**
 * Created by houjingsheng on 2016/9/13.
 */
public class AdvertAdaptertad extends AdVideoAdapterBase {
    private boolean isLoaded = false;
    private boolean isSuccess = false;
    private Yodo1VideoCallback callback;
    private Yodo1VideoReloadCallback reloadCallback;
    private AdEventListener listener = new AdEventListener() {
        @Override
        public void onAdExist(boolean isAdExist, long code) {

        }

        @Override
        public void onVideoCached(boolean isCached) {
            isLoaded = isCached;

            if (isCached) {
                YLog.d("tad,已缓存广告视频");
                if (reloadCallback !=null){
                    reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FINISH, getAdvertCode());
                }
            }
        }

        @Override
        public void onVideoStart() {
            YLog.d("tad,开始播放");

            if (callback != null){
                callback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }

        @Override
        public void onVideoCompletion(boolean isLookBack) {
            YLog.d("tad,播放完成");
            // 可以发放奖励
            if(!isLookBack) {
                isSuccess = true;
                YLog.d("tad,奖励已发放");
            }
            if(callback != null){
                callback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }

        @Override
        public void onVideoClose(int currentPosition) {
            YLog.d("tad,关闭广告视频，当前进度[" + currentPosition / 1000 + "]秒");
            isSuccess = false;
            if(callback != null){
                callback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        @Override
        public void onVideoError(String reason) {
            YLog.i("tad,视频播放错误，错误信息[" + reason + "]");
//            if(callback != null){
//                callback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_COMMON, reason, getAdvertCode());
//            }
            isSuccess = false;
        }

        @Override
        public void onLandingPageClose(boolean status) {
            YLog.d("tad,落地页关闭");
            // 请在落地页关闭之后显示发放奖励提示
            if(isSuccess){
                if(callback != null){
                    callback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
                }
            }
            isSuccess = false;
        }

        @Override
        public void onDownloadStart() {

        }

        @Override
        public void onNetRequestError(String error) {
            isLoaded = false;
            YLog.d("网络请求错误，错误信息[" + error + "]");
        }
    };

    @Override
    public void showVideoAdvert(Activity activity, Yodo1VideoCallback callback) {
        this.callback = callback;
        isSuccess = false;

        if(TextUtils.isEmpty(AdConfigTad.appId) && TextUtils.isEmpty(AdConfigTad.adSlotId)){
            YLog.i("TAD appid is null");
            callback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
            return;
        }

        if (ADSDK.getInstance().getAdStatus(activity) == VideoStatus.HAVE_AD_AND_LOCAL_CACHE) {
            ADSDK.getInstance().showAdVideo(activity);
        } else {
            callback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_COMMON, "未成功预加载", getAdvertCode());
        }
        isLoaded = false;
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1VideoReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;
        if(TextUtils.isEmpty(AdConfigTad.appId) && TextUtils.isEmpty(AdConfigTad.adSlotId)){
            YLog.i("TAD appid is null");
            return;
        }
        ADSDK.getInstance().load(activity);

    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return ADSDK.getInstance().getAdStatus(activity) == VideoStatus.HAVE_AD_AND_LOCAL_CACHE;
    }

    @Override
    public String getAdvertCode() {
        return AdConfigTad.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {
        AdvertCoreTad.getInstance().init(application);
    }

    @Override
    public void validateAdsAdapter(Activity activity) {
        List<String> jinshanActivities = Arrays.asList(new String[] { "com.afk.client.ads.AdActivity", "com.afk.permission.RequestPermissionActivity" });
        ValidateUtils.validateActivities(activity,jinshanActivities);

        List<String> jinshanService = Arrays.asList(new String[] { "com.afk.client.ads.DownloadService" });
        ValidateUtils.validateServices(activity,jinshanService);
    }

    @Override
    public void onCreate(Activity activity) {
        AdConfigTad.appId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigTad.CHANNEL_CODE
                , AdConfigTad.KEY_APPID);

        AdConfigTad.adSlotId = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigTad.CHANNEL_CODE
                , AdConfigTad.KEY_SLOTID);

        if(TextUtils.isEmpty(AdConfigTad.appId) && TextUtils.isEmpty(AdConfigTad.adSlotId)){
            YLog.i("TAD appid is null");
            return;
        }
        ADSDK.getInstance().setDebug(false).setLogSwitch(true);

        ADSDK.getInstance().init(activity, AdConfigTad.appId, AdConfigTad.adSlotId, listener);
    }

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
        if(TextUtils.isEmpty(AdConfigTad.appId) && TextUtils.isEmpty(AdConfigTad.adSlotId)){
            YLog.d("TAD appid is null");
            return;
        }
        ADSDK.getInstance().onResume(activity);
    }

    @Override
    public void onPause(Activity activity) {
        if(TextUtils.isEmpty(AdConfigTad.appId) && TextUtils.isEmpty(AdConfigTad.adSlotId)){
            YLog.d("TAD appid is null");
            return;
        }
        ADSDK.getInstance().onPause(activity);
    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {
        if(TextUtils.isEmpty(AdConfigTad.appId) && TextUtils.isEmpty(AdConfigTad.adSlotId)){
            YLog.d("TAD appid is null");
            return;
        }
        ADSDK.getInstance().release(activity);
    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }


}
