package com.yodo1ads.adapter.video;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.ks.client.ads.ADSDK;
import com.ks.client.ads.AdEventListener;
import com.yodo1.advert.onlineconfig.Yodo1OnlineConfigAgent;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.advert.video.Yodo1VideoReloadCallback;
import com.yodo1.sdk.kit.YLog;
import com.yodo1ads.plugin.jinshanyun.AdConfigJinshanyun;
import com.yodo1ads.plugin.jinshanyun.AdvertCoreJinshanyun;

/**
 * Created by yodo1 on 17/9/21.
 */
public class AdvertAdapterjinshanyun extends AdVideoAdapterBase {

    private Yodo1VideoCallback videoCallback; //视频回调
    private Yodo1VideoReloadCallback reloadCallback;
    private boolean isLoaded;
    private boolean isSuccess = false;
    @Override
    public void showVideoAdvert(Activity activity, Yodo1VideoCallback callback) {
        this.videoCallback = callback;
        isSuccess = false;
        if(TextUtils.isEmpty(AdConfigJinshanyun.APP_ID) && TextUtils.isEmpty(AdConfigJinshanyun.SLOT_ID)){
            YLog.i("jinshanyun appid is null");
            callback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
            return;
        }
        if (isLoaded) {
            ADSDK.getInstance().showAdVideo(activity);
        } else {
            callback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
        }
        isLoaded = false;
    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1VideoReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;
        if(TextUtils.isEmpty(AdConfigJinshanyun.APP_ID) && TextUtils.isEmpty(AdConfigJinshanyun.SLOT_ID)){
            YLog.i("jinshanyun appid is null");
            return;
        }
        ADSDK.getInstance().load(activity);
    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        return isLoaded;
    }
    @Override
    public void validateAdsAdapter(Activity activity) {
        AdvertCoreJinshanyun.getInstance().validateAdsAdapter(activity);
    }
    @Override
    public String getAdvertCode() {
        return AdConfigJinshanyun.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {
        AdConfigJinshanyun.SLOT_ID = Yodo1OnlineConfigAgent.getKeyConfigParam(Yodo1OnlineConfigAgent.AdvertType.Platform_VideoAd, AdConfigJinshanyun.CHANNEL_CODE
                , AdConfigJinshanyun.KEY_JSY_SLOT_ID);

        AdvertCoreJinshanyun.getInstance().init(activity);

        if (TextUtils.isEmpty( AdConfigJinshanyun.SLOT_ID) && TextUtils.isEmpty( AdConfigJinshanyun.APP_ID)){
            YLog.e("jinshanyun  interstitialId  is null");
            return ;
        }
        YLog.d("AdvertAdapterJinshanyun AdConfigJinshanyun.SLOT_ID ==" + AdConfigJinshanyun.SLOT_ID);
        ADSDK.getInstance().init(activity, AdConfigJinshanyun.APP_ID, AdConfigJinshanyun.SLOT_ID, videoListener);
    }

    AdEventListener videoListener = new AdEventListener() {
        /**
         * @param isAdExist 有广告为true,反之false * @param code 错误码
         */
        @Override
        public void onAdExist(boolean isAdExist, long l) {
            YLog.i("AdvertAdapterJinshanyun video onAdExist isAdExist ==" + isAdExist);

        }
        /**
         * @param isCached 已缓存为true,反之false
         */
        @Override
        public void onVideoCached(boolean isCached) {
            YLog.d("AdvertAdapterJinshanyun video onVideoCached isCached==" + isCached);
            isLoaded = isCached;
            if(isCached){
                if (reloadCallback !=null){
                    reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FINISH, getAdvertCode());
                }
            } else {
                if (reloadCallback !=null){
                    reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FAILED, getAdvertCode());
                }
            }
        }
        /**
         * 开始播放视频 */
        @Override
        public void onVideoStart() {
            YLog.d("AdvertAdapterJinshanyun video  onVideoStart");
            if (videoCallback!=null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }
        }
        /**
         * 视频播放完成
         * @param isLookBack 是否回看,true为回看,不发奖励;false为第一次看,发奖励
         */
        @Override
        public void onVideoCompletion(boolean isLookBack) {
            YLog.d("AdvertAdapterJinshanyun video onVideoCompletion isLookBack==" + isLookBack);
            if(!isLookBack) {
                isSuccess = true;
            }
            if (videoCallback!=null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_FINISH, getAdvertCode());
            }
        }
        /**
         * 关闭广告
         * @param currentPosition 当前播放进度
         */
        @Override
        public void onVideoClose(int currentPosition) {
            YLog.d("AdvertAdapterJinshanyun video  onVideoClose");
            isSuccess = false;
            if (videoCallback!=null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
            }
        }

        /**
         * @param reason 错误原因
         */
        @Override
        public void onVideoError(String reason) {
            YLog.i("AdvertAdapterJinshanyun video onVideoError reason==" + reason);
            isSuccess = false;
            if (videoCallback!=null){
                videoCallback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_COMMON, reason, getAdvertCode());
            }
        }

        /**
         * 落地页关闭
         * @param status 直接关闭为false,点击下载关闭为true
         */
        @Override
        public void onLandingPageClose(boolean status) {
            YLog.d("AdvertAdapterJinshanyun video onLandingPageClose status==" + status);
            if(isSuccess){
                if(videoCallback != null){
                    videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
                }
                YLog.i("AdvertAdapterJinshanyun 广告播放完成，发放奖励");
            }
            isSuccess = false;
        }

        /**
         * 开始下载 */
        @Override
        public void onDownloadStart() {
            YLog.i("AdvertAdapterJinshanyun video onDownloadStart");
        }

        /**
         * 网络错误
         * @param error 错误原因
         */
        @Override
        public void onNetRequestError(String error) {
            YLog.i("AdvertAdapterJinshanyun video onNetRequestError error==" + error);
            if (videoCallback!=null){
                videoCallback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_COMMON, error, getAdvertCode());
            }
        }
    };

    @Override
    public void onStart(Activity activity) {

    }

    @Override
    public void onResume(Activity activity) {
        ADSDK.getInstance().onResume(activity);
    }

    @Override
    public void onPause(Activity activity) {
        ADSDK.getInstance().onPause(activity);
    }

    @Override
    public void onRestart(Activity activity) {

    }

    @Override
    public void onStop(Activity activity) {

    }

    @Override
    public void onDestroy(Activity activity) {
        ADSDK.getInstance().release(activity);
    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }
}
