package com.yodo1ads.adapter.video;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.text.TextUtils;

import com.chartboost.sdk.Chartboost;
import com.chartboost.sdk.ChartboostDelegate;
import com.chartboost.sdk.Model.CBError;
import com.yodo1ads.plugin.chartboost.AdConfigChartboost;
import com.yodo1ads.plugin.chartboost.AdvertCoreChartboost;
import com.yodo1.advert.video.AdVideoAdapterBase;
import com.yodo1.advert.video.Yodo1VideoCallback;
import com.yodo1.advert.video.Yodo1VideoReloadCallback;
import com.yodo1.sdk.kit.YLog;

/**
 * Created by yodo1 on 2016/4/7.
 */
public class AdvertAdapterchartboost extends AdVideoAdapterBase {
    private Yodo1VideoCallback videoCallback; //视频回调
    private Yodo1VideoReloadCallback reloadCallback; //视频预加载回调

    @Override
    public void showVideoAdvert(Activity activity, Yodo1VideoCallback callback) {
        this.videoCallback = callback;
        YLog.d("Chartboost, showRewardVideo ...");
        if (videoAdvertIsLoaded(activity)){
            Chartboost.showRewardedVideo("default");
        } else {
            if(callback != null){
                videoCallback.onAdError(Yodo1VideoCallback.ADVERT_ERROR_LOADED_FAILED, "未成功预加载", getAdvertCode());
            }
        }

    }

    @Override
    public void reloadVideoAdvert(Activity activity, Yodo1VideoReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;
        YLog.d("Chartboost, reloadVideoAdvert ...");
        if (TextUtils.isEmpty( AdConfigChartboost.CHARTBOOST_APP_ID) && TextUtils.isEmpty( AdConfigChartboost.CHARTBOOST_SIGNATURE_ID)){
            YLog.e("Chartboost  appid  is null");
            return ;
        }
        Chartboost.cacheRewardedVideo("default");

    }

    @Override
    public boolean videoAdvertIsLoaded(Activity activity) {
        if (TextUtils.isEmpty( AdConfigChartboost.CHARTBOOST_APP_ID) && TextUtils.isEmpty( AdConfigChartboost.CHARTBOOST_SIGNATURE_ID)){
            YLog.e("Chartboost  appid  is null");
            return false;
        }
        YLog.d("Chartboost, videoAdvertIsLoaded ==" + Chartboost.hasRewardedVideo("default"));
        return Chartboost.hasRewardedVideo("default");
    }

    @Override
    public String getAdvertCode() {
        return AdConfigChartboost.CHANNEL_CODE;
    }

    @Override
    public void onCreateApplication(Application application) {

    }

    @Override
    public void onCreate(Activity activity) {

        AdvertCoreChartboost.getInstance().init(activity);
        Chartboost.setDelegate(delegate);
    }

    @Override
    public void onStart(Activity activity) {
    }

    @Override
    public void onResume(Activity activity) {
        AdvertCoreChartboost.getInstance().onResume(activity);

    }

    @Override
    public void onPause(Activity activity) {
        AdvertCoreChartboost.getInstance().onPause(activity);
    }

    @Override
    public void onRestart(Activity activity) {
    }

    @Override
    public void onStop(Activity activity) {
    }

    @Override
    public void onDestroy(Activity activity) {
        AdvertCoreChartboost.getInstance().onDestroy(activity);
    }

    @Override
    public void onActivityResult(Activity activity, int requestCode, int resultCode, Intent data) {

    }

    @Override
    public void onNewIntent(Activity activity, Intent intent) {

    }



    private ChartboostDelegate delegate = new ChartboostDelegate() {

        @Override
        public boolean shouldRequestInterstitial(String location) {
            YLog.d("Chartboost shouldRequestInterstitial, location = " + location);
            return true;
        }

        @Override
        public boolean shouldDisplayInterstitial(String location) {
            YLog.d("Chartboost shouldDisplayInterstitial, location = " + location);
            return true;
        }

        @Override
        public void didCacheInterstitial(String location) {
            YLog.d("Chartboost didCacheInterstitial, location = " + location);
        }

        @Override
        public void didFailToLoadInterstitial(String location, CBError.CBImpressionError error) {
            YLog.e("Chartboost didFailToLoadInterstitial, location = " + location);
        }

        @Override
        public void didDismissInterstitial(String location) {
            YLog.d("Chartboost didDismissInterstitial, location = " + location);
        }

        @Override
        public void didCloseInterstitial(String location) {
            YLog.d("Chartboost didCloseInterstitial, location = " + location);
        }

        @Override
        public void didClickInterstitial(String location) {
            YLog.d("Chartboost didClickInterstitial, location = " + location);
        }

        @Override
        public void didDisplayInterstitial(String location) {
            YLog.d("Chartboost didDisplayInterstitial, location = " + location);
        }

        @Override
        public boolean shouldRequestMoreApps(String location) {
            YLog.d("Chartboost shouldRequestMoreApps, location = " + location);
            return true;
        }

        @Override
        public boolean shouldDisplayMoreApps(String location) {
            YLog.d("Chartboost shouldDisplayMoreApps, location = " + location);
            return true;
        }

        @Override
        public void didFailToLoadMoreApps(String location, CBError.CBImpressionError error) {
            YLog.d("Chartboost didFailToLoadMoreApps, location = " + location);
        }

        @Override
        public void didCacheMoreApps(String location) {
            YLog.d("Chartboost didCacheMoreApps, location = " + location);
        }

        @Override
        public void didDismissMoreApps(String location) {
            YLog.d("Chartboost didDismissMoreApps, location = " + location);
        }

        @Override
        public void didCloseMoreApps(String location) {
            YLog.d("Chartboost didCloseMoreApps, location = " + location);
        }

        @Override
        public void didClickMoreApps(String location) {
            YLog.d("Chartboost didClickMoreApps, location = " + location);
        }

        @Override
        public void didDisplayMoreApps(String location) {
            YLog.d("Chartboost didDisplayMoreApps, location = " + location);
        }

        @Override
        public void didFailToRecordClick(String uri, CBError.CBClickError error) {
            YLog.d("Chartboost didFailToRecordClick, error = " + error + ", uri = " + uri);
        }

        @Override
        public boolean shouldDisplayRewardedVideo(String location) {
            YLog.d("Chartboost shouldDisplayRewardedVideo, location = " + location);
            return true;
        }

        @Override
        public void didCacheRewardedVideo(String location) {
            YLog.d("Chartboost didCacheRewardedVideo, location = " + location);

            if (reloadCallback != null){
                reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FINISH,getAdvertCode());
            }
        }

        @Override
        public void didFailToLoadRewardedVideo(String location,
                                               CBError.CBImpressionError error) {
            YLog.e("Chartboost didFailToLoadRewardedVideo, location = " + location + ", error = " + error);
            if(reloadCallback != null){
                reloadCallback.onResult(Yodo1VideoReloadCallback.ADVERT_VIDEO_RELOAD_FAILED,getAdvertCode());
            }


        }

        @Override
        public void didDismissRewardedVideo(String location) {
            YLog.d("Chartboost didDismissRewardedVideo, location = " + location);
        }

        @Override
        public void didCloseRewardedVideo(String location) {
            YLog.d("Chartboost didCloseRewardedVideo, location = " + location);
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLOSE, getAdvertCode());
            }

        }

        @Override
        public void didClickRewardedVideo(String location) {
            YLog.d("Chartboost didClickRewardedVideo, location = " + location);
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_CLICK, getAdvertCode());
            }

        }

        @Override
        public void didCompleteRewardedVideo(String location, int reward) {
            YLog.d("Chartboost didCompleteRewardedVideo, location = " + location + ", reward = " +reward);
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_FINISH, getAdvertCode());
            }

        }

        @Override
        public void didDisplayRewardedVideo(String location) {
            YLog.d("Chartboost didDisplayRewardedVideo, location = " + location);
            if(videoCallback != null){
                videoCallback.onEvent(Yodo1VideoCallback.ADVERT_EVENT_DISPLAY, getAdvertCode());
            }

        }

        @Override
        public void willDisplayVideo(String location) {
            YLog.d("Chartboost willDisplayVideo, location = " + location);
        }

    };
}
